// Author: Zelea
// Date: 14 April 2007
// License: http://www.gnu.org/licenses/gpl.txt

#define GAME_VERSION "Four Rivers v1.1 - by Zelea"

typedef unsigned char u08;
typedef unsigned short u16;
typedef unsigned long u32;

#define TILEX           12
#define TILEY           7
#define TILESNR ( TILEX * TILEY / 4 )

#define FAME            20
#define MAXTIME         3599

#ifdef Nokia
#define FULL_SCREEN	1
#define RIVERS_INI    "/home/user/rivers.ini"
#define TILES_FILE    "/usr/share/rivers/rivers_TilesN.jpg"
#else
#define FULL_SCREEN	0
#define RIVERS_INI    "rivers.ini"
#define TILES_FILE    "images/rivers_TilesN.jpg"
#endif

struct sButton
{
  char         *name;
  int           fill;
  int           on;
  int           pressed;
  int           txtx;
  int           x1;
  int           x2;
  int           y1;
  int           y2;
};

struct sStatus
{
  char         *field;
  int           fill;
  int           format;
  int          *val;
  int           hval;
};

struct sPair
{
  int           tile;
  int           x1;
  int           y1;
  int           x2;
  int           y2;
  int           xx;
  int           yx;
};

extern struct sPair SP[];
extern int    hall[];
extern int    lastx, lasty;
extern int    pairs, left;
extern int    board[TILEX + 2][TILEY + 2];
extern char  *TilesFile;
extern int    best_seconds, worst_seconds;
extern char  *ColorMenu, *ColorSelect, *ColorBkg, *ColorFont;
extern char  *FontNormal, *FontBold, *FontTitle, *FontPause;
extern int    tiles_select[];
extern int    TilesCols, TilesRows;
extern int    cheat, sound;

/* sounds.c */
void          play_sound( int nr );

/* loadjpg.c */
int           read_JPEG( unsigned char **raster, char *fname );

/* ini_file.c */
void          read_ini( char *fname );
void          write_ini( char *fname );

/* game.c */
void          find_pairs( void );
void          shuffle_board( void );
int           new_board( void );
int           check_remove( int x, int y );

/* rivers.c */
void          set_hall_times( void );

/* justify.c */
void          justify_about( int x1, int y1, int x2, int y2 );
