// Author: Zelea
// Date: 07 August 2007
// License: http://www.gnu.org/licenses/gpl.txt

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "rivers.h"

// Store and read various variables from the 'ini' file
// This file can be edited to personalize tiles, colors, fonts etc.

char         *TilesFile;
int           best_seconds, worst_seconds;
char         *ColorMenu, *ColorSelect, *ColorBkg, *ColorFont;
char         *FontNormal, *FontBold, *FontTitle, *FontPause;
int           tiles_select[TILESNR];
int           TilesCols, TilesRows;
int           cheat;
int           sound = 1;

enum key_type
{
  KSND, KCHEAT, KTS, KTF, KTC, KTR, KCM, KCS, KCB, KCF, KFN, KFB, KFT, KFP,
  KHF,
};
char         *keywords[] = {
  "Sounds",
  "Cheat",
  "TilesSelect",
  "TilesFile",
  "TilesColumns",
  "TilesRows",
  "ColorMenu",
  "ColorSelect",
  "ColorBkg",
  "ColorFont",
  "FontNormal",
  "FontBold",
  "FontTitle",
  "FontPause",
  "HallOfFame",
};
int           max_keywords = sizeof( keywords ) / sizeof( char * );

void
read_ini( char *fname )
{
  FILE         *f;
  int           i;
  char         *p;
  char          line[128];
  int           my_tiles[TILESNR] = {
    0, 1, 2, 3, 6, 7, 8, 10, 11, 12, 13,
    14, 15, 16, 17, 18, 19, 23, 24, 25, 26
  };

  best_seconds = worst_seconds = MAXTIME;
  for ( i = 0; i < FAME + 1; i++ )
    hall[i] = MAXTIME;
  for ( i = 0; i < TILESNR; i++ )
    tiles_select[i] = my_tiles[i];
  TilesFile = TILES_FILE;
  TilesCols = 6;
  TilesRows = 5;
  ColorMenu = "goldenrod";
  ColorSelect = "magenta";
  ColorBkg = "khaki";
  ColorFont = "black";
  FontNormal = "Courier-14";
  FontBold = "Helvetica-14:bold";
  FontTitle = "Helvetica-30";
  FontPause = "Helvetica-120";

  if ( ( f = fopen( fname, "r" ) ) == NULL )
    return;
  while ( fgets( line, 127, f ) )
  {
    for ( i = 0; i < max_keywords; i++ )
      if ( !strncmp( line, keywords[i], strlen( keywords[i] ) ) )
	break;
    if ( i == max_keywords )
      continue;
    if ( ( p = strrchr( line, '\n' ) ) != NULL )
      *p = 0;
    if ( ( p = strchr( line + strlen( keywords[i] ), '=' ) ) == NULL )
      continue;
    p++;
    while ( *p == ' ' || *p == '\t' )
      p++;
    switch ( i )
    {
      case KSND:
	if ( sscanf( p, "%d", &i ) == 1 )
	  sound = i;
	break;
      case KCHEAT:
	if ( sscanf( p, "%d", &i ) == 1 )
	  cheat = i;
	break;
      case KTC:
	if ( sscanf( p, "%d", &i ) == 1 )
	  TilesCols = i;
	break;
      case KTR:
	if ( sscanf( p, "%d", &i ) == 1 )
	  TilesRows = i;
	break;
      case KTS:
	for ( i = 0; i < TILESNR; i++ )
	{
	  if ( sscanf( p, "%d", &tiles_select[i] ) != 1 )
	    break;
	  while ( *p != ' ' && *p != '\t' )
	    p++;
	  while ( *p == ' ' || *p == '\t' )
	    p++;
	}
	break;
      case KTF:
	TilesFile = strdup( p );
	break;
      case KCM:
	ColorMenu = strdup( p );
	break;
      case KCS:
	ColorSelect = strdup( p );
	break;
      case KCB:
	ColorBkg = strdup( p );
	break;
      case KCF:
	ColorFont = strdup( p );
	break;
      case KFN:
	FontNormal = strdup( p );
	break;
      case KFB:
	FontBold = strdup( p );
	break;
      case KFT:
	FontTitle = strdup( p );
	break;
      case KFP:
	FontPause = strdup( p );
	break;
      case KHF:
	for ( i = 0; i < FAME; i++ )
	{
	  if ( sscanf( p, "%d", &hall[i] ) != 1 )
	    break;
	  while ( *p != ' ' && *p != '\t' )
	    p++;
	  while ( *p == ' ' || *p == '\t' )
	    p++;
	}
	break;
    }
  }
  set_hall_times(  );
  fclose( f );
}

void
write_ini( char *fname )
{
  FILE         *f;
  int           i;

  if ( ( f = fopen( fname, "w" ) ) == NULL )
    return;

  fprintf( f, "%s = %d\n", keywords[KSND], sound );
  fprintf( f, "%s = %d\n", keywords[KCHEAT], cheat );
  fprintf( f, "\n%s = %s\n", keywords[KTF], TilesFile );
  fprintf( f, "%s = ", keywords[KTS] );
  for ( i = 0; i < TILESNR; i++ )
    fprintf( f, "%d ", tiles_select[i] );
  fprintf( f, "\n%s = %d\n", keywords[KTC], TilesCols );
  fprintf( f, "%s = %d\n", keywords[KTR], TilesRows );
  fprintf( f, "\n%s = %s\n", keywords[KCM], ColorMenu );
  fprintf( f, "%s = %s\n", keywords[KCS], ColorSelect );
  fprintf( f, "%s = %s\n", keywords[KCB], ColorBkg );
  fprintf( f, "%s = %s\n", keywords[KCF], ColorFont );
  fprintf( f, "\n%s = %s\n", keywords[KFN], FontNormal );
  fprintf( f, "%s = %s\n", keywords[KFB], FontBold );
  fprintf( f, "%s = %s\n", keywords[KFT], FontTitle );
  fprintf( f, "%s = %s\n", keywords[KFP], FontPause );
  fprintf( f, "\n%s = ", keywords[KHF] );
  for ( i = 0; i < FAME; i++ )
    if ( hall[i] != MAXTIME )
      fprintf( f, "%d ", hall[i] );
  fprintf( f, "\n\n" );
  fclose( f );
}
