/*
 * Adapted from the OSS driver
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sched.h>
#include <esd.h>

#include "../sexyal.h"
#include "../md5.h"
#include "../smallc.h"

#include "esd.h"

static int buffersize;
static int bufferfree;


SexyAL_device *SexyALI_ESD_Open(uint64_t id, SexyAL_format *format, SexyAL_buffering *buffering)
{
 SexyAL_device *device = NULL;
 int fd = -1;
 unsigned int temp = 0;

//  if(format->sampformat == SEXYAL_FMT_PCMU8 || format->sampformat == SEXYAL_FMT_PCMS8){
//   temp=ESD_BITS8;
//   format->sampformat = SEXYAL_FMT_PCMU8; /* ESD doesn't seem to handle signed data well */
//  } else {
//   temp=ESD_BITS16;
//   format->sampformat = SEXYAL_FMT_PCMU16; /* ESD doesn't seem to handle signed data well */
//  }

 temp=ESD_BITS8;
 format->sampformat = SEXYAL_FMT_PCMU8;

 temp |= ESD_MONO;
 format->channels = 1;

 format->rate = 8192;

// if(1 == format->channels){
// 	temp |= ESD_MONO;
// }else{ /* ESD doesn't seem to handle >2 channels */
// 	temp |= ESD_STEREO;
//	format->channels = 2;
// }/* switch on channels */

 #ifndef LSB_FIRST
 format->byteorder=1;
 #else
 format->byteorder=0;
 #endif

 if(0 >= (fd = esd_play_stream(temp, format->rate, NULL, "fceu"))){
	 printf("Unable to connect to esd: %d\n",fd);
	 return 0;
 }/* connect to esd */


 /* Create SexyAL device */
 device=malloc(sizeof(SexyAL_device));
 sal_memcpy(&device->format,format,sizeof(SexyAL_format));
 sal_memcpy(&device->buffering,buffering,sizeof(SexyAL_buffering));

 if(buffering->fragcount == 0 || buffering->fragsize == 0)
 {
  buffering->fragcount=16;
  buffering->fragsize=64;
 }
 else
 {
  if(buffering->fragsize<32) buffering->fragsize=32;
  if(buffering->fragcount<2) buffering->fragcount=2;
 }
 buffering->totalsize=buffering->fragsize*buffering->fragcount;
 
 if(buffering->ms)
 {
  int64_t tc;

  tc=2*buffering->ms * format->rate / 1000 / buffering->fragsize;
  buffering->fragcount=(tc>>1)+(tc&1);
 }
 buffering->totalsize = buffering->fragsize * buffering->fragcount;
 bufferfree = buffersize = buffering->totalsize;

 device->private=malloc(sizeof(int));
 *(int*)device->private=fd;

 return(device);
}


int SexyALI_ESD_Close(SexyAL_device *device)
{
 if(device)
 {
  if(device->private) 
  {
   close(*(int*)device->private);
   free(device->private);
  }
  free(device);
  return(1);
 }
 return(0);
}


uint32_t SexyALI_ESD_RawCanWrite(SexyAL_device *device)
{
 /* ESD can always write */
 return bufferfree;
}


uint32_t SexyALI_ESD_RawWrite(SexyAL_device *device, void *data, uint32_t len)
{
 ssize_t bytes = write(*(int *)device->private,data,len);
 if(bytes<0){ bytes=0; }

 bufferfree = (bufferfree-bytes<0) ? buffersize : bufferfree-bytes;

 return(bytes);
}
