/*
 * Adapted from the OSS driver
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sched.h>
#include <gst/gst.h>
#include <pthread.h>

#include "../sexyal.h"
#include "../md5.h"
#include "../smallc.h"

#include "gst.h"

static int datapipe[2];
static GstElement *pipeline,*fdsrc, *audiosink, *flt;
static GstCaps *caps;
//static GstQueue *queue;
static pthread_t t;

static void* play(void *nothing){
 gst_element_set_state (pipeline, GST_STATE_PLAYING);
 return NULL;
}


SexyAL_device *SexyALI_GST_Open(uint64_t id, SexyAL_format *format, SexyAL_buffering *buffering)
{
 SexyAL_device *device = NULL;
 //GMainLoop *loop;
 int bits = 8;
 int wbits = 16;
 int usesigned = 0;

 pipe(datapipe);

 format->sampformat = SEXYAL_FMT_PCMU8;

 printf("Got initial format: format %d, channels %d, rate %d\n",format->sampformat, format->channels, format->rate);

 switch(format->sampformat){
	 case SEXYAL_FMT_PCMU8:
		bits=8;
		wbits=8;
		usesigned=0;
		break;
	 case SEXYAL_FMT_PCMS8:
		bits=8;
		wbits=8;
		usesigned=1;
		break;
	case SEXYAL_FMT_PCMU16:
		bits=16;
		wbits=16;
		usesigned=0;
		break;
	case SEXYAL_FMT_PCMS16:
		bits=16;
		wbits=16;
		usesigned=1;
		break;
	case SEXYAL_FMT_PCMU32U24:
		bits=32;
		wbits=24;
		usesigned=0;
		break;
	case SEXYAL_FMT_PCMS32S24:
		bits=32;
		wbits=24;
		usesigned=1;
		break;

	case SEXYAL_FMT_PCMU32U16:
		bits=32;
		wbits=16;
		usesigned=0;
		break;
	case SEXYAL_FMT_PCMS32S16:
		bits=32;
		wbits=16;
		usesigned=1;
		break;
 }

 //format->sampformat = SEXYAL_FMT_PCMS8;
 //format->channels = 1;
 //format->rate = 11025;

//  #ifndef LSB_FIRST
//  format->byteorder=1;
//  #else
 format->byteorder=0;
// #endif
 
 /* Create SexyAL device */
 device=malloc(sizeof(SexyAL_device));
 sal_memcpy(&device->format,format,sizeof(SexyAL_format));
 sal_memcpy(&device->buffering,buffering,sizeof(SexyAL_buffering));

 if(buffering->fragcount == 0 || buffering->fragsize == 0)
 {
  buffering->fragcount=16;
  buffering->fragsize=64;
 }
 else
 {
  if(buffering->fragsize<32) buffering->fragsize=32;
  if(buffering->fragcount<2) buffering->fragcount=2;
 }
 buffering->totalsize=buffering->fragsize*buffering->fragcount;
 
 if(buffering->ms)
 {
  int64_t tc;

  tc=2*buffering->ms * format->rate / 1000 / buffering->fragsize;
  buffering->fragcount=(tc>>1)+(tc&1);
 }

// buffering->fragcount = 32;
// buffering->fragsize = 1024;
 buffering->totalsize = buffering->fragsize * buffering->fragcount;

 device->private=malloc(sizeof(int));
 *(int*)device->private=datapipe[1];

 /* init GStreamer */
 gst_init (NULL, NULL);
 //loop = g_main_loop_new (NULL, FALSE);
 
 /* setup pipeline */
 pipeline = gst_pipeline_new ("pipeline");
 fdsrc = gst_element_factory_make ("fdsrc", "fdsrc");
 audiosink = gst_element_factory_make ("dsppcmsink", "dsppcmsink");
 flt = gst_element_factory_make ("capsfilter", "capsfilter");
 //queue = gst_queue_new();
 caps = gst_caps_new_simple ("audio/x-raw-int",
		"rate", G_TYPE_INT, format->rate,
		"channels", G_TYPE_INT, format->channels,
		"endianness", G_TYPE_INT, G_BYTE_ORDER,
		"depth", G_TYPE_INT, bits, 
		"width", G_TYPE_INT, bits,
		"signed", G_TYPE_BOOLEAN, usesigned, NULL);
 if(!caps){
	 printf("Unable to create audio GstCaps\n");
 }
 g_object_set(G_OBJECT(flt),"caps",caps,NULL);
 //g_object_set(G_OBJECT(queue), "max-size-bytes", buffering->totalsize, NULL);
 
 gst_bin_add_many (GST_BIN (pipeline), fdsrc, flt, audiosink, NULL);
 if(!gst_element_link_filtered(fdsrc, audiosink, caps)){
	 //printf("Unable to link source and destination\n");
	 if(gst_element_link_many(fdsrc,flt,audiosink)){
		 printf("Unable to link unfiltered\n");
	 }
 }
 
 /* setup data source */
 g_object_set (G_OBJECT (fdsrc),
	 "fd", datapipe[0],
	 NULL);
 
 /* play */
 gst_element_set_state (pipeline, GST_STATE_PLAYING);

 //printf("Starting g_main_loop\n");
 //pthread_create(&t,NULL,play,NULL);
 //g_main_loop_run (loop);
 //printf("Done starting g_main_loop\n");
 
 return(device);
}


int SexyALI_GST_Close(SexyAL_device *device)
{
 /* clean up */
 gst_element_set_state (pipeline, GST_STATE_NULL);
 gst_object_unref (GST_OBJECT (pipeline));
 //pthread_kill(t, 9);

 if(device)
 {
  if(device->private) 
  {
   close(datapipe[0]);
   close(datapipe[1]);
   free(device->private);
  }
  free(device);
  return(1);
 }
 return(0);
}


uint32_t SexyALI_GST_RawCanWrite(SexyAL_device *device)
{
 /* GST can always write */
 return 0;
}


uint32_t SexyALI_GST_RawWrite(SexyAL_device *device, void *data, uint32_t len)
{
 ssize_t bytes;

 bytes = write(*(int *)device->private,data,len);
 if(bytes <= 0) return(0);			/* FIXME:  What to do on -1? */
 return(bytes);
}
