/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef OBEX_CLIENT_H
#define OBEX_CLIENT_H

#include "obex_app.h"

void client_done(obex_t *handle, obex_object_t *object, int obex_cmd, int obex_rsp);

void connect_client(obex_t *handle);
void connect_client_done(obex_t *handle, obex_object_t *object, int obex_rsp);

void disconnect_client(obex_t *handle);
void disconnect_client_done(obex_t *handle, obex_object_t *object, int obex_rsp);

int fillstream(obex_t *handle, obex_object_t *object);
void put_client_buffered(obex_t *handle);
void put_client_done(obex_t *handle, obex_object_t *object, int obex_rsp);


void setpath_client(obex_t *handle);
void setpath_client_done(obex_t *handle, obex_object_t *object, int obex_rsp);

#endif
