/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef OBEX_APP_H
#define OBEX_APP_H
#include "btxfer.h"
#define TRUE  1
#define FALSE 0

#define IR_SERVICE "OBEX"
#define BT_CHANNEL 4

typedef struct 
{
	int serverdone;
	int clientdone;
	char *get_name;	/* Name of last get-request */
    bdaddr_t bdaddr;
    uint8_t channel;
    void* user_data;
}obex_app_context;

int obex_xfer_init (int bt_channel, 
                    char *bt_address,
                    obex_t **obex_handle, 
                    void* user_data);
int obex_xfer_transport_connect (obex_t *obex_handle);
int obex_xfer_transport_disconnect (obex_t *obex_handle);
int obex_xfer_connect (obex_t *obex_handle);
int obex_xfer_send (obex_t *obex_handle);
int obex_xfer_disconnect (obex_t *obex_handle);
void cleanup_xfer_transfer(btxfer_state* state, int mode);

/* callback from the obex stack */
void obex_event(obex_t *handle, obex_object_t *object, int mode, int event, int obex_cmd, int obex_rsp);

#endif
