/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "btxfer.h"
#include "obex_app.h"
#include "callbacks.h"

void cleanup_btdevices(gpointer data,
                       gpointer user_data);

int
main (int argc, char *argv[])
{
  GtkWidget *btxfer;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /*
  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  */
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  btxfer_state state;
  memset(&state, 0, sizeof(state));
  /* configuration */
  /* @todo : should have a configuration file */
  state.xfer_receive_file_dir = XFER_RECV_DIR;

  /* initialize thread system and create mutex */   
  if (!g_thread_supported ()) 
  {
    g_thread_init (NULL);
    /* as we would be making call to gtk from another thread */
    gdk_threads_init();
  }
  if(state.bt_send_xfer_mutex == NULL){
    state.bt_send_xfer_mutex = g_mutex_new(); 
    /*
    state.bt_send_xfer_cond = g_cond_new();
    */
  }
  /* lets create the receive thread */
  state.bt_receive_xfer_thread = g_thread_create(thread_func_receive_xfer,
                                    &state,
                                    FALSE,
                                    &state.bt_receive_xfer_error);
  btxfer = create_btxfer (&state);
  state.bt_main_widget = btxfer;
  state.obex_ui_event = obex_ui_update_event;
  gtk_widget_show (btxfer);

  gtk_main ();
  /* here we need to clean up */
  g_slist_foreach(state.bt_devices, cleanup_btdevices, NULL);
  /* free the list itself */
  g_slist_free(state.bt_devices);
  /*@todo : need to clean state like mutex etc and
            also if the transfer is in way, need a
            way to abort */
  /* need to exit from the server */
  if(state.bt_receive_obex_handle){
    state.receive_xfer_exit = TRUE;
    obex_app_context *gt;
    gt = OBEX_GetUserData(state.bt_receive_obex_handle);
    gt->serverdone = TRUE;
  }
  return 0;
}

void cleanup_btdevices(gpointer data,
                       gpointer user_data)
{
    bt_device* device = (bt_device*)data;
    free(device->bt_address);
    free(device->bt_name);
    free(device);
}
