/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef _BTXFER_
#define _BTXFER_

#include <stdio.h>
#include <gtk/gtk.h>
#include <openobex/obex.h>

/* event code for UI */
#define CLIENT_EVENT_PUT_START 1
#define CLIENT_EVENT_PUT_CONT 2
#define CLIENT_EVENT_REQ_DONE 3

/* function declaration for handling UI events
   args (...) as each UI event send different data
*/
typedef void (*func_obex_ui_event)(int code, ...);

/* chunk size for buffered read */
#define OBEX_STREAM_CHUNK       4096

/* @todo : this should be configurable
- conf file for storage directory
- conf file for last seen bt devices 
- hci tool and command
*/

#define XFER_RECV_DIR "/tmp/"
#define HCITOOL "hcitool"
#define CMD_SCAN "scan"

#if 0
/* hardcoded stuff for maemo */
#define XFER_RECV_DIR "/home/user/MyDocs/"
#define HCITOOL "/var/lib/install/usr/bin/hcitool"
#endif

typedef struct{
    char* bt_address;
    char* bt_name;
    /* buffer used while sending */
    uint8_t *buffer;
    int fd;
    /* this keep track of the OBEX session with the device */
    obex_t *obex_handle;
    /* name of the file to send. included the full path */
    char* current_xfer_file;
    /* only the file name of the sent/received file */
    char* current_xfer_file_friendly_name;
    /* current transfered amount */
    unsigned int current_xfer_transfer_size;
    /* full size of the data being transfered */
    unsigned int current_xfer_file_size;
    /* bt channel */
    unsigned int channel;
}bt_device;

/* @todo : i should move the status in a bit field */
typedef struct{
    GtkWidget* bt_main_widget;
    /* function pointer for the ui update */
    func_obex_ui_event obex_ui_event;
    /* this is for the popt for hcitool 
       @todo : maybe this should vanish*/
    FILE *out;
    /* status bits for search query for bt neighbourhood devices */
    unsigned char search_active;
    unsigned char search_canceled;
    /* status bits for send/receive xfer */
    unsigned char send_xfer_active;
    unsigned char receive_xfer_active;
    /* gtk idle task id */
    unsigned int handler_id;
    /* model stores the bt devices */
    GtkListStore *model;
    GSList *bt_devices;
    /* send side */ 
    GSList *bt_send_file_list; /* here we append all selected files */
    GThread *bt_send_xfer_thread; 
    GError *bt_send_xfer_error;
    GMutex *bt_send_xfer_mutex;
    GCond* *bt_send_xfer_cond;
    bt_device *current_selected_bt_device; 
    /* receive side */
    /* @todo : these should now be redundant and we should
       use bt_local_device for such info */
    GError *bt_receive_xfer_error;
    GThread *bt_receive_xfer_thread; 
    obex_t *bt_receive_obex_handle;
    unsigned int receive_xfer_exit;
    /* local bt device */
    bt_device bt_local_device;
    /* configuration */
    char* xfer_receive_file_dir;
}btxfer_state;


#endif
