/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <sys/types.h>
#include <bluetooth/sdp.h>
#include <bluetooth/sdp_lib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "sdp_search.h"

static int get_channel_from_service_desc(sdp_data_t *value, void *user);

int get_obex_channel(char *bt_address)
{

    bdaddr_t bdaddr;
    uint16_t class = 0x1105; 
    sdp_list_t *attrid, *search, *seq, *next;
    uint32_t range = 0x0000ffff;
    char str[20];
    sdp_session_t *sess;
    uint32_t channel = -1;
    uuid_t   group;      /* Browse group */
    bdaddr_t interface;

    str2ba(bt_address, &bdaddr);
    sdp_uuid16_create(&group, class);
    
    bacpy(&interface, BDADDR_ANY);
    sess = sdp_connect(&interface, &bdaddr, SDP_RETRY_IF_BUSY);
    ba2str(&bdaddr, str);
    if (!sess) {
        return -1;
    }

    attrid = sdp_list_append(0, &range);
    search = sdp_list_append(0, &group);
    if (sdp_service_search_attr_req(sess, search, SDP_ATTR_REQ_RANGE, attrid, &seq)) {
        sdp_close(sess);
        return -1;
    }
    sdp_list_free(attrid, 0);
    sdp_list_free(search, 0);

    for (; seq; seq = next) {
        sdp_record_t *rec = (sdp_record_t *) seq->data;
        sdp_list_t *list = 0, *proto = 0;
        if (sdp_get_access_protos(rec, &proto) == 0) {
            sdp_list_t* ptr = proto;
            for(;ptr != NULL;ptr = ptr->next){
                sdp_list_t *protDescSeq = (sdp_list_t *)ptr->data;
                for(;protDescSeq != NULL;protDescSeq = protDescSeq->next){
                    channel = get_channel_from_service_desc(protDescSeq->data, NULL);
                    if(channel != -1) break;
                } 
            } 
            sdp_list_free(proto, 0);
        }

        next = seq->next;
        free(seq);
        sdp_record_free(rec);
    }

    sdp_close(sess);
    return channel;
}




static int get_channel_from_service_desc(sdp_data_t *value, void *user)
{
    char str[MAX_LEN_PROTOCOL_UUID_STR];
    char UUID_str[MAX_LEN_UUID_STR];

    sdp_data_t *p = (sdp_data_t *)value, *s;
    int i = 0, proto = 0;
    
    for (; p; p = p->next, i++) {
        switch (p->dtd) {
        case SDP_UUID16:
        case SDP_UUID32:
        case SDP_UUID128:
            sdp_uuid2strn(&p->val.uuid, UUID_str, MAX_LEN_UUID_STR);
            sdp_proto_uuid2strn(&p->val.uuid, str, sizeof(str));
            proto = sdp_uuid_to_proto(&p->val.uuid);
            break;
        case SDP_UINT8:
            if (proto == RFCOMM_UUID){
                return p->val.uint8;
            }
            break;
        case SDP_UINT16:
        case SDP_SEQ16:
        case SDP_SEQ8:
        default:
            break;
        }
    }
    return -1;
}

