/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <openobex/obex.h>

#include <stdlib.h>
#include <fcntl.h>
#include <string.h>

#include "btxfer.h"
#include "obex_app.h"
#include "obex_server.h"

#define TRUE  1
#define FALSE 0

/*
Handle the PUT command. Here we
1. get the name of the file and its size
2. the data for the put'ed file will be stream read in a 
   different function
*/
void put_server(obex_t *handle, obex_object_t *object)
{
	obex_headerdata_t hv;
	uint8_t hi;
	int hlen;

	const uint8_t *body = NULL;
	int body_len = 0;
	char *name = NULL;
	char *namebuf = NULL;

    obex_app_context* context = (obex_app_context*)OBEX_GetUserData(handle);
    btxfer_state *state = (btxfer_state*)context->user_data;
    
    //printf(__FUNCTION__ "()\n");
	while(OBEX_ObjectGetNextHeader(handle, object, &hi, &hv, &hlen)){
		switch(hi)	{
		case OBEX_HDR_BODY:
			body = hv.bs;
			body_len = hlen;
			state->bt_local_device.current_xfer_transfer_size += hlen;    
            break;
        case OBEX_HDR_LENGTH:
            /* this should give us the length of file usually */
            state->bt_local_device.current_xfer_file_size = hv.bq4;    
            break;
		case OBEX_HDR_NAME:
			if( (namebuf = malloc(hlen / 2)))	{
				OBEX_UnicodeToChar(namebuf, hv.bs, hlen);
				name = namebuf;
			}
            if(!name){
                name = "OBEX_PUT_Unknown_object";
            }
            /* @todo : dont forget to call FREE */
            state->bt_local_device.current_xfer_file_friendly_name = strdup(name);    
            free(namebuf);
			break;
		default:
            break;
		}
	}
}

//
//
//
void connect_server(obex_t *handle, obex_object_t *object)
{
	obex_headerdata_t hv;
	uint8_t hi;
	int hlen;

	const uint8_t *who = NULL;
	int who_len = 0;
    //printf(__FUNCTION__ "()\n");

	while(OBEX_ObjectGetNextHeader(handle, object, &hi, &hv, &hlen))	{
		if(hi == OBEX_HDR_WHO)	{
			who = hv.bs;
			who_len = hlen;
		}
		else	{
			//printf(__FUNCTION__ "() Skipped header %02x\n", hi);
		}
	}
	if (who_len == 6)	{
		if(strncmp("Linux", who, 6) == 0)	{
			printf("Weeeha. I'm talking to the coolest OS ever!\n");
		}
	}
	OBEX_ObjectSetRsp(object, OBEX_RSP_SUCCESS, OBEX_RSP_SUCCESS);
}

//
//
//
void server_request(obex_t *handle, obex_object_t *object, int event, int cmd)
{
	switch(cmd)	{
	case OBEX_CMD_CONNECT:
		connect_server(handle, object);
		break;
	case OBEX_CMD_DISCONNECT:
        /*
        @todo : before we can disconnect we need to do
        some house keeping here
        */
		OBEX_ObjectSetRsp(object, OBEX_RSP_SUCCESS, OBEX_RSP_SUCCESS);
		break;
	case OBEX_CMD_PUT:
		OBEX_ObjectSetRsp(object, OBEX_RSP_CONTINUE, OBEX_RSP_SUCCESS);
		put_server(handle, object);
		break;
	case OBEX_CMD_SETPATH:
		OBEX_ObjectSetRsp(object, OBEX_RSP_CONTINUE, OBEX_RSP_SUCCESS);
		break;
    case OBEX_CMD_GET:
	default:
		//printf(__FUNCTION__ "() Denied %02x request\n", cmd);
		OBEX_ObjectSetRsp(object, OBEX_RSP_NOT_IMPLEMENTED, OBEX_RSP_NOT_IMPLEMENTED);
		break;
	}
	return;
}

//
//
//
void server_done(obex_t *handle, obex_object_t *object, int obex_cmd, int obex_rsp)
{
	obex_app_context *gt;
	gt = OBEX_GetUserData(handle);

	printf("Server request finished!\n");

	switch (obex_cmd) {
	case OBEX_CMD_DISCONNECT:
		OBEX_TransportDisconnect(handle);
		gt->serverdone = TRUE;
        break;
    case OBEX_CMD_PUT:
        /* lets do some cleanup related to PUT */
        {
            btxfer_state *state = (btxfer_state*)gt->user_data;
            bt_device* dev = &state->bt_local_device;
            cleanup_xfer_transfer(state, OBEX_SERVER);
            close(dev->fd);
            dev->fd = 0;
            dev->buffer = NULL;
        }
    default:
        
        //printf(__FUNCTION__ "() Command (%02x) has now finished\n", obex_cmd);
		break;
	}
}

//
//
//
void server_do(obex_t *handle)
{
	obex_app_context *gt;
	gt = OBEX_GetUserData(handle);

	gt->serverdone = FALSE;
	while(!gt->serverdone) {
		if(OBEX_HandleInput(handle, 3600) < 0) {
			printf("Error while doing OBEX_HandleInput()\n");
			break;
		}
	}
}
