/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "btxfer.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget*
create_btxfer (btxfer_state* data)
{
  GtkWidget *btbrowser;
  GtkWidget *vbox1;
  GtkWidget *table1;
  GtkWidget *frm_bt_devices;
  GtkWidget *alignment1;
  GtkWidget *scrolledwindow1;
  GtkWidget *lsit_bt_devices;
  GtkWidget *lbl_bt_devices;
  GtkWidget *vbox2;
  GtkWidget *hbox2;
  GtkWidget *lbl_transfer_status;
  GtkWidget *hbox1;
  GtkWidget *progressbar1;
  GtkWidget *hbox3;
  GtkWidget *table2;
  GtkWidget *bt_ok;
  GtkWidget *bt_search;
  GtkWidget *bt_send;
  /*
  GtkWidget *bt_cancel;
  GtkWidget *bt_receive;
  */
  GtkListStore *store;
  
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  /* Setup the selection handler */
  GtkTreeSelection *select;
  store = data->model = gtk_list_store_new (1, G_TYPE_STRING);
  
  btbrowser = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (btbrowser), _("Bluetooth xfer"));
  gtk_window_set_position (GTK_WINDOW (btbrowser), GTK_WIN_POS_CENTER);
  gtk_window_set_type_hint (GTK_WINDOW (btbrowser), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (btbrowser), vbox1);

  table1 = gtk_table_new (3, 1, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);

  frm_bt_devices = gtk_frame_new (NULL);
  gtk_widget_show (frm_bt_devices);
  gtk_table_attach (GTK_TABLE (table1), frm_bt_devices, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frm_bt_devices), GTK_SHADOW_NONE);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frm_bt_devices), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 12, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (alignment1), scrolledwindow1);

  
  lsit_bt_devices = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new();
  gtk_tree_view_column_pack_start (column,renderer,FALSE);
  gtk_tree_view_column_set_attributes(column,renderer,"text",NULL);
  
  gtk_tree_view_set_headers_visible(lsit_bt_devices,FALSE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (lsit_bt_devices), column);
  g_object_unref (G_OBJECT (store));
  
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (lsit_bt_devices));
  /* @todo : later allow multiple devices to be selected
  so you can send one file to multiple devices */
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
  g_signal_connect (G_OBJECT (select), "changed",
                  G_CALLBACK (bt_device_selection_changed_cb),
                  data);
                  
  
  gtk_widget_show (lsit_bt_devices);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), lsit_bt_devices);

  lbl_bt_devices = gtk_label_new (_("<b>BT Devices</b>"));
  gtk_widget_show (lbl_bt_devices);
  gtk_frame_set_label_widget (GTK_FRAME (frm_bt_devices), lbl_bt_devices);
  gtk_label_set_use_markup (GTK_LABEL (lbl_bt_devices), TRUE);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_table_attach (GTK_TABLE (table1), vbox2, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 2);


  lbl_transfer_status = gtk_label_new ("");
  gtk_widget_show (lbl_transfer_status);
  gtk_box_pack_start (GTK_BOX (hbox2), lbl_transfer_status, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox1, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 2);


  progressbar1 = gtk_progress_bar_new ();
  gtk_widget_show (progressbar1);
  gtk_box_pack_start (GTK_BOX (hbox1), progressbar1, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox3);
  gtk_table_attach (GTK_TABLE (table1), hbox3, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  table2 = gtk_table_new (1, 5, TRUE);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (hbox3), table2, TRUE, FALSE, 0);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 2);

  bt_ok = gtk_button_new_with_mnemonic (_("Exit"));
  gtk_widget_show (bt_ok);
  gtk_table_attach (GTK_TABLE (table2), bt_ok, 4, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  bt_search = gtk_button_new_with_mnemonic (_("Search"));
  gtk_widget_show (bt_search);
  gtk_table_attach (GTK_TABLE (table2), bt_search, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  bt_send = gtk_button_new_with_mnemonic (_("Send.."));
  gtk_widget_show (bt_send);
  gtk_table_attach (GTK_TABLE (table2), bt_send, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  /*
  bt_cancel = gtk_button_new_with_mnemonic (_("Cancel"));
  gtk_widget_show (bt_cancel);
  gtk_table_attach (GTK_TABLE (table2), bt_cancel, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  bt_receive = gtk_button_new_with_mnemonic (_("Receive"));
  gtk_widget_show (bt_receive);
  gtk_table_attach (GTK_TABLE (table2), bt_receive, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  */
  
  g_signal_connect ((gpointer) bt_ok, "clicked",
                            G_CALLBACK (on_bt_exit_clicked),
                            GTK_OBJECT (data));
  g_signal_connect ((gpointer) bt_search, "clicked",
                            G_CALLBACK (on_bt_search_clicked),
                            GTK_OBJECT (data));
  g_signal_connect ((gpointer) bt_send, "clicked",
                            G_CALLBACK (on_bt_send_clicked),
                            GTK_OBJECT (data));
  /*
  g_signal_connect ((gpointer) bt_cancel, "clicked",
                            G_CALLBACK (on_bt_cancel_clicked),
                            GTK_OBJECT (data));
  g_signal_connect ((gpointer) bt_receive, "clicked",
                            G_CALLBACK (on_bt_receive_clicked),
                            GTK_OBJECT (data));
  */

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (btbrowser, btbrowser, "btbrowser");
  GLADE_HOOKUP_OBJECT (btbrowser, vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (btbrowser, table1, "table1");
  GLADE_HOOKUP_OBJECT (btbrowser, frm_bt_devices, "frm_bt_devices");
  GLADE_HOOKUP_OBJECT (btbrowser, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (btbrowser, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (btbrowser, lsit_bt_devices, "lsit_bt_devices");
  GLADE_HOOKUP_OBJECT (btbrowser, lbl_bt_devices, "lbl_bt_devices");
  GLADE_HOOKUP_OBJECT (btbrowser, vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (btbrowser, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (btbrowser, lbl_transfer_status, "lbl_transfer_status");
  GLADE_HOOKUP_OBJECT (btbrowser, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (btbrowser, progressbar1, "progressbar1");
  GLADE_HOOKUP_OBJECT (btbrowser, hbox3, "hbox3");
  GLADE_HOOKUP_OBJECT (btbrowser, table2, "table2");
  GLADE_HOOKUP_OBJECT (btbrowser, bt_ok, "bt_ok");
  GLADE_HOOKUP_OBJECT (btbrowser, bt_search, "bt_search");
  GLADE_HOOKUP_OBJECT (btbrowser, bt_send, "bt_send");
  /*
  GLADE_HOOKUP_OBJECT (btbrowser, bt_cancel, "bt_cancel");
  GLADE_HOOKUP_OBJECT (btbrowser, bt_receive, "bt_receive");
  */

  return btbrowser;
}

