/*********************************************************************
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
/*
#include <sys/select.h>
*/
#include <stdarg.h>
#include <sys/ioctl.h>
#include <bluetooth/bluetooth.h>


#include "btxfer.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "sdp_search.h"
#include "obex_app.h"

void
on_bt_exit_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
    /*
    here we need to check if transfers are going etc.
    */
    gtk_main_quit();
}


char *format_byte_size(char *str, long size)
{
    const long ONE_K = 1024;
    const long ONE_M = ONE_K*ONE_K;

    if (size < ONE_K)
        sprintf(str, "%ldb", size);
    else if (size < ONE_M)
        sprintf(str, "%ldkb", size/ONE_K);
    else
        sprintf(str, "%.2fM", (float)size/(ONE_M));
    return str;
}

void obex_ui_update_event(int code, ...){
    va_list arguments;
    btxfer_state* state;
    bt_device* dev;
    int mode;        
    gdk_threads_enter();
    switch(code){
        case CLIENT_EVENT_PUT_START: 
        {
            char* name;
            unsigned int len;
            char status[256];
            char size[16];
            GtkWidget* lbl_status;
            
            va_start (arguments, 3);
            state = va_arg( arguments, btxfer_state*);
            name = va_arg( arguments, char*);
            len = va_arg( arguments, unsigned int);
            
            dev = state->current_selected_bt_device;
            dev->current_xfer_file_friendly_name = name;
            /* now lets update the status bar */
            lbl_status = lookup_widget(state->bt_main_widget,
                                       "lbl_transfer_status");
            memset(status, 0, 256);
            memset(size, 0, 16);
            format_byte_size(size, len);
            sprintf(status, "Sending... %s[%7s]", name, size);
            gtk_label_set_text(GTK_LABEL(lbl_status), status);
        }
        break;
        case CLIENT_EVENT_PUT_CONT:
        {
            char status[256];
            GtkWidget* lbl_status;
            GtkWidget* progress_bar;
            char size[16];
            
            va_start (arguments, 2);
            state = va_arg( arguments, btxfer_state*);
            mode = va_arg( arguments, int);
            if(mode == OBEX_CLIENT) {
                dev = state->current_selected_bt_device;
            }else{
                dev = &state->bt_local_device;
            }
            
            /* now lets update the status bar */
            lbl_status = lookup_widget(state->bt_main_widget,
                                       "lbl_transfer_status");
            memset(status, 0, 256);
            memset(size, 0, 16);
            format_byte_size(size, dev->current_xfer_transfer_size);
            sprintf(status, 
                    (mode == OBEX_CLIENT) ? "Sending... %s[%7s]" : "Receiving... %s[%7s]", 
                    dev->current_xfer_file_friendly_name, size);
            gtk_label_set_text(GTK_LABEL(lbl_status), status);
            
            progress_bar = lookup_widget(state->bt_main_widget,
                                       "progressbar1");
            gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(progress_bar),
             ((gdouble)(dev->current_xfer_transfer_size))/(gdouble)((dev->current_xfer_file_size)));
        }
        break;
        case CLIENT_EVENT_REQ_DONE:
        {
           GtkWidget* lbl_status;
           GtkWidget* progress_bar;
           va_start (arguments, 2);
           state = va_arg( arguments, btxfer_state*);
           mode = va_arg( arguments, int);
           lbl_status = lookup_widget(state->bt_main_widget,
                                        "lbl_transfer_status");
           progress_bar = lookup_widget(state->bt_main_widget,
                                       "progressbar1");
           gtk_label_set_text(GTK_LABEL(lbl_status), "");
           gtk_progress_set_value(GTK_PROGRESS_BAR(progress_bar), 0.0);
        }
        break;
        default:
        break;
    }
    gdk_flush ();
    /* release GTK thread lock */
    gdk_threads_leave();
}

/*
basic idea
OBEX_Init
OBEX_TransportConnect
put_client
*/
gpointer thread_func_send_xfer(gpointer data){
    btxfer_state *state = (btxfer_state*)data;
    GList* current = NULL;
    const gchar **selected_files = NULL;
    int j = 0;
    bt_device* dev = NULL;
    
    while(TRUE){
        g_mutex_lock(state->bt_send_xfer_mutex);
        current = g_slist_nth( state->bt_send_file_list, 0);
        if(current != NULL){
            state->bt_send_file_list = g_slist_remove_link(state->bt_send_file_list, current);
            selected_files = g_slist_nth_data(current, 0);
        }
        dev = state->current_selected_bt_device;
        g_mutex_unlock(state->bt_send_xfer_mutex);
        
        if(selected_files != NULL){
            /*
            @todo : what happen we trying to send
            when the device is not selected
            a) we throw a dialog for user to select the device
            b) send to the first device
            c) send to all detected device
            
            for now we just exit
            */
            if(dev != NULL){
                /* check if the OBEX_Init is called or not
                   if dev->obex_handle == NULL then not
                */
                if(dev->obex_handle == NULL){
                    /*
                    here i need to do SDP query to find out where the OPUSH
                    channel is
                    */
                    int channel = dev->channel;
                    if(channel <= 0){
                        /* this can be time consuming */
                        channel = get_obex_channel(dev->bt_address);
                        if(channel == -1){
                            /* the device does not look like have OPUSH */
                            /* exit from here */
                        }
                    }
                    
                    if(obex_xfer_init (channel, 
                                        dev->bt_address,
                                        &dev->obex_handle, 
                                        state)){
                        /* error , so we need to get out */
                        g_printf("Error OBEX init\n");
                        break;
                    }
                    /* now lets get a transport link */
                    if(obex_xfer_transport_connect(dev->obex_handle)){
                        /* error we need to get out */
                    }
                    /* here we ready to go */
                    /* here we send one file after another */
                    obex_xfer_connect(dev->obex_handle);
                }
                
                
                for(j = 0; selected_files[j] != NULL; j++){
                    dev->current_xfer_file = selected_files[j];
                    /* this does not come out till the command is done so 
                       we actually dont need the cond variable */
                    obex_xfer_send(dev->obex_handle);
                    /* @TODO : fix this we cannot disconnect here as 
                               we need to wait till the transfer is
                               over. so we need to use a conditional variable
                               here which is set by the obex_event */
                    /* we will be woken up , when the transaction is over */
                    /* 
                    g_cond_wait(state->bt_send_xfer_cond, state->bt_send_xfer_mutex);
                    */
                }
            }
                
            /* lets free memory here */
            g_strfreev(selected_files);
            g_slist_free(current);
            current = NULL;
            selected_files = NULL;
        }else{
            g_mutex_lock(state->bt_send_xfer_mutex);
            state->bt_send_xfer_thread = NULL;
            if(dev != NULL && dev->obex_handle != NULL){
                obex_xfer_disconnect(dev->obex_handle);
                /* lets transport disconnect */
                if(obex_xfer_transport_disconnect(dev->obex_handle)){
                        /* error we need to get out */
                }
                dev->obex_handle = NULL;
            }
            g_mutex_unlock(state->bt_send_xfer_mutex);
            break;
        }
    }
    g_thread_exit(TRUE);
}
/* select the BT device to send here */
void bt_device_selection_changed_cb (GtkTreeSelection *selection, gpointer data)
{
    GtkTreeIter iter;
    GtkTreeModel *model;
    btxfer_state *state = (btxfer_state*)data;
    int i = 0;
    bt_device *dev;
    if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {
        /* @todo : maybe i can make this more efficient to
        hide the bt address in invisible column */
        char* bt_device_name = NULL;
        gtk_tree_model_get (model, &iter, 0, &bt_device_name, -1);
        if(bt_device_name == NULL) return;
        /* now get the bt_device_address from here */
        for(i = 0; (dev = (bt_device*)g_slist_nth_data(state->bt_devices ,i)) != NULL; i++){
            if(!strcmp(bt_device_name, dev->bt_name)){
                g_mutex_lock(state->bt_send_xfer_mutex);
                state->current_selected_bt_device = dev;
                g_mutex_unlock(state->bt_send_xfer_mutex);
                g_printf("selected = %s\n", dev->bt_address);
                break;
            }
        } 
        g_free (bt_device_name);
    }
}

/* we store the files to be sent here */
void bt_send_file_selector (GtkWidget *widget, gpointer user_data) {
   GtkWidget *file_selector = GTK_WIDGET (user_data);
   const gchar **selected_files = NULL;
   int i = 0;
   /*
   @todo : clarify who clears this data, because we will have a problem
           if the g_object calls a free on our data, that would be highly
           unlikely.
   */
   btxfer_state *state = (btxfer_state*)g_object_get_data(G_OBJECT(file_selector), "user_data");
    
   /* 
   @todo :
   here we need to check if there is a transfer already happening 
   at this point we have two options
   1. we can ask user if it wants to terminate the current transfer
   2. or would it wish to append these next set to on going transfer
   */
   printf("I was here \n");
   selected_files = gtk_file_selection_get_selections (GTK_FILE_SELECTION (file_selector));
   
   /* @todo : fixing the issue if the selected file is directory */

   g_mutex_lock(state->bt_send_xfer_mutex);
   state->bt_send_file_list = g_slist_append(state->bt_send_file_list,selected_files); 
   printf("I was here 1\n");
   g_mutex_unlock(state->bt_send_xfer_mutex);
   /*
   @todo : Verify, do 
      we need to unref the file selector so it is 
      garbage collected
   g_object_unref (G_OBJECT (file_selector));
   */
   /*
   here we need to check if the thread is already running
   if not spawn it to do the transfer. We cannot do it here
   as we will hang the UI then , and the guy would not be 
   able to cancel it
   */
   g_mutex_lock(state->bt_send_xfer_mutex);
   if(state->bt_send_xfer_thread == NULL){
    state->bt_send_xfer_thread = g_thread_create(thread_func_send_xfer,
                                            state,
                                            FALSE,
                                            &state->bt_send_xfer_error);
   }
   g_mutex_unlock(state->bt_send_xfer_mutex);
//   gtk_widget_destroy(file_selector);
}

void
on_bt_send_clicked                       (GtkButton       *button,
                                          gpointer         user_data)
{
    /* invoke a file browser here */
    GtkWidget *file_selector;
    file_selector = gtk_file_selection_new (NULL);
/* lets set our user data into file_selector, we need it later */
printf("on_bt_send_clicked 2\n");    
    g_object_set_data(G_OBJECT(file_selector), "user_data", user_data);
    /* hide all the buttons etc which manipulate file like create, rename etc */
    gtk_file_selection_hide_fileop_buttons(file_selector);
    /* allow multiple selections */
    gtk_file_selection_set_select_multiple (file_selector, TRUE);
    g_signal_connect (GTK_FILE_SELECTION (file_selector)->ok_button,
                      "clicked",
                      G_CALLBACK (bt_send_file_selector),
                      file_selector);

g_signal_connect_swapped (GTK_FILE_SELECTION (file_selector)->ok_button,
                                "clicked",
                                G_CALLBACK (gtk_widget_destroy), 
                                file_selector);

    g_signal_connect_swapped (GTK_FILE_SELECTION (file_selector)->cancel_button,
                                "clicked",
                                G_CALLBACK (gtk_widget_destroy),
                                file_selector); 
   
    /* Display that dialog */
    
    gtk_widget_show (file_selector);                  
}

/*
void
on_bt_receive_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
}
*/

/* here we have a thread which is always listening to receive
   data */
gpointer thread_func_receive_xfer(gpointer data){
    btxfer_state *state = (btxfer_state*)data;
    
    /* set up the receive side context */
    obex_app_context* context = (obex_app_context*)malloc(sizeof(obex_app_context));
    memset(context, 0, sizeof(obex_app_context));
    context->channel = BT_CHANNEL;
    context->user_data = state;

    /* initialize the receive side obex handle */    
    while(!state->receive_xfer_exit){
        state->bt_receive_obex_handle = OBEX_Init(OBEX_TRANS_BLUETOOTH,
                                                obex_event, 0);
        if(!state->bt_receive_obex_handle){
            /* error condition */
            return NULL;
        }
        
        state->bt_local_device.obex_handle = state->bt_receive_obex_handle;
        OBEX_SetUserData(state->bt_receive_obex_handle, context);
        if(BtOBEX_ServerRegister(state->bt_receive_obex_handle, 
                                BDADDR_ANY, 
                                context->channel) < 0) {
            /* error condition */
            return NULL;
        }
        /* No process server events. this will exit when you set 
        context->serverDone = TRUE*/
        server_do(state->bt_receive_obex_handle);
    }
}

gboolean search_result_handler(gpointer data){

    btxfer_state *state = (btxfer_state*)data;
    if(state->search_active){
#if 0
        /* Devesh : somehow cant make select to return me there
                    fd read state */
        fd_set rfds;
        int retval = 0;
        int fd = 0;
        struct timeval tv;
        
        /* dont block */
        tv.tv_sec = 0;
        tv.tv_usec = 0;
        /* before we do anything, we should check if there is data to
           read. Maybe we can use select call on the fd just to check */
        fd = fileno(state->out);
        FD_ZERO(&rfds);
        FD_SET(fd, &rfds);   
        retval = select(1, &rfds, NULL, NULL, &tv);
        printf("select ....%d\n", retval);
        if (retval == -1){
            if(errno == EBADF){
                /* clear up */
                on_bt_cancel_clicked(NULL, data);
                return FALSE;
            }
        }else if(retval && FD_ISSET(fd, &rfds)){
            GtkTreeIter   iter;
            char line[256];
            printf("select.... = %d\n", retval);
            gtk_list_store_append (state->model, &iter);
            if(fgets(line, 256, state->out) != NULL){
                gtk_list_store_set (state->model, &iter, 0, line, -1);
            }
        }
#endif
        int fd = 0;
        int nbytes = 0;
        int retval = 0;
        fd = fileno(state->out);
        retval = ioctl(fd,FIONREAD,&nbytes);
        if(nbytes){
            char line[256];
            while(fgets(line, nbytes, state->out) != NULL){
                char* token = NULL;
                char* bt_address =NULL;
                bt_device* device = NULL;
                GtkTreeIter   iter;
                /* 
                lets parse the output hcitool scan produces something like
                Scanning...\n
                \tbd_address\tname\n
                ==================================================
                @todo : this is inherently dependent on the output
                        of hcitool scan. If that change then this
                        will break
                */
                token = strtok(line, "\t");
                /* here we get the bd address only if we can see
                   some : stuff*/
                if(strstr(token, ":") != NULL){
                    /* @todo : make sure you delete this memory */
                    bt_address = strdup(token);
                    printf("%s\n", bt_address);
                }
                token = strtok(NULL,"\t");
                printf("token = %s\n", token);
                if(token == NULL || strcmp(token,"\n") == 0) continue;
                /* take away the new line from the token */
                token = strtok(token,"\n");
                /* add to our linked list */
                device = (bt_device*)malloc(sizeof(bt_device));
                memset(device, 0, sizeof(bt_device));
                device->bt_address = bt_address;
                printf("token 2= %s\n", token);
                device->bt_name = strdup(token);
                printf("token 3= %s\n", token);
                gdk_threads_enter();
                state->bt_devices = g_slist_append(state->bt_devices,device); 
                /* add to our UI */
                printf("token 4= %s\n", token);
                gtk_list_store_append (state->model, &iter);
                printf("token 5= %s\n", token);
                gtk_list_store_set (state->model, &iter, 0, token, -1);
                gdk_threads_leave();
                printf("getting out \n");
            }
        }
    }
    return TRUE;
    /*
    @todo : we would also need to maybe do SDP query on these devices
            to see if they support OPUSH profile
    */
}


void
on_bt_search_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
    /*
    all i would do here is to call the hcitool as popen and
    read its output to populate the list. 
    */
    char cmd[128];
    FILE *out;
    btxfer_state *state = (btxfer_state*)user_data;
    /* already active search */
    if(state->out != 0){ 
        /*
        @todo : here we need to tell the user that previous query
        is active, does it want to cancel that
        */
        return;
    }
    
    memset(cmd, 0, 128);
    sprintf(cmd, "%s %s", HCITOOL, CMD_SCAN);
    if((out = popen(cmd, "r")) == NULL){
        /* error */
        return;
    }
    state->out = out;
    state->search_active = TRUE;
    /* empty the store */
    gtk_list_store_clear(state->model);  
    /* register idle handler */
    state->handler_id = gtk_idle_add(search_result_handler, state);
}


void
on_bt_cancel_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
    btxfer_state *state = (btxfer_state*)user_data;
    if(state->search_active){
        pclose(state->out);
        state->out = 0;
        state->search_active = FALSE;
        gtk_idle_remove(state->handler_id);   
    }
}

