#!/usr/bin/env python2.5
# coding= utf-8
# 
# Copyright (c) 2009 Daniel Would
# Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#
#

# ============================================================================
# Name        : witter.py
# Author      : Daniel Would
# Version     : 0.1
# Description : Witter
# ============================================================================

#This is the bunch of things I wound up importing
#I think I need them all.. 
import gtk
import pygtk
import hildon
import urllib2
import urllib
import mimetools, mimetypes
import base64
import urlparse
import simplejson
import socket
import re
import string
import osso
import os
import webbrowser
import ConfigParser
import pycurl
import oauthtwitter
import twitter

import random
import witter
import time
import pickle

gtk.gdk.threads_init()



#Initially I found I'd hang the whole interface if I was having network probs
#because by default there is an unlimited wait on connect so I set
#the timeout to 10 seconds afterwhich you get back a timeout error
# timeout in seconds
timeout = 10
socket.setdefaulttimeout(timeout)

#the main witter application
class Witter():
    #first an init method to set everything up    
    def __init__(self):
        #defaults for auto-refresh
        self.timelineRefreshInterval = 30
        self.mentionsRefreshInterval = 30

        self.DMsRefreshInterval = 30
        self.publicRefreshInterval = 0
        self.searchRefreshInterval = 0
        #we use the busy counter to track the number of busy threads
        #and show a progres/busy indicator whilst it's more than 0
        self.busyCounter = 0
        self.search_terms = ""
        self.refreshtask = None
        self.dmrefresh = None
        self.mentionrefresh = None
        self.publicrefresh = None
        self.searchrefresh = None
        self.username = "UserName"
        self.password = ""
        self.access_token = ""
        self.user = ""
        self.CONSUMER_KEY = 'c0glxehHLYgzDqDMLjanA'
        self.CONSUMER_SECRET = 'V37SuM6o7PddlqqosLpYtIqyaLj0mgnFkGGKkJjN6I'

        #make the hildon program
        self.program = hildon.Program()
        self.program.__init__()

        self.osso_c = osso.Context("witter", "0.2.2", False)
        self.osso_rpc = osso.Rpc(self.osso_c)
        # set name of application: this shows in titlebar
        gtk.set_application_name("Witter")
        self.twitterUrlRoot = "https://twitter.com/"
        self.twitterSearchUrlRoot = "https://search.twitter.com/"
        self.twitterName = "Witter"
        self.identicaUrlRoot = "http://identi.ca/api/"
        self.identicaSearchUrlRoot = "http://identi.ca/api/"
        self.identicaName = "Witti.ca"
        self.serviceUrlRoot = self.twitterUrlRoot
        self.searchServiceUrlRoot = self.twitterSearchUrlRoot
        self.serviceName = self.twitterName
        # 
        #we want to track our position in each tweet stream so we can 
        #return to it when we switch between them
        self.timelinePos = None
        self.mentionPos = None
        self.dmPos = None
        self.searchPos = None
        self.friendsPos = None
        self.trendsPos = None
        self.publicPos = None
        self.showingMore = False
    	 #used to store the id of message if we're going to do a reply_to
        self.reply_to = ""
        self.reply_to_name = ""
        self.reply_all = ""
        self.retweetname = ""
        self.retweetid = ""
        self.retweettext = ""
        self.selectedUser = ""

        #Set the Glade file
        #self.gladefile = "/usr/share/witter/witter.glade"  
        #self.wTree = gtk.glade.XML(self.gladefile) 
        self.builder = gtk.Builder()
        self.builder.add_from_file("/usr/share/witter/witter.ui")
        #map all the signals
        dic = {
            "newTweet" : self.enterPressed,
            "getTweets" : self.updateSelectedView,
            "storecreds" : self.store_creds,
            "getacesstoken" : self.getAccessToken,
            "on_timeline_clicked" : self.switchView,
            "on_mentions_clicked" : self.switchView,
            "on_direct_messages_clicked" : self.switchView,
            "on_search_clicked" : self.switchView,
            "on_trend_clicked" : self.switchView,
            "on_user_history_clicked" : self.switchView,
            "on_insert_clicked" : self.twitPic,
            "on_friends_clicked" : self.switchView,
            "on_trends_clicked" : self.switchView,
            "on_public_clicked" : self.switchView,
            "on_Reply_clicked" : self.replyTo,
            "on_ReplyAll_clicked" : self.replyAll,
            "on_AtUser_clicked" : self.tweetAt,
            "on_Retweet_clicked" : self.reTweet,
            "on_DirectMessage_clicked" : self.directMessage,
            "on_Follow_clicked" : self.FollowTweetAuthor,
            "on_UnFollow_clicked" : self.UnFollowTweetAuthor,
            "on_cancel_clicked" : self.gtk_widget_hide,
            "on_fullscr_clicked" : self.fullscr,
            "on_extra_clicked" : self.showMoreButtons,
            "on_plus20_clicked" : self.get20More,
            "on_plus50_clicked" : self.get50More,
            "on_plus100_clicked" : self.get100More,
            "on_plus200_clicked" : self.get200More,
            "setProps" : self.setProps,
            "nosetProps" : self.dontsetProps,
        }
        self.builder.connect_signals(dic)
        #self.wTree.signal_autoconnect( dic )

    	#fix the buttons to get the style right 
        refreshButton = self.builder.get_object("Refresh")
        refImage = gtk.Image()
        refImage.set_from_file("/opt/witter/icons/refresh.png")
        refImage.show()
        refreshButton.set_image(refImage)
        tweetButton = self.builder.get_object("Tweet")
        tweetImage = gtk.Image()
        tweetImage.set_from_file("/opt/witter/icons/tweet.png")
        tweetImage.show()
        tweetButton.set_image(tweetImage)
        timelineButton = self.builder.get_object("timeline")
        tlImage = gtk.Image()
        tlImage.set_from_file("/opt/witter/icons/timeline.png")
        tlImage.show()
        timelineButton.set_image(tlImage)
        mentionsButton = self.builder.get_object("mentions")
        menImage = gtk.Image()
        menImage.set_from_file("/opt/witter/icons/mention_off.png")
        menImage.show()
        mentionsButton.set_image(menImage)
        dmsButton = self.builder.get_object("direct messages")
        dmImage = gtk.Image()
        dmImage.set_from_file("/opt/witter/icons/dm_off.png")
        dmImage.show()
        dmsButton.set_image(dmImage)
        searchButton = self.builder.get_object("search")
        serImage = gtk.Image()
        serImage.set_from_file("/opt/witter/icons/search_off.png")
        serImage.show()
        searchButton.set_image(serImage)
        friendsButton = self.builder.get_object("friends")
        friendImage = gtk.Image()
        friendImage.set_from_file("/opt/witter/icons/friends_off.png")
        friendImage.show()
        friendsButton.set_image(friendImage)
        publicButton = self.builder.get_object("public")
        pubImage = gtk.Image()
        pubImage.set_from_file("/opt/witter/icons/public_off.png")
        pubImage.show()
        publicButton.set_image(pubImage)
        trendsButton = self.builder.get_object("trends")
        trendImage = gtk.Image()
        trendImage.set_from_file("/opt/witter/icons/trends_off.png")
        trendImage.show()
        trendsButton.set_image(trendImage)
        userButton = self.builder.get_object("userhistory")
        userImage = gtk.Image()
        userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
        userImage.show()
        userButton.set_image(userImage)

        fullscrButton = self.builder.get_object("fullscr")
        image = gtk.Image()
        image.set_from_file("/opt/witter/icons/fullscr.png")
        image.show()
        fullscrButton.set_image(image)
        extraButton = self.builder.get_object("extra-controls")
        image2 = gtk.Image()
        image2.set_from_file("/opt/witter/icons/plus.png")
        image2.show()
        extraButton.set_image(image2)


        plus20Button = self.builder.get_object("plus20")
        plus50Button = self.builder.get_object("plus50")
        plus100Button = self.builder.get_object("plus100")
        plus200Button = self.builder.get_object("plus200")


        imageplus20 = gtk.Image()
        imageplus20.set_from_file("/opt/witter/icons/plus20.png")
        imageplus20.show()
        plus20Button.set_image(imageplus20)

        imageplus50 = gtk.Image()
        imageplus50.set_from_file("/opt/witter/icons/plus50.png")
        imageplus50.show()
        plus50Button.set_image(imageplus50)

        imageplus100 = gtk.Image()
        imageplus100.set_from_file("/opt/witter/icons/plus100.png")
        imageplus100.show()
        plus100Button.set_image(imageplus100)

        imageplus200 = gtk.Image()
        imageplus200.set_from_file("/opt/witter/icons/plus200.png")
        imageplus200.show()
        plus200Button.set_image(imageplus200)

        okButton = self.builder.get_object("Ok")
        cancelButton = self.builder.get_object("Cancel")
        okoauthButton = self.builder.get_object("Ok-oauth")

        propscancelButton = self.builder.get_object("props-cancel")
        refreshstoreButton = self.builder.get_object("refresh_store")
        #action buttons for a tweet
        replybutton = self.builder.get_object("Reply")
        replyAllbutton = self.builder.get_object("ReplyAll")
        retweetbutton = self.builder.get_object("Retweet")
        dmbutton = self.builder.get_object("DirectMessage")
        atUserbutton = self.builder.get_object("AtUser")


        #followbutton = self.builder.get_object("Follow")
        #unfollowbutton = self.builder.get_object("UnFollow")
        #usersTimelinebutton = self.builder.get_object("UsersTimeline")

        refreshButton.set_name("HildonButton-finger")
        tweetButton.set_name("HildonButton-finger")
        timelineButton.set_name("HildonButton-finger")
        mentionsButton.set_name("HildonButton-finger")
        dmsButton.set_name("HildonButton-finger")
        searchButton.set_name("HildonButton-finger")
        friendsButton.set_name("HildonButton-finger")
        trendsButton.set_name("HildonButton-finger")
        publicButton.set_name("HildonButton-finger")
        userButton.set_name("HildonButton-finger")
        fullscrButton.set_name("HildonButton-finger")
        extraButton.set_name("HildonButton-finger")
        plus20Button.set_name("HildonButton-finger")
        plus50Button.set_name("HildonButton-finger")
        plus100Button.set_name("HildonButton-finger")
        plus200Button.set_name("HildonButton-finger")
        okButton.set_name("HildonButton-finger")
        cancelButton.set_name("HildonButton-finger")
        okoauthButton.set_name("HildonButton-thumb")
        propscancelButton.set_name("HildonButton-finger")
        refreshstoreButton.set_name("HildonButton-finger")
        #action buttons
        replybutton.set_name("HildonButton-finger")
        replyAllbutton.set_name("HildonButton-finger")
        retweetbutton.set_name("HildonButton-finger")
        dmbutton.set_name("HildonButton-finger")
        atUserbutton.set_name("HildonButton-finger")
        #followbutton.set_name("HildonButton-thumb")
        #unfollowbutton.set_name("HildonButton-thumb")
        #usersTimelinebutton.set_name("HildonButton-thumb")

        self.textcolour = "#FFFFFF"
        #default colours are the ones used in the hildon window buttons
        self.bg_top_color = gtk.gdk.color_parse("#6bd3ff")
        self.bg_bottom_color = gtk.gdk.color_parse("#0075b5")
        self.font_size = 18
        #
        #go read config file
        #
        self.readConfig()
        #being lazy this just uses basic auth and I am not doing anything
        #yet to store uid/pwd so for the moment just put info here


        #at one point I had the text different colours
        #I may do again
        self.namecolour = self.textcolour
        self.tweetcolour = self.textcolour

        self.defaultwidth = 790
        #default to colours above, but check if we're on fremantle and change
        #to appropriate colours if we are
        self.checkVersion()
        #This being a hildon app we start with a hildon.Window
        self.window = hildon.StackableWindow()
        self.window.set_app_paintable(True)
        self.window.realize()
        #connect the delete event for closing the window
        self.window.connect("delete_event", self.quit)
        #we default to the timeline view
        self.window.set_title(self.serviceName + " - timeline")
        #add window to self  
        self.program.add_window(self.window)
        #reparent the vbox1 from glade to self.window
        # self.vbox = self.wTree.get_widget("vbox1")
        self.vbox = self.builder.get_object("vbox1")
        #pannedWindow = hildon.PannableArea()
        pannedWindow = self.builder.get_object("pannableArea")
        # hildon.hildon_pannable_area_new_full(mode, enabled, vel_min, vel_max, decel, sps)
        self.window.window.property_change("_HILDON_ZOOM_KEY_ATOM", "XA_INTEGER", 32, gtk.gdk.PROP_MODE_REPLACE, [1])
        #self.scrolled_window = self.wTree.get_widget("scrolled_window")
        self.vbox.reparent(self.window)
        #self.vbox.pack_end(pannedWindow)

        #self.urlmenu = self.build_right_click_menu()
        # create a menu object by calling a method to deine it
        self.menu = self.create_m5_menu(self)
        # add the menu to the window
        self.window.set_app_menu(self.menu)
        #


        self.last_id = None
        self.oldest_id = None
        self.last_dm_id = None
        self.oldest_dm_id = None
        self.last_mention_id = None
        self.oldest_mention_id = None
        self.last_public_id = None
        self.oldest_public_id = None
        self.last_friend_history_id = None
        self.oldest_friend_history_id = None
        #self.urlmenu = gtk.Menu()
        # define a liststore we use this to store our tweets and some associated data
        # the fields are : Name,nameColour,Tweet,TweetColour,id, type, timestamp, replyTo, source
        self.liststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        #then we want the same again to store dm's, mentions & pubilc timeline separately
        self.dmliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.mentionliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.publicliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.trendliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.friendsliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.searchliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        self.userhistoryliststore = gtk.ListStore(str, str, str, str, str, str, str, str, str)
        #we want auto-complete of @references 
        #self.tweetText = self.wTree.get_widget("TweetText")
        self.tweetText = self.builder.get_object("TweetText")
        self.tweetText.connect("changed", self.CharsRemaining)
        tweetComplete = gtk.EntryCompletion()
        tweetComplete.set_model(self.friendsliststore)
        tweetComplete.set_text_column(0)
        tweetComplete.set_inline_completion(True)
        tweetComplete.set_minimum_key_length(2)
        self.tweetText.set_completion(tweetComplete)

        # create the TreeView using treestore this is the object which displays the
        # info stored in the liststore
        self.treeview = gtk.TreeView(self.liststore)
    	#self.treeview = hildon.hildon_gtk_tree_view_new(self.liststore)
        self.treeview.set_model(self.liststore)
        # create the TreeViewColumn to display the data, I decided on two colums
        # one for name and the other for the tweet
        #self.tvcname = gtk.TreeViewColumn('Name')
        self.cell = witter.witter_cell_renderer.witterCellRender()
    	#cell_text = gtk.CellRendererText()
    	#cell = gtk.CellRendererText()

        color = self.bg_top_color

        color2 = self.bg_bottom_color


        self.cell.set_property('backgroundt_r', color.red)
        self.cell.set_property('backgroundt_g', color.green)
        self.cell.set_property('backgroundt_b', color.blue)
        self.cell.set_property('backgroundt_p', color.pixel)
        self.cell.set_property('backgroundb_r', color2.red)
        self.cell.set_property('backgroundb_g', color2.green)
        self.cell.set_property('backgroundb_b', color2.blue)
        self.cell.set_property('backgroundb_p', color2.pixel)
        self.cell.set_property('font_size', self.font_size)

        self.tvctweet = gtk.TreeViewColumn('Pango Markup', self.cell, markup=2)


        #self.tvctweet = gtk.TreeViewColumn('Tweet')
        # add the two tree view columns to the treeview
        #self.treeview.append_column(self.tvcname)
        self.treeview.append_column(self.tvctweet)
        # we need a CellRendererText to render the data

        # add the cell renderer to the columns
        #self.tvcname.pack_start(cell_text, True)
    	#self.tvctweet.pack_start(cell,True)
        #self.tvctweet.pack_start(cell_text,True)

        # set the cell "text" attribute to column 0 - retrieve text
        # from that column in liststore and treat it as the text to render
        # in this case it's the name of a tweeter
        #self.tvcname.add_attribute(self.cell, 'text', 0)
        # we then use the second field of our liststore to hold the colour for
        # the 'name' text
        #self.tvcname.add_attribute(self.cell, 'foreground', 1)
        # next we add a mapping to the tweet column, again the third field
        # in our list store is the tweet text
        self.tvctweet.add_attribute(self.cell, 'text', 2)
        self.tvctweet.add_attribute(self.cell, 'timestamp', 6)
        self.tvctweet.add_attribute(self.cell, 'replyto', 7)
        self.tvctweet.add_attribute(self.cell, 'source', 8)
        # and the fourth is the colour of the tweet text 
        #self.tvctweet.add_attribute(cell, 'foreground', 3)
        # we start up non-fullscreen, and we want the tweets to appear without
        # scrolling left-right (well I wanted that) so I set a wrap width for
        # the text being rendered
        #cell.set_property('wrap-width', self.defaultwidth)
        # make it searchable (I found this in an example and thought I might use it
        # but currently I make no use of this setting
        self.treeview.set_search_column(2)
        self.treeview.set_rules_hint(True)

        self.treeview.set_property('enable-grid-lines', True)
        # Allow sorting on the column. This is cool because no matter what order
        # we load tweets in, we always get a view which is sorted by the tweet id which
        # always increments, so we get them in order

        self.liststore.set_sort_column_id(4, gtk.SORT_DESCENDING)
        self.dmliststore.set_sort_column_id(4, gtk.SORT_DESCENDING)
        self.mentionliststore.set_sort_column_id(4, gtk.SORT_DESCENDING)
        self.publicliststore.set_sort_column_id(4, gtk.SORT_DESCENDING)
        self.searchliststore.set_sort_column_id(4, gtk.SORT_DESCENDING)
        #want to order the friends list by name
        self.friendsliststore.set_sort_column_id(0, gtk.SORT_ASCENDING)
        # I don't want to accidentally be dragging and dropping rows out of order
        self.treeview.set_reorderable(False)
        #with all that done I add the treeview to the scrolled window
        pannedWindow.add_with_viewport(self.treeview)
        pannedWindow.connect('horizontal-movement', self.gesture)
        pannedWindow.connect('vertical-movement', self.scrolling)
        #self.treeview.connect("button-press-event", self.build_menu, None);
        selection = self.treeview.get_selection()
        #selection.connect('changed', self.build_menu)
        self.treeview.connect('row-activated', self.build_menu)

        # self.treeview.connect("changed", self.build_menu, None);
        #self.treeview.tap_and_hold_setup(self.urlmenu, callback=gtk.tap_and_hold_menu_position_top)
    	#init the configDialog
        self.configDialog = None
        if (re.search("UserName", self.username)):
           self.promptForCredentials()
        #call the refresh thread
        self.gettingTweets = False
        self.start_refresh_threads()



    def quit(self, *args):
        #this is our end method called when window is closed
        print "Stop Wittering"
	print "shutting down refresh loop"
	self.writeConfig()
	self.end_refresh_threads()

        gtk.main_quit()

    def create_m5_menu(self, widget):
        #a fairly standard menu create
        #I put in the same options as I have buttons
        # and linked to the same methods
        menu = hildon.AppMenu()

        GetTweets = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        command_id = "Get Tweets"
        GetTweets.set_label(command_id)
        # Attach callback to clicked signal
        GetTweets.connect("clicked", self.getTweets)
        GetTweets.show()
        menu.append(GetTweets)
        Tweets = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        Tweets.set_label("Tweet")
        # Attach callback to clicked signal
        Tweets.connect("clicked", self.newTweet)
        Tweets.show()
        menu.append(Tweets)

        TwitPic = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        TwitPic.set_label("TwitPic!")
        # Attach callback to clicked signal
        TwitPic.connect("clicked", self.selectImage)
        TwitPic.show()
        menu.append(TwitPic)

        Creds = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        Creds.set_label("Basic Auth setup")
        # Attach callback to clicked signal
        Creds.connect("clicked", self.promptForCredentials)
        Creds.show()
        menu.append(Creds)

        Creds2 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        Creds2.set_label("OAuth setup")
        # Attach callback to clicked signal
        Creds2.connect("clicked", self.configOauth)
        Creds2.show()
        menu.append(Creds2)

        Service = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        Service.set_label("Toggle ServiceType")
        # Attach callback to clicked signal
        Service.connect("clicked", self.switchService)
        Service.show()
        menu.append(Service)


        Properties2 = hildon.ColorButton()
        Properties2.set_label("BgColour_top")
        # Attach callback to clicked signal
        Properties2.connect("clicked", self.top_colour_changed)
        Properties2.show()
        menu.append(Properties2)
        Properties3 = hildon.ColorButton()
        Properties3.set_label("BgColour_bottom")
        # Attach callback to clicked signal
        Properties3.connect("clicked", self.bottom_colour_changed)
        Properties3.show()
        menu.append(Properties3)
        Properties = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        Properties.set_label("Preferences")
        # Attach callback to clicked signal
        Properties.connect("clicked", self.configProperties)
        Properties.show()
        menu.append(Properties)
	About = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        About.set_label("About")
        # Attach callback to clicked signal
        About.connect("clicked", self.about)
        About.show()
        menu.append(About)

        #invert no longer works
        #Invert = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        #Invert.set_label("Invert")
        # Attach callback to clicked signal
        #Invert.connect("clicked", self.flipTextColour)
        #Invert.show()
        #menu.append(Invert)

        #user can hit the big X for exit, no need for it in menu
        #Exit = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        #Exit.set_label("Exit")
        ## Attach callback to clicked signal
        #Exit.connect("clicked", self.quit)
        #Exit.show()
        #menu.append(Exit)

        menu.show_all()
        return menu

    def run(self):
        #this is the main execution method
        # we set things visible, connect a couple of event hooks to methods
        # specifically to handle switching in and our of fullscreen
        self.window.show_all()
        self.window.connect("key-press-event", self.on_key_press)
        #self.window.connect("button-press-event", self.on_button_pressed)
        self.window.connect("window-state-event", self.on_window_state_change)
        #hide the action buttons
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.builder.get_object("hbuttonbox-more").hide_all()
        #this starts everything up
        gtk.main()


    def updateSelectedView(self, *args):
        #call the get method for whichever liststore we're viewing
        if (self.treeview.get_model() == self.liststore):
            #self.getTweets()
    	    refreshtask = witter.RefreshTask(self.getTweetsWrapper, 0, self.showBusy)
    	    refreshtask.refresh()
        elif (self.treeview.get_model() == self.dmliststore):
            refreshtask = witter.RefreshTask(self.getDMsWrapper, 0, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.mentionliststore):

    	    refreshtask = witter.RefreshTask(self.getMentionsWrapper, 0, self.showBusy)
    	    refreshtask.refresh()
        elif (self.treeview.get_model() == self.publicliststore):
            refreshtask = witter.RefreshTask(self.getPublicWrapper, 0, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.trendliststore):
            refreshtask = witter.RefreshTask(self.getTrendsWrapper, 0, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.friendsliststore):
            refreshtask = witter.RefreshTask(self.getFriendsWrapper, 0, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.searchliststore):
            refreshtask = witter.RefreshTask(self.getSearchWrapper, 0, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.userhistoryliststore):
            refreshtask = witter.RefreshTask(self.getUserHistWrapper, 0, self.showBusy)
            refreshtask.refresh()

	self.builder.get_object("hbox1").hide_all()
	#self.builder.get_object("hbox2").hide_all()


    def getTweets(self, auto=0, older=False, get_count=20, * args):
        self.showBusy(1)
    	if (self.gettingTweets == True):
    		#already in this method in a refresh
            print "a thread is already getting tweets"
            self.showBusy(-1)
            return
    	self.gettingTweets = True
        print "getting tweets"
        receive_count = 0
        try:
            #if we have an access token, use oauth
            if (self.access_token != ""):
                print "using oauth to get tweets"
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.user == ""):
                    self.user = twitter.GetUserInfo()
                #by default we get newer tweets
                if (older == False):
                    if self.last_id == None:
                        data = twitter.GetFriendsTimeline()
                    else:
                        print "refreshing since" + str(self.last_id)
                        data = twitter.GetFriendsTimeline(since_id=self.last_id)
                else:
                    if self.oldest_id == None:
                        data = twitter.GetFriendsTimeline(count=get_count)
                    else:
                        print "refreshing prior to" + str(self.oldest_id)
                        data = twitter.GetFriendsTimeline(max_id=self.oldest_id, count=get_count)

                for x in data:
                    self.getStatus(x.user.screen_name, x.text, x.id, x.created_at, x.in_reply_to_screen_name, x.in_reply_to_status_id, "tweet", x.source)
                    receive_count = receive_count + 1

                if (receive_count > 0):
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint(str(receive_count) + " Tweets Received")
                self.gettingTweets = False
            else:
                #Now for the main logic...fetching tweets
                #at the moment I'm just using basic auth. 
                #urllib2 provides all the HTTP handling stuff
                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri=self.serviceUrlRoot + 'statuses/friends_timeline.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)
                #switch on whether this is an refresh or a first download
                if self.last_id == None:
                    json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/friends_timeline.json')
                else:
                    #basically the twitter API will respond with just tweets newer than the ID we send
                    json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/friends_timeline.json?since_id=' + str(self.last_id) + 'L')
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())

                #then this line does all the hard work. Basicaly for evey top level object in the JSON
                #structure we call out getStatus method with the contents of the USER structure
                #and the values of top level values text/id/created_at

                for x in data:
                    user = x['user']
                    self.getStatus(user['screen_name'], x['text'], x['id'], x['created_at'], x['in_reply_to_screen_name'], x['in_reply_to_status_id'], "tweet", x['source'])
                    receive_count = receive_count + 1

                if (receive_count > 0):
        		    note = osso.SystemNote(self.osso_c)
        		    result = note.system_note_infoprint(str(receive_count) + " Tweets Received")
        	self.gettingTweets = False
        except IOError, e:
            print "error"
            self.gettingTweets = False
            msg = 'Error retrieving tweets '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
		            reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
	        if (auto == 0):
    		    note = osso.SystemNote(self.osso_c)
    		    note.system_note_dialog(msg)
            print msg

	    self.gettingTweets = False
        if (auto == 0):
            self.scrollToSelectedTweet()
        self.showBusy(-1)


    def getDMs(self, auto=0, older=False, get_count=20, * args):
        self.showBusy(1)
        self.gettingTweets = True
        print "getting DMs"
        receive_count = 0
        try:
            #if we have an access token, use oauth
            if (self.access_token != ""):
                print "using oauth to get dms"
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.user == ""):
                    self.user = twitter.GetUserInfo()

                if self.last_dm_id == None:
                    data = twitter.GetDirectMessages()
                else:
                    print "refreshing since" + str(self.last_dm_id)
                    data = twitter.GetDirectMessages(since_id=self.last_dm_id)
                for x in data:
                    self.getStatus(x.sender_screen_name, x.text, x.id, x.created_at, "", "", "dm", "unknown")
                    receive_count = receive_count + 1

                if (receive_count > 0):
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint(str(receive_count) + " DMs Received")
            else:
                #Now for the main logic...fetching tweets
                #at the moment I'm just using basic auth. 
                #urllib2 provides all the HTTP handling stuff
                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri=self.serviceUrlRoot + 'direct_messages.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)

                #switch on whether this is an refresh or a first download
                if self.last_dm_id == None:
                    json = urllib2.urlopen(self.serviceUrlRoot + 'direct_messages.json')
                else:
                    json = urllib2.urlopen(self.serviceUrlRoot + 'direct_messages.json?since_id=' + str(self.last_dm_id) + 'L')
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())
                #then this line does all the hard work. Basicaly for evey top level object in the JSON
                #structure we call out getStatus method with the contents of the USER structure
                #and the values of top level values text/id/created_at

                for x in data:
                    user = x['sender']
                    self.getStatus(user['screen_name'], x['text'], x['id'], x['created_at'], "", "", "dm", "unknown")
                    receive_count = receive_count + 1

                if (receive_count > 0):
        		    note = osso.SystemNote(self.osso_c)
        		    result = note.system_note_infoprint(str(receive_count) + " DMs Received")
                self.gettingTweets = False
        except IOError, e:
            msg = 'Error retrieving DMs '
            if hasattr(e, 'reason'):
		      msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
		            reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if (auto == 0):
		       note = osso.SystemNote(self.osso_c)
		       note.system_note_dialog(msg)
	    self.gettingTweets = False
        if (auto == 0):
            self.scrollToSelectedTweet()
        self.showBusy(-1)



    def getMentions(self, auto=0, older=False, get_count=20, * args):
        self.showBusy(1)

        self.gettingTweets = True
        print "getting Mentions"
        receive_count = 0
        try:
            #if we have an access token, use oauth
            if (self.access_token != ""):
                print "using oauth to get mentions"
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.user == ""):
                    self.user = twitter.GetUserInfo()

                if self.last_mention_id == None:
                    data = twitter.GetReplies()
                else:
                    print "refreshing since" + str(self.last_mention_id)
                    data = twitter.GetReplies(since_id=self.last_mention_id)
                for x in data:
                    self.getStatus(x.user.screen_name, x.text, x.id, x.created_at, x.in_reply_to_screen_name, x.in_reply_to_status_id, "mention", x.source)
                    receive_count = receive_count + 1

                if (receive_count > 0):
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint(str(receive_count) + " Mentions Received")
            else:
                #Now for the main logic...fetching tweets
                #at the moment I'm just using basic auth. 
                #urllib2 provides all the HTTP handling stuff
                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri=self.serviceUrlRoot + 'statuses/mentions.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)

                #switch on whether this is an refresh or a first download
                if self.last_mention_id == None:
                    json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/mentions.json')
                else:
                    json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/mentions.json?since_id=' + str(self.last_mention_id) + 'L')
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())

                #then this line does all the hard work. Basicaly for evey top level object in the JSON
                #structure we call out getStatus method with the contents of the USER structure
                #and the values of top level values text/id/created_at

                for x in data:
                    user = x['user']
                    self.getStatus(user['screen_name'], x['text'], x['id'], x['created_at'], x['in_reply_to_screen_name'], x['in_reply_to_status_id'], "mention", x['source'])
                    receive_count = receive_count + 1

                if (receive_count > 0):
        		    note = osso.SystemNote(self.osso_c)
        		    result = note.system_note_infoprint(str(receive_count) + " Mentions Received")

                self.gettingTweets = False
        except IOError, e:
                    msg = 'Error retrieving Mentions '
        	    if hasattr(e, 'reason'):
        		    msg = msg + str(e.reason)

                    if hasattr(e, 'code'):
                        if (e.code == 401):
                            reason = "Not authorised: check uid/pwd"
        		elif(e.code == 503):
        		    reason = "Service unavailable"
                        else:
                            reason = ""
                        msg = msg + 'Server returned ' + str(e.code) + " : " + reason
        	    if (auto == 0):
        		    note = osso.SystemNote(self.osso_c)
        		    note.system_note_dialog(msg)
        self.gettingTweets = False
        if (auto == 0):
            self.scrollToSelectedTweet()
        self.showBusy(-1)

    def getUserHistory(self, friend="", auto=0, older=False, get_count=20, * args):
        self.showBusy(1)

        self.gettingTweets = True
        print "getting User history for " + friend
        self.userhistoryliststore.clear()
        receive_count = 0
        try:
            #if we have an access token, use oauth
            if (self.access_token != ""):
                print "using oauth to get user history"
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.user == ""):
                    self.user = twitter.GetUserInfo()

                data = twitter.GetUserTimeline(id=friend)

                for x in data:
                    self.getStatus(x.user.screen_name, x.text, x.id, x.created_at, x.in_reply_to_screen_name, x.in_reply_to_status_id, "user", x.source)
                    receive_count = receive_count + 1

                if (receive_count > 0):
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint(str(receive_count) + " User tweets Received")
            else:
                #Now for the main logic...fetching tweets
                #at the moment I'm just using basic auth. 
                #urllib2 provides all the HTTP handling stuff
                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri=self.serviceUrlRoot + 'statuses/friends_timeline.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)

                #switch on whether this is an refresh or a first download
                json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/friends_timeline.json')
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())

                #then this line does all the hard work. Basicaly for evey top level object in the JSON
                #structure we call out getStatus method with the contents of the USER structure
                #and the values of top level values text/id/created_at

                for x in data:
                    user = x['user']
                    self.getStatus(user['screen_name'], x['text'], x['id'], x['created_at'], x['in_reply_to_screen_name'], x['in_reply_to_status_id'], "user", x['source'])
                    receive_count = receive_count + 1

                if (receive_count > 0):
                    note = osso.SystemNote(self.osso_c)
                    result = note.system_note_infoprint(str(receive_count) + " User History Received")

                self.gettingTweets = False
        except IOError, e:
                msg = 'Error retrieving User History '
                if hasattr(e, 'reason'):
                    msg = msg + str(e.reason)

                    if hasattr(e, 'code'):
                        if (e.code == 401):
                            reason = "Not authorised: check uid/pwd"
                        elif(e.code == 503):
                            reason = "Service unavailable"
                        else:
                            reason = ""
                        msg = msg + 'Server returned ' + str(e.code) + " : " + reason
                if (auto == 0):
                    note = osso.SystemNote(self.osso_c)
                    note.system_note_dialog(msg)
        self.gettingTweets = False
        if (auto == 0):
            self.scrollToSelectedTweet()
        self.showBusy(-1)


    def getPublic(self, auto=0, older=False, get_count=20, * args):
        self.showBusy(1)
        self.gettingTweets = True
        print "getting Public timeline"

        try:
            #switch on whether this is an refresh or a first download
            if self.last_public_id == None:
                json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/public_timeline.json')
            else:
                json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/public_timeline.json?since_id=' + str(self.last_public_id) + 'L')
            #JSON is awesome stuff. we get given a long string of json encoded information
            #which contains all the tweets, with lots of info, we decode to a json object
            data = simplejson.loads(json.read())
            #then this line does all the hard work. Basicaly for evey top level object in the JSON
            #structure we call out getStatus method with the contents of the USER structure
            #and the values of top level values text/id/created_at
            receive_count = 0
    	    for x in data:
    		    self.getStatus(x['user'], x['text'], x['id'], x['created_at'], x['in_reply_to_screen_name'], x['in_reply_to_status_id'], "public", x['source'])
    		    receive_count = receive_count + 1

    	    if (receive_count > 0):
    		    note = osso.SystemNote(self.osso_c)
    		    result = note.system_note_infoprint(str(receive_count) + " Public timeline tweets Received")

        except IOError, e:
            msg = 'Error retrieving Public timeline '
            if hasattr(e, 'reason'):
		          msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
		            reason = "Service unavailable"
                else:
                    reason = ""
            msg = msg + 'Server returned ' + str(e.code) + " : " + reason
            if(auto == 0):
		          note = osso.SystemNote(self.osso_c)
		          note.system_note_dialog(msg)
	    self.gettingTweets = False
        if (auto == 0):
            self.scrollToSelectedTweet()
        self.showBusy(-1)


    def getSearch(self, auto=0, older=False, get_count=20, * args):
        self.showBusy(1)
        print "performing search"
	    #clear any previous stuff, currenlty we'll just get one page of search results
        self.searchliststore.clear()
        #overloading the tweet text input as the search criteria
        searchterm = self.builder.get_object("TweetText").get_text()
        if (auto == 1):
    		#auto search performed frrom the saved search
    		searchterm = self.search_terms

        #see if we have just an empty string (eg eroneous button press)
        if (searchterm == ""):
            print "nothing to search"
            self.showBusy(-1)
            return


        #split the tweet text on any comma , 

    	searchTerms = searchterm.split(",")
    	#call search on each of the terms in the search str
    	for term in searchTerms:
    		term = unicode(term).encode('utf-8')
    		#then we need to urlencode so that we can use twitter chars like @ without
    		#causing problems
    		search = urllib.urlencode({ 'q' : term })

    		try:
    		    json = urllib2.urlopen(self.searchServiceUrlRoot + 'search.json?' + search)

    		    #JSON is awesome stuff. we get given a long string of json encoded information
    		    #which contains all the tweets, with lots of info, we decode to a json object
    		    data = simplejson.loads(json.read())
    		    #then this line does all the hard work. Basicaly for evey top level object in the JSON
    		    #structure we call out getStatus method with the contents of the USER structure
    		    #and the values of top level values text/id/created_at

    		    results = data['results']
    		    [self.getStatus(x['from_user'], x['text'], x['id'], x['created_at'], None, None, "search", x['source']) for x in results]
    		    note = osso.SystemNote(self.osso_c)

    		    result = note.system_note_infoprint("Search results Received for : " + term)
    		except IOError, e:
    		    msg = 'Error retrieving search results '
    		    if hasattr(e, 'reason'):
    			    msg = msg + str(e.reason)

    		    if hasattr(e, 'code'):
    			if (e.code == 401):
    			    reason = "Not authorised: check uid/pwd"
    			elif(e.code == 503):
    			    reason = "Service unavailable"
    			else:
    			    reason = ""
    			msg = msg + 'Server returned ' + str(e.code) + " : " + reason
    		    if (auto == 0):
    			    note = osso.SystemNote(self.osso_c)
    			    note.system_note_dialog(msg)

        if (auto == 0):
            self.scrollToSelectedTweet()
        self.showBusy(-1)




    def getTrends(self, *args):
        self.showBusy(1)
        print "getting Trending topics"
        #first clear the previous 10
        self.trendliststore.clear()

        try:
            json = urllib2.urlopen(self.searchServiceUrlRoot + 'trends.json')
            #JSON is awesome stuff. we get given a long string of json encoded information
            #which contains all the tweets, with lots of info, we decode to a json object
            data = simplejson.loads(json.read())
            #then this line does all the hard work. Basicaly for evey top level object in the JSON
            #structure we call out getStatus method with the contents of the USER structure
            #and the values of top level values text/id/created_at
            trends = data['trends']
            [self.getTrend(x['name'], x['url']) for x in trends]
	    note = osso.SystemNote(self.osso_c)

	    result = note.system_note_infoprint("Trends Received")
        except IOError, e:
            msg = 'Error retrieving trends '
            if hasattr(e, 'reason'):
		       msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
		            reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason
                note = osso.SystemNote(self.osso_c)
                note.system_note_dialog(msg)
        self.showBusy(-1)


    def getTrend(self, name, url):

        self.trendliststore.append([name, self.namecolour, name + " :" + url, self.tweetcolour, "", "dm", "", "", ""])


    def getFriends(self, auto=0, older=False, get_count=20, * args):
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
        print "getting Friends"
        try:
            #first clear the previous 10
            self.friendsliststore.clear()
            receive_count = 0

            #if we have an access token, use oauth
            if (self.access_token != ""):
                print "using oauth to get friends"
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.user == ""):
                    self.user = twitter.GetUserInfo()

                data = twitter.GetFriends()
                if (data != None):
                    for x in data:
                        #it's possible to follow someone that has never updated their status
                        if (x.status != None):
                            status = x.status.text
                            tweettime = x.status.created_at
                            source = x.status.source
                        else:
                            status = ""
                            tweettime = ""
                            status = ""
                        self.getStatus(x.screen_name, status, x.id, "", "", "", "friend", status)
                        receive_count = receive_count + 1

                    if (receive_count > 0):
                        note = osso.SystemNote(self.osso_c)
                        result = note.system_note_infoprint(str(receive_count) + " Friends Received")
            else:
                #Now for the main logic...fetching tweets
                #at the moment I'm just using basic auth. 
                #urllib2 provides all the HTTP handling stuff
                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri=self.serviceUrlRoot + 'statuses/friends.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)


                json = urllib2.urlopen(self.serviceUrlRoot + 'statuses/friends.json')
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())

                #then this line does all the hard work. Basicaly for evey top level object in the JSON
                #structure we call out getStatus method with the contents of the USER structure
                #and the values of top level values text/id/created_at

                for x in data:
                    #if we follow someone with no status then you get a key error on status
                    try:
                        status = x['status']
                        self.getStatus(x['screen_name'], status['text'], x['id'], x['created_at'], "", "", "friend")
                    except KeyError:
                        print  x
    	        note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint("Friends Received")
        except IOError, e:
            msg = 'Error retrieving friends '
            if hasattr(e, 'reason'):
		          msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
		            reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = hildon.hildon_note_new_information(self.window, msg)
            note.run()
            note.destroy()

        hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)



    def getStatus(self, user, data, id, created_at, in_reply_to_screen_name, in_reply_to_id, type, source):
        #at this point user is another JSON structure of lots more values of which we are currently
        #only interested in screen_name
        #append to our list store the values from the JSON data we've been passed for a tweet
        #
        #we want to strip off the html stuff around any source if there is some
        #don't bother if the id matches any of the last stored ones, when retrieving 'older' tweets
        #we seemt o get duplicates
        # | id == self.last_id | id == self.last_mention_id | id == self.last_public_id):
        if (self.last_dm_id != None):
            if (id == self.last_dm_id):
                return
        if (self.last_mention_id != None):
            if (id == self.last_mention_id):
                return
        if (self.last_id != None):
            if (id == self.last_id):
                return
        if (self.last_public_id != None):
            if (id == self.last_public_id):
                return
        if (re.search("</a>", source)):
            startChar = source.find(">")
            endChar = source.find("</a>")
            source = source[startChar + 1:endChar]
        if (re.search("&lt;/a&gt;", source)):
            startChar = source.find("&gt;")
            endChar = source.find("&lt;/a&gt;")
            source = source[startChar + 4:endChar]
        if (re.search("tweet", type)):
            if (None != in_reply_to_id):
                print "reply to " + in_reply_to_screen_name
                #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                reply_to = "In reply to: " + in_reply_to_screen_name + " - " + self.get_specific_tweet(in_reply_to_screen_name, in_reply_to_id)
            else:
                reply_to = ""
            data = data.replace("&", "&amp;")
            reply_to = reply_to.replace("&", "&amp;")
            self.liststore.append([ "@" + user, self.namecolour, "@" + user + " : " + data, self.tweetcolour, id, type, created_at, reply_to, source])
            #now we process the id, this is so we can do a refresh with just the posts since the latest one we have
            #if we haven't stored the most recent id then store this one
            if self.last_id == None:
                self.last_id = id
            else:
                #if we have an id stored, check if this one is 'newer' if so then store it
                if long(self.last_id) < long(id):
                    self.last_id = id

            #also want to track the oldest we get hold of
            if self.oldest_id == None:
                self.oldest_id = id
            else:
                if long(self.oldest_id) > long(id):
                    self.oldest_id = id

        elif (re.search("dm", type)):
	    reply_to = ""
            data = data.replace("&", "&amp;")
            self.dmliststore.append([ "@" + user, self.namecolour, "@" + user + " : " + data, self.tweetcolour, id, type, created_at, reply_to, source])
            if self.last_dm_id == None:
                self.last_dm_id = id
            else:
                #if we have an id stored, check if this one is 'newer' if so then store it
                if long(self.last_dm_id) < long(id):
                    self.last_dm_id = id

                #also want to track the oldest we get hold of
            if self.oldest_dm_id == None:
                self.oldest_dm_id = id
            else:
                if long(self.oldest_dm_id) > long(id):
                    self.oldest_dm_id = id

        elif (re.search("mention", type)):
            if (None != in_reply_to_id):
                print "reply to " + in_reply_to_screen_name
                #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                reply_to = "In reply to: " + in_reply_to_screen_name + " - " + self.get_specific_tweet(in_reply_to_screen_name, in_reply_to_id)
            else:
                reply_to = ""
            data = data.replace("&", "&amp;")
            reply_to = reply_to.replace("&", "&amp;")
            self.mentionliststore.append([ "@" + user, self.namecolour, "@" + user + " : " + data, self.tweetcolour, id, type, created_at, reply_to, source])
            if self.last_mention_id == None:
                self.last_mention_id = id
            else:
                #if we have an id stored, check if this one is 'newer' if so then store it
                if long(self.last_mention_id) < long(id):
                    self.last_mention_id = id

            #also want to track the oldest we get hold of
            if self.oldest_mention_id == None:
                self.oldest_mention_id = id
            else:
                if long(self.oldest_mention_id) > long(id):
                    self.oldest_mention_id = id
        elif (re.search("user", type)):
            if (None != in_reply_to_id):
                print "reply to " + in_reply_to_screen_name
                #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                reply_to = "In reply to: " + in_reply_to_screen_name + " - " + self.get_specific_tweet(in_reply_to_screen_name, in_reply_to_id)
            else:
                reply_to = ""
            data = data.replace("&", "&amp;")
            reply_to = reply_to.replace("&", "&amp;")
            self.userhistoryliststore.append([ "@" + user, self.namecolour, "@" + user + " : " + data, self.tweetcolour, id, type, created_at, reply_to, source])
            if self.last_friend_history_id == None:
                self.last_friend_history_id = id
            else:
                #if we have an id stored, check if this one is 'newer' if so then store it
                if long(self.last_friend_history_id) < long(id):
                    self.last_friend_history_id = id

            #also want to track the oldest we get hold of
            if self.oldest_friend_history_id == None:
                self.oldest_friend_history_id = id
            else:
                if long(self.oldest_friend_history_id) > long(id):
                    self.oldest_friend_history_id = id

        elif (re.search("public", type)):
            if (None != in_reply_to_id):
                print "reply to " + in_reply_to_screen_name
                #we don't want anything showing up if there is no reply_to, so all teh formatting is held here including the newline
                reply_to = "In reply to: " + in_reply_to_screen_name + " - " + self.get_specific_tweet(in_reply_to_screen_name, in_reply_to_id)
            else:
                reply_to = ""
            data = data.replace("&", "&amp;")
            reply_to = reply_to.replace("&", "&amp;")
            self.publicliststore.append([ "@" + user['screen_name'], self.namecolour, "@" + user['screen_name'] + " : " + data, self.tweetcolour, id, type, created_at, reply_to, source])
            if self.last_public_id == None:
                self.last_public_id = id
            else:
                #if we have an id stored, check if this one is 'newer' if so then store it
                if long(self.last_public_id) < long(id):
                    self.last_public_id = id

            #also want to track the oldest we get hold of
            if self.oldest_public_id == None:
                self.oldest_public_id = id
            else:
                if long(self.oldest_public_id) > long(id):
                    self.oldest_public_id = id

        elif (re.search("friend", type)):
            reply_to = ""
            text_data = data.replace("&", "&amp;")
            self.friendsliststore.append([ "@" + user, self.namecolour, "@" + user + " : " + text_data, self.tweetcolour, id, type, created_at, reply_to, source])
        elif (re.search("search", type)):
            reply_to = ""
            data = data.replace("&", "&amp;")

            self.searchliststore.append([ "@" + user, self.namecolour, "@" + user + " : " + data, self.tweetcolour, id, type, created_at, reply_to, source])


    def enterPressed(self, widget, *args):
	    self.newTweet(self, widget, *args)
	    #if we were in the search view, we want to restore the search terms after a tweet
	    if (self.treeview.get_model() == self.searchliststore):
		    self.tweetText.set_text(self.search_terms)



    def newTweet(self, widget, *args):
        #The other main need of a twitter client
        #the ability to post an update
        #get the tweet text from the input box
        self.showBusy(1)
        tweet = self.builder.get_object("TweetText").get_text()
        #see if we have just an empty string (eg eroneous button press)
        if (tweet == ""):
            self.showBusy(-1)
            return
        if (self.access_token != ""):
            print "using oauth"
            try:
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.reply_to_name != None):
                    if (re.search(self.reply_to_name, tweet)):
                        #this is a reply
                        status = twitter.PostUpdate(tweet, self.reply_to)
                    else:
                        status = twitter.PostUpdate(tweet)
                else:
                    status = twitter.PostUpdate(tweet)
                hildon.hildon_banner_show_information(self.window, "", "Tweet Successful")
                self.reply_to_name = None
                self.reply_to = None
                #last thing to do is refresh main feed
                self.tweetText.set_text("")
                refreshtask = witter.RefreshTask(self.getTweetsWrapper, 0, self.showBusy)
                refreshtask.refresh()
            except IOError, e:
                msg = 'Error posting tweet '
                if hasattr(e, 'reason'):
                    msg = msg + str(e.reason)

                if hasattr(e, 'code'):
                        if (e.code == 401):
                            reason = "Not authorised: check uid/pwd"
                        elif(e.code == 503):
                            reason = "Service unavailable"
                        else:
                            reason = ""
                        msg = msg + 'Server returned ' + str(e.code) + " : " + reason

                note = hildon.hildon_note_new_information(self.window, msg)
                note.run()
                note.destroy()

        else:
            #first we need to encode for utf-8
            tweet = unicode(tweet).encode('utf-8')

            if (self.reply_to_name != None):
                if (re.search(self.reply_to_name, tweet)):
                    #the tweet text is still a reply to this person
                    print "adding reply to information"
                     #we get the text in the input box then we construct the outbound tweet

                    #then we need to urlencode so that we can use twitter chars like @ without
                    #causing problems

                    post = urllib.urlencode({ 'status' : tweet, 'in_reply_to_status_id' : self.reply_to })

                else:
                    #since setting the reply to id the user has removed the reference to the person
                    self.reply_to_name = None
                    self.reply_to = None
                    post = urllib.urlencode({ 'status' : tweet })
            else:
                post = urllib.urlencode({ 'status' : tweet })


            #build the request with the url and our post data
            req = urllib2.Request('http://twitter.com/statuses/update.json', post)
            #setup the auth stuff
            auth_handler = urllib2.HTTPBasicAuthHandler()
            auth_handler.add_password(realm='Twitter API',
                                  uri='http://twitter.com/statuses/update.json',
                                  user=self.username,
                                  passwd=self.password)
            opener = urllib2.build_opener(auth_handler)
            # ...and install it globally so it can be used with urlopen.
    	    try:
                urllib2.install_opener(opener)
                json = urllib2.urlopen(req)
        		#opener.close()
                data = simplejson.loads(json.read())
        		#message sent, I'm assuming a failure to send would not continue
        		#in this method? so it's safe to remove the tweet line
        		# what I don't want is to lose the tweet I typed if we didn't
        		# sucessfully send it to twitter. that would be annoying (I'm looking
        		# at you Mauku)
                self.builder.get_object("TweetText").set_text("")
                hildon.hildon_banner_show_information(self.window, "", "Tweet Successful")
                self.reply_to_name = None
                self.reply_to = None
        		#last thing to do is refresh main feed
                self.tweetText.set_text("")
                refreshtask = witter.RefreshTask(self.getTweetsWrapper, 0, self.showBusy)
                refreshtask.refresh()
    	    except IOError, e:
                msg = 'Error posting tweet '
                if hasattr(e, 'reason'):
        		    msg = msg + str(e.reason)

                if hasattr(e, 'code'):
                    if (e.code == 401):
                        reason = "Not authorised: check uid/pwd"
                    elif(e.code == 503):
    		            reason = "Service unavailable"
                    else:
                        reason = ""
                    msg = msg + 'Server returned ' + str(e.code) + " : " + reason

        	    note = hildon.hildon_note_new_information(self.window, msg)
                note.run()
                note.destroy()
        self.showBusy(-1)


    def get_specific_tweet(self, screen_name, tweet_id):
        try:
            #if we have an access token, use oauth
            if (self.access_token != ""):
                print "using oauth to get specific tweets"
                twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
                if (self.user == ""):
                    self.user = twitter.GetUserInfo()

                data = twitter.GetStatus(tweet_id)

                return data.text


            else:
                #this method gets an identified tweet from id and screenname
                #Now for the main logic...fetching tweets
                #at the moment I'm just using basic auth. 
                #urllib2 provides all the HTTP handling stuff
                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri='http://twitter.com/statuses/show/' + str(tweet_id) + 'L.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)



                json = urllib2.urlopen('http://twitter.com/statuses/show/' + str(tweet_id) + 'L.json')

                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())
                return data['text']
        except IOError, e:
            print e
            return "protected tweet"


    def on_window_state_change(self, widget, event, *args):
        #this just sets a flag to keep track of what state we're in
       if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
       else:
            self.window_in_fullscreen = False

    def fullscr(self, *args):
        if (self.window_in_fullscreen == True):
            self.window.unfullscreen ()
            fullscrButton = self.builder.get_object("fullscr")
            image = gtk.Image()
            image.set_from_file("/opt/witter/icons/fullscr.png")
            image.show()
            fullscrButton.set_image(image)
        else:
            self.window.fullscreen ()
            fullscrButton = self.builder.get_object("fullscr")
            image = gtk.Image()
            image.set_from_file("/opt/witter/icons/unfullscr.png")
            image.show()
            fullscrButton.set_image(image)


    def on_key_press(self, widget, event, *args):
        #this picks up the press of the full screen key and toggles
        #from one mode to the other
        if event.keyval == gtk.keysyms.F7:
            print "zoom in"
            if (self.font_size < 30):
                self.treeview.hide()

                self.font_size = self.font_size + 1
                self.cell.set_property('font_size', self.font_size)
                if (self.treeview.get_model() == self.liststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.liststore)
                elif (self.treeview.get_model() == self.dmliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.dmliststore)
                elif (self.treeview.get_model() == self.mentionliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.mentionliststore)
                elif (self.treeview.get_model() == self.publicliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.publicliststore)
                elif (self.treeview.get_model() == self.trendliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.trendliststore)
                elif (self.treeview.get_model() == self.friendsliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.friendsliststore)
                elif (self.treeview.get_model() == self.searchliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.searchliststore)
                elif (self.treeview.get_model() == self.userhistoryliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.userhistoryliststore)
                self.treeview.show()

        elif event.keyval == gtk.keysyms.F8:
            print "zoom out"
            if (self.font_size > 10):
                self.treeview.hide()

                self.font_size = self.font_size - 1
                self.cell.set_property('font_size', self.font_size)
                if (self.treeview.get_model() == self.liststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.liststore)
                elif (self.treeview.get_model() == self.dmliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.dmliststore)
                elif (self.treeview.get_model() == self.mentionliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.mentionliststore)
                elif (self.treeview.get_model() == self.publicliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.publicliststore)
                elif (self.treeview.get_model() == self.trendliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.trendliststore)
                elif (self.treeview.get_model() == self.friendsliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.friendsliststore)
                elif (self.treeview.get_model() == self.searchliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.searchliststore)
                elif (self.treeview.get_model() == self.userhistoryliststore):
                    self.treeview.set_model(None)
                    self.treeview.set_model(self.userhistoryliststore)
                self.treeview.show()

        elif event.keyval == gtk.keysyms.F6:
             # The "Full screen" hardware key has been pressed 
             if self.window_in_fullscreen:
                 self.window.unfullscreen ()
                 #when we toggle off fullscreen set the cell render wrap
                 #to 500
                 self.cell.set_property('wrap-width', self.defaultwidth)
             else:
                self.window.fullscreen ()
                #when we toggle into fullscreen set the cell render wrap
                #wider
                self.cell.set_property('wrap-width', 630)
        else:
            self.builder.get_object("hbox1").show_all()
            self.builder.get_object("hbox2").show_all()
            self.builder.get_object("hbuttonbox-act1").hide_all()
            self.builder.get_object("hbuttonbox-act2").hide_all()
            self.builder.get_object("hbuttonbox-act3").hide_all()
            self.builder.get_object("hbuttonbox-act4").hide_all()
            self.tweetText.grab_focus()
            self.window.unfullscreen ()


    def build_menu(self, widget, *args):
        #first hide the other controls
        print "building menu"
        self.builder.get_object("hbox1").hide_all()
        self.builder.get_object("hbox2").hide_all()
        #
        #empty the dynamic buttons
        buttons = self.builder.get_object("hbuttonbox-act3").get_children()
        for button in buttons:
            self.builder.get_object("hbuttonbox-act3").remove(button)
            button.destroy()
        buttons2 = self.builder.get_object("hbuttonbox-act4").get_children()
        for button in buttons2:
            self.builder.get_object("hbuttonbox-act4").remove(button)
            button.destroy()
        #we need to track how many buttons we create
        #so we know when to create new horizontal button boxes
        b = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                  hildon.BUTTON_ARRANGEMENT_VERTICAL)
        #b.set_title('Dismiss')
        disImage = gtk.Image()
        disImage.set_from_file("/opt/witter/icons/dismiss.png")
        disImage.show()
        b.set_image(disImage)
        b.connect("clicked", self.dismissActionButtons)
        self.builder.get_object("hbuttonbox-act4").pack_end(b, expand=True)


        #get the selection
        treeselection = self.treeview.get_selection()
        select1, select2 = treeselection.get_selected_rows()
        #entry1, entry2 = self.treeview.get_selection().get_selected()
        #we might one day have more than on element selected, for now we get 1 row
        try:
            #we want to scroll to the right place in pannable area, *after* we've shown conrolls
            #so the x/y need to be in the right scope
            selectedItem = None
            if select2 != None:

                for item in select2[0]:
                    #bring the selected item to the top of the view

                    #we want to access field 3 which has or Tweet in it
                    entry = select1.get_value(select1.get_iter(item), 2)
                    #and we might as well list the person who provided the url
                    name = select1.get_value(select1.get_iter(item), 0)
                    id = select1.get_value(select1.get_iter(item), 4)
                    selectedItem = item
                    #exclude logged in user from the reply_all string
                    if (re.search(self.username.lower(), name.lower())):
                        self.reply_all = ""
                    else:
                        self.reply_all = name
                    if re.search("http", entry):
                        #convert the string to chunks deliniated on space (we assume the url 
                        #has spaces around it 
                        L = string.split(entry)
                        for word in L :
                            #find the 'word' which is our url
                            if re.search("http", word):
                                url = word

                                b = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                  hildon.BUTTON_ARRANGEMENT_VERTICAL)
                                b.set_title('Open Url')
                                b.set_value(url)
                                b.connect("clicked", self.openBrowser, url)
                                self.builder.get_object("hbuttonbox-act3").pack_start(b, expand=True)
                    if re.search("@", entry):
                        L = string.split(entry)
                        for word in L :
                            if re.search("@", word):
                                user = word
                                if (user != name):
                                    if (re.search(self.username.lower(), user.lower())):
                                        print "excluding self from reply all"
                                    else:
                                        self.reply_all = self.reply_all + " " + user
                                    b = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                      hildon.BUTTON_ARRANGEMENT_VERTICAL)
                                    b.set_title('Follow')
                                    b.set_value(user)
                                    b.connect("clicked", self.FollowUser, user)
                                    self.builder.get_object("hbuttonbox-act4").pack_start(b, expand=True)
                                    b2 = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                      hildon.BUTTON_ARRANGEMENT_VERTICAL)

                                    b2.set_value(user)
                                    b2.connect("clicked", self.tweetAtUser, user)
                                    self.builder.get_object("hbuttonbox-act4").pack_start(b2, expand=True)
                                    b3 = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                      hildon.BUTTON_ARRANGEMENT_VERTICAL)

                                    b3.set_title('History')
                                    b3.set_value(user)
                                    b3.connect("clicked", self.showHist, user)
                                    self.builder.get_object("hbuttonbox-act4").pack_start(b3, expand=True)


                    #rect = self.treeview.get_background_area(item, self.tvctweet)
                    #x, y = self.treeview.convert_bin_window_to_tree_coords(rect.x, rect.y)
                #only provide a follow button if we aren't in our own timeline (in which case we're already following
                if (self.treeview.get_model() != self.liststore):
                    followButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                          hildon.BUTTON_ARRANGEMENT_VERTICAL)
                    followButton.set_title('Follow')
                    followButton.set_value(name)
                    followButton.connect("clicked", self.FollowUser, name)
                    self.builder.get_object("hbuttonbox-act3").pack_start(followButton, expand=True)
                unfollowButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                      hildon.BUTTON_ARRANGEMENT_VERTICAL)
                unfollowButton.set_title('unFollow')
                unfollowButton.set_value(name)
                unfollowButton.connect("clicked", self.UnFollowUser, name)
                self.builder.get_object("hbuttonbox-act3").pack_start(unfollowButton, expand=True)
                histButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT,
                                                      hildon.BUTTON_ARRANGEMENT_VERTICAL)
                histButton.set_title('History')
                histButton.set_value(name)
                histButton.connect("clicked", self.showHist, name)
                self.builder.get_object("hbuttonbox-act3").pack_start(histButton, expand=True)

                self.builder.get_object("AtUser").set_label(name)

                self.reply_to = id
                self.reply_to_name = name

                self.retweettext = entry
                self.retweetname = name
                self.retweetid = id

        except IndexError:
            print "nothing selected"

        self.builder.get_object("hbuttonbox-act1").show_all()
        self.builder.get_object("hbuttonbox-act2").show_all()
        self.builder.get_object("hbuttonbox-act3").show_all()
        self.builder.get_object("hbuttonbox-act4").show_all()
        self.scrollToItem(selectedItem)

    def scrollToItem(self, item):
        try:
            rect = self.treeview.get_background_area(item, self.tvctweet)
            x, y = self.treeview.convert_bin_window_to_tree_coords(rect.x, rect.y)

            self.builder.get_object("pannableArea").scroll_to(x, y + 100)
        except TypeError:
            print "couldn't scroll to item"

    def scrollToSelectedTweet(self):
        #get the selection
        self.scrollToItem(self.getSelectedTweet())

    def getSelectedTweet(self):
        #get the selection
        try:
            treeselection = self.treeview.get_selection()
            select1, select2 = treeselection.get_selected_rows()
            if select2 != None:
               for item in select2[0]:
                    return item
        except IndexError:
            print "probably nothing selected"
            return None

    def dismissActionButtons(self, *args):
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.builder.get_object("hbox2").show_all()

    def FollowTweetAuthor(self, widget):
        self.FollowUser(widget, self.reply_to_name)

    def FollowUser(self, widget, name, *args):
        #strip out the @ which isn't really part of the username
        self.showBusy(1)
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.builder.get_object("hbox2").show_all()

        name = name.replace("@", "")
        print "follow: " + name

        try:

            #if we have an access token, use oauth
     #       if (self.access_token != ""):
      #          print "using oauth to unfollow"
       #         twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
        #        if (self.user == ""):
         #           self.user = twitter.GetUserInfo()
#
 #               data = twitter.CreateFriendship(name)
  #              note = osso.SystemNote(self.osso_c)
   #             result = note.system_note_infoprint("Now following " + name)
#
 #           else:
                post = urllib.urlencode({ 'screen_name' : name })

                #build the request with the url and our post data
                req = urllib2.Request('http://twitter.com/friendships/create.json', post)

                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser

                auth_handler.add_password(realm='Twitter API',
                                  uri='http://twitter.com/friendships/create.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)
                #switch on whether this is an refresh or a first download

                json = urllib2.urlopen(req)
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint("Now following " + name)
        except IOError, e:
            print "error"
            msg = 'Error following ' + name + ' '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = osso.SystemNote(self.osso_c)
            note.system_note_dialog(msg)
            print msg
        self.showBusy(-1)

    def UnFollowTweetAuthor(self, widget):
        self.UnFollowUser(widget, self.reply_to_name)

    def UnFollowUser(self, widget, name, *args):
        self.showBusy(1)
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.builder.get_object("hbox2").show_all()
        #strip out the @ which isn't really part of the username

        name = name.replace("@", "")
        print "unfollow : " + name

        try:
           # if we have an access token, use oauth
#            if (self.access_token != ""):
 #               print "using oauth to unfollow"
  #              twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.access_token)
   #             if (self.user == ""):
    ##                self.user = twitter.GetUserInfo()
#
 #               data = twitter.DestroyFriendship(name)
  #              note = osso.SystemNote(self.osso_c)
   #             result = note.system_note_infoprint("Unfollowed " + name)

    #        else:
                post = urllib.urlencode({ 'screen_name' : name })
                #build the request with the url and our post data
                req = urllib2.Request('http://twitter.com/friendships/destroy.json', post)

                auth_handler = urllib2.HTTPBasicAuthHandler()
                #realm here is important. or at least it seemed to be
                #this info is on the login box if you go to the url in a browser
                auth_handler.add_password(realm='Twitter API',
                                  uri='http://twitter.com/friendships/destroy.json',
                                  user=self.username,
                                  passwd=self.password)
                #we create an 'opener' object with our auth_handler
                opener = urllib2.build_opener(auth_handler)
                # ...and install it globally so it can be used with urlopen.
                urllib2.install_opener(opener)
                #switch on whether this is an refresh or a first download

                json = urllib2.urlopen(req)
                #JSON is awesome stuff. we get given a long string of json encoded information
                #which contains all the tweets, with lots of info, we decode to a json object
                data = simplejson.loads(json.read())
                note = osso.SystemNote(self.osso_c)
                result = note.system_note_infoprint("Unfollowed " + name)
        except IOError, e:
            print "error"
            msg = 'Error unfollowing ' + name + ' '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = osso.SystemNote(self.osso_c)
            note.system_note_dialog(msg)
            print msg
        self.showBusy(-1)

    def replyTo(self, widget, *args):
        self.hideActionButtons()
        self.builder.get_object("hbox2").show_all()
    	if (self.treeview.get_model() == self.searchliststore):
    		#we want to store the search terms, replace them with tweet text
    		#so we can restore the search terms afterwards
    		self.search_terms = self.tweetText.get_text()
        self.tweetText.set_text(self.reply_to_name + " ")
    	self.tweetText.grab_focus()
    	self.tweetText.set_position(len(self.reply_to_name) + 1);

    def replyAll(self, widget, *args):
        self.hideActionButtons()
        self.builder.get_object("hbox2").show_all()
        if (self.treeview.get_model() == self.searchliststore):
            #we want to store the search terms, replace them with tweet text
            #so we can restore the search terms afterwards
            self.search_terms = self.tweetText.get_text()
        self.tweetText.set_text(self.reply_all + " ")
        self.tweetText.grab_focus()
        self.tweetText.set_position(len(self.reply_all) + 1);


    def directMessage(self, widget, *args):
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.builder.get_object("hbox2").show_all()
        name = self.reply_to_name.replace("@", "")
        if (self.treeview.get_model() == self.searchliststore):
            #we want to store the search terms, replace them with tweet text
            #so we can restore the search terms afterwards
            self.search_terms = self.tweetText.get_text()

        self.tweetText.set_text("d " + name + " ")
        self.tweetText.grab_focus()
        self.tweetText.set_position(len(self.reply_to_name) + 3);

    def reTweet(self, widget, *args):
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.builder.get_object("hbox2").show_all()
        self.tweetText.set_text("RT: " + self.retweettext)
        self.tweetText.grab_focus()



    def openBrowser(self, widget, url, *args):
        #open a url in a browser
        if (self.maemo_ver == 5):
	    print "opening browser - maemo5 style"
            #webbrowser.open_new(url)
            self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (url,))
        else:
	    print "opening browser - maemo4 style"
            webbrowser.open(url, context=self.osso_c)
        print "We tried to open a browser"

    def checkVersion(self):
        #we want to see if we're on fremantle or not as the default colour
        #scheme has changed
        #look for /etc/maemo_version
        print "checking for /proc/component_version"
        try:
            f = open('/proc/component_version', 'r')
            read_data = f.read()
            if (re.search("RX-51", read_data)):
                print "found n900"
                self.textcolour = "#FFFFFF"
                self.tweetcolour = "#FFFFFF"
                self.namecolour = "#FE00B8"
                self.defaultwidth = 790
                self.maemo_ver = 5
            else:
		self.textcolour = "#000000"
                print "found" + read_data
                self.maemo_ver = 4
        except IOError:
            #couldn't find the file 
            print "Assuming pre-maemo5"
            self.maemo_ver = 4

    def readConfig(self):
        try:
            config = ConfigParser.ConfigParser()
            config.readfp(open('/home/user/.witter'))
            try:
                user = config.get("credentials", "username");
                self.username = base64.b64decode(user)
                password = config.get("credentials", "password");
                self.password = base64.b64decode(password)
                #self.access_token = config.get("credentials", "access_token")
                topCol = config.get("UI", "bg_top")
                print topCol
                self.bg_top_color = gtk.gdk.color_parse(topCol)
                bottomCol = config.get("UI", "bg_bottom")
                print bottomCol
                self.bg_bottom_color = gtk.gdk.color_parse(bottomCol)
                self.font_size = int(config.get("UI", "font_size"))
            except ConfigParser.NoSectionError:
                print "no text colour setting"
            except ConfigParser.NoOptionError:
                print "missing option in config"
            try:
                serviceType = config.get("Service", "type")
                if (serviceType == "twitter"):
                    self.serviceUrlRoot = self.twitterUrlRoot
                    self.searchServiceUrlRoot = self.twitterSearchUrlRoot
                    self.serviceName = self.twitterName
                elif ("identi.ca" == serviceType):
                    self.serviceUrlRoot = self.identicaUrlRoot
                    self.searchServiceUrlRoot = self.identicaSearchUrlRoot
                    self.serviceName = self.identicaName
            except ConfigParser.NoSectionError:
                print "no service setting"
    	    try:
    		    self.timelineRefreshInterval = int(config.get("refresh_interval", "timeline"))
    		    self.mentionsRefreshInterval = int(config.get("refresh_interval", "mentions"))
    		    self.DMsRefreshInterval = int(config.get("refresh_interval", "dm"))
    		    self.publicRefreshInterval = int(config.get("refresh_interval", "public"))
    		    self.searchRefreshInterval = int(config.get("refresh_interval", "search"))
    	    except ConfigParser.NoSectionError:
    		    print "No refresh_interval section"
    	    except ConfigParser.NoOptionError:
    		    print "unknown option"
    	    try:
    		    self.search_terms = config.get("search", "search_terms")
    	    except ConfigParser.NoSectionError:
    		    print "No refresh_interval section"
            try:
                f = open('/home/user/.witteroauth')
                self.access_token = pickle.load(f)
            except IOError:
                print "failed to read oauth access token"
            except EOFError:
                print "end of file, probably no token"

        except IOError:
            #couldn't find the file set uid so we can prompt
	        #for creds
            self.username = "UserName"
            self.password = ""
            print "No config file, prompt for uid / pwd"

    def switchService(self, *args):
        if (self.serviceUrlRoot == self.twitterUrlRoot):
            self.serviceUrlRoot = self.identicaUrlRoot
            self.serviceName = self.identicaName
            self.searchServiceUrlRoot = self.identicaSearchUrlRoot
            self.window.set_title("Witter - now using identi.ca")
        else:
            self.serviceUrlRoot = self.twitterUrlRoot
            self.serviceName = self.twitterName
            self.searchServiceUrlRoot = self.twitterSearchUrlRoot
            self.window.set_title("Witter - now using twitter")

    def writeConfig(self):
        try:
            f = open('/home/user/.witter', 'w')
            f.write("[credentials]\n")
            f.write("username = " + base64.b64encode(self.username) + "\n")
            f.write("password = " + base64.b64encode(self.password) + "\n")
            f.write("[UI]\n")
            f.write("textcolour = " + self.textcolour + "\n")
            f.write("bg_top = " + self.bg_top_color.to_string() + "\n")
            f.write("bg_bottom = " + self.bg_bottom_color.to_string() + "\n")
            f.write("font_size = " + str(self.font_size) + "\n")
            f.write("[refresh_interval]\n")
            f.write("timeline = " + str(self.timelineRefreshInterval) + "\n")
            f.write("mentions = " + str(self.mentionsRefreshInterval) + "\n")
            f.write("dm = " + str(self.DMsRefreshInterval) + "\n")
            f.write("public = " + str(self.publicRefreshInterval) + "\n")
            f.write("search = " + str(self.searchRefreshInterval) + "\n")
            f.write("[search]\n")
            f.write("search_terms = " + self.search_terms + "\n")
    	except IOError, e:
    		print "failed to write config file"
        try:
            f2 = open('/home/user/.witteroauth', 'w')
            pickle.dump(self.access_token, f2)
        except IOError, e:
            print "failed to write access token"

    def configOauth(self, *args):
         try:
             twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET)
             self.request_token = twitter.getRequestToken()
             authorization_url = twitter.getAuthorizationURL(self.request_token)
             print authorization_url
             self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (authorization_url,))
             note = hildon.Note("confirmation", self.window, "authorise with twitter...")
             note.set_button_texts("ok", "cancel")
             note.connect("response", self.gtk_widget_hide)
             retcode = gtk.Dialog.run(note)

             if retcode == gtk.RESPONSE_OK:
                print "User pressed 'OK' button'"

             else:
                print "User pressed 'Cancel' button"
                return


             dialog = self.builder.get_object("OauthDialog")
             dialog.set_title("Twitter Credentials")
             dialog.connect("response", self.gtk_widget_hide)
             dialog.show_all()


         except IOError, e:
            print "error"
            msg = 'Error retrieving tweets '
            if hasattr(e, 'reason'):
                msg = msg + str(e.reason)

            if hasattr(e, 'code'):
                if (e.code == 401):
                    reason = "Not authorised: check uid/pwd"
                elif(e.code == 503):
                    reason = "Service unavailable"
                else:
                    reason = ""
                msg = msg + 'Server returned ' + str(e.code) + " : " + reason

            note = osso.SystemNote(self.osso_c)
            note.system_note_dialog(msg)



    def getAccessToken(self, *args):
         pin = self.builder.get_object("PIN").get_text()
         twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, self.request_token)
         access_token = twitter.getAccessToken(pin)
         print access_token
         self.access_token = access_token
         self.builder.get_object("OauthDialog").hide_all()
         #need to save/store the access token
         #twitter = oauthtwitter.OAuthApi(self.CONSUMER_KEY, self.CONSUMER_SECRET, access_token)
         #user = twitter.GetUserInfo()
         #print user
         #quick check things have worked

         #users = twitter.GetFriends()
         #print [u.name for u in users]

    def promptForCredentials(self, *args):
        #dialog = self.wTree.get_widget("CredentialsDialog")
        dialog = self.builder.get_object("CredentialsDialog")
        dialog.set_title("Twitter Credentials")
        dialog.connect("response", self.gtk_widget_hide)
        dialog.show_all()

    def  store_creds(self, widget, *args):
        print "store_creds called"

        #store the values set
        self.username = self.builder.get_object("UserName").get_text()
        self.password = self.builder.get_object("Password").get_text()
        self.writeConfig()

    def  gtk_widget_hide(self, widget, *args):
        widget.hide_all()
        #widget.destroy()

    def reparent_loc(self, widget, newParent):
        widget.reparent(newParent)

    def switchViewTo(self, widget, type):
	if (self.treeview.get_model() == self.searchliststore):
	    #switching out of search view, save search terms and reset text box
	    self.search_terms = self.tweetText.get_text()
	    self.tweetText.set_text("")
        if (re.search("timeline", type)):
            self.treeview.set_model(self.liststore)
            self.window.set_title(self.serviceName + " - timeline")
            #ensure selected view has active button image
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            #set all othe rbuttons into deactivated mode
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("direct", type)):
            self.treeview.set_model(self.dmliststore)
            self.window.set_title(self.serviceName + " - direct messages")
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            #set all othe rbuttons into deactivated mode
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("mentions", type)):
            self.treeview.set_model(self.mentionliststore)
            self.window.set_title(self.serviceName + " - mentions")
            #ensure selected view has active button image
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention.png")
            menImage.show()
            mentionsButton.set_image(menImage)

            #set all othe rbuttons into deactivated mode
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("public", type)):
            self.treeview.set_model(self.publicliststore)
            self.window.set_title(self.serviceName + " - public")
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            #set all othe rbuttons into deactivated mode
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("trends", type)):
            self.treeview.set_model(self.trendliststore)
            self.window.set_title(self.serviceName + " - trends")
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            #set all othe rbuttons into deactivated mode
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("friends", type)):
            self.treeview.set_model(self.friendsliststore)
            self.window.set_title(self.serviceName + " - friends")
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            #set all othe rbuttons into deactivated mode
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("search", type)):
            self.tweetText.set_text(self.search_terms)
            self.treeview.set_model(self.searchliststore)
            self.window.set_title(self.serviceName + " - search")
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search.png")
            serImage.show()
            searchButton.set_image(serImage)
            #set all othe rbuttons into deactivated mode
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory_off.png")
            userImage.show()
            userButton.set_image(userImage)
        elif (re.search("user", type)):
            self.treeview.set_model(self.userhistoryliststore)
            self.window.set_title(self.serviceName + " - User History")
            userButton = self.builder.get_object("userhistory")
            userImage = gtk.Image()
            userImage.set_from_file("/opt/witter/icons/userHistory.png")
            userImage.show()
            userButton.set_image(userImage)
            #set all othe rbuttons into deactivated mode
            searchButton = self.builder.get_object("search")
            serImage = gtk.Image()
            serImage.set_from_file("/opt/witter/icons/search_off.png")
            serImage.show()
            searchButton.set_image(serImage)
            timelineButton = self.builder.get_object("timeline")
            tlImage = gtk.Image()
            tlImage.set_from_file("/opt/witter/icons/timeline_off.png")
            tlImage.show()
            timelineButton.set_image(tlImage)
            mentionsButton = self.builder.get_object("mentions")
            menImage = gtk.Image()
            menImage.set_from_file("/opt/witter/icons/mention_off.png")
            menImage.show()
            mentionsButton.set_image(menImage)
            dmsButton = self.builder.get_object("direct messages")
            dmImage = gtk.Image()
            dmImage.set_from_file("/opt/witter/icons/dm_off.png")
            dmImage.show()
            dmsButton.set_image(dmImage)
            friendsButton = self.builder.get_object("friends")
            friendImage = gtk.Image()
            friendImage.set_from_file("/opt/witter/icons/friends_off.png")
            friendImage.show()
            friendsButton.set_image(friendImage)
            publicButton = self.builder.get_object("public")
            pubImage = gtk.Image()
            pubImage.set_from_file("/opt/witter/icons/public_off.png")
            pubImage.show()
            publicButton.set_image(pubImage)
            trendsButton = self.builder.get_object("trends")
            trendImage = gtk.Image()
            trendImage.set_from_file("/opt/witter/icons/trends_off.png")
            trendImage.show()
            trendsButton.set_image(trendImage)

	self.builder.get_object("hbox1").show_all()
	self.builder.get_object("hbox2").show_all()

    def switchView(self, widget):
        #switches the active liststore to display what the user wants
        print widget
        type = widget.get_label()
        print type
        self.switchViewTo(widget, type)

    def showUsersTimeline(self, widget):
        print "does nothing at the moment"

    def selectImage(self, widget):
        #bring up a file choser to let people select images
        #imageChose = self.wTree.get_widget("filechooserdialog1")
        imageChose = self.builder.get_object("filechooserdialog1")

        filter = gtk.FileFilter()
        filter.set_name("*.jpg")
        filter.add_pattern("*.jpg")
        imageChose.remove_filter(filter)
        imageChose.add_filter(filter)
        imageChose.set_filter(filter)
        imageChose.show()

    def alreadyRetrieved(self, liststore, *args):
        #method to check if we have already stored this tweet

        #iterate over values and
        item = liststore.get_iter_first ()

        while True:

            value = model.get_value(item, 0)

            item = model.iter_next(item)

            if item is None:

                break




    def twitPic(self, widget, *args):
        print "twitPic"
        #dialog = self.wTree.get_widget("filechooserdialog1")
        dialog = self.builder.get_object("filechooserdialog1")
        file = dialog.get_filename()

        try:
            fin = open(file, "rb")
            jpgImage = fin.read()
            #tweet = self.wTree.get_widget("TweetText").get_text()
            tweet = self.builder.get_object("TweetText").get_text()
            #see if we have just an empty string (eg eroneous button press)
            if (tweet == ""):
                print "No tweet to go with image"
                return

            # upload binary file with pycurl by http post
            c = pycurl.Curl()
            c.setopt(c.POST, 1)
            c.setopt(c.URL, "http: // twitpic.com / api / uploadAndPost")
            c.setopt(c.HTTPPOST, [("media", (c.FORM_FILE, file)),
                                  ("username", self.username),
                                  ("password", self.password),
                                  ("message", tweet)])
            #c.setopt(c.VERBOSE, 1)
            c.perform()
            c.close()
            print "posted TwitPic"


            #message sent, I'm assuming a failure to send would not continue
            #in this method? so it's safe to remove the tweet line
            # what I don't want is to lose the tweet I typed if we didn't
            # sucessfully send it to twitter. that would be annoying (I'm looking
            # at you Mauku)
            #self.wTree.get_widget("TweetText").set_text("")
            self.builder.get_object("TweetText").set_text("")
        except IOError:
            print "couldn't read file"
        print file

    def CharsRemaining(self, widget):
	     self.builder.get_object("hbox1").show_all()
	     tweet = self.builder.get_object("TweetText").get_text()
	     counter = self.builder.get_object("Counter")
	     counter.set_text((str(140 - len(tweet))))


    def about(self, widget, *args):
		dlg = gtk.AboutDialog()
		dlg.set_version("0.2.2")
		dlg.set_name("Witter")
		#"Marcus Wikstrm (logo)"
		dlg.set_authors(["Daniel Would (programmer)", u"Marcus Wikström (logo)"])
		dlg.set_website("Homepage : http://danielwould.wordpress.com/witter/\nBugtracker : http://garage.maemo.org/projects/witter")
		def close(w, res):
			if res == gtk.RESPONSE_CANCEL:
				w.hide()
		dlg.connect("response", close)
		dlg.show()

    def configProperties(self, widget, *args):
	    #dialog = self.wTree.get_widget("CredentialsDialog")
	    if (self.configDialog == None):
		self.configDialog = self.builder.get_object("setRefreshDialog")
		self.configDialog.set_title("Witter Properties")
		self.configDialog.connect("response", self.dontsetProps)

		self.timelineNumberEd = self.builder.get_object("timeline-NumberEditor")
		self.mentionsNumberEd = self.builder.get_object("mentions-NumberEditor")
		self.DMNumberEd = self.builder.get_object("DM-NumberEditor")
		self.publicNumberEd = self.builder.get_object("public-NumberEditor")
		self.searchNumberEd = self.builder.get_object("search-NumberEditor")

	    self.timelineNumberEd.set_value(self.timelineRefreshInterval)
	    self.mentionsNumberEd.set_value(self.mentionsRefreshInterval)
	    self.DMNumberEd.set_value(self.DMsRefreshInterval)
	    self.publicNumberEd.set_value(self.publicRefreshInterval)
	    self.searchNumberEd.set_value(self.searchRefreshInterval)
            self.configDialog.show_all()

    def dontsetProps(self, widget, *args):
	    print "cancelledOperation"
	    self.configDialog.hide_all()

    def setProps(self, widget, *args):
	    #set all the refresh inteval values
	    self.timelineRefreshInterval = self.timelineNumberEd.get_value()
	    self.mentionsRefreshInterval = self.mentionsNumberEd.get_value()
	    self.DMsRefreshInterval = self.DMNumberEd.get_value()
	    self.publicRefreshInterval = self.publicNumberEd.get_value()
	    self.searchRefreshInterval = self.searchNumberEd.get_value()
	    #stop and start the threads to pick up the new values
	    self.end_refresh_threads()
	    self.start_refresh_threads()
	    self.configDialog.hide_all()

    def end_refresh_threads(self):
	    #end all the refresh threads
	    if (self.refreshtask != None):
		self.refreshtask.stop()
	    if (self.dmrefresh != None):
		self.dmrefresh.stop()
	    if (self.mentionrefresh != None):
		self.mentionrefresh.stop()
	    if (self.publicrefresh != None):
		self.publicrefresh.stop()
	    if (self.searchrefresh != None):
		self.searchrefresh.stop()


    def start_refresh_threads(self):
	    #we store the refresh interval in minutes, but pass it through as a value in seconds
	    #this method launches a thread for each of the views we want to have auto-refreshed
	    if (self.timelineRefreshInterval != 0):
		    self.refreshtask = witter.RefreshTask(self.getTweetsWrapper, 0 , self.showBusy)
		    self.refreshtask.start(self.timelineRefreshInterval * 60, self)
	    if (self.DMsRefreshInterval != 0):
		    self.dmrefresh = witter.RefreshTask(self.getDMsWrapper, 0, self.showBusy)
		    self.dmrefresh.start(self.DMsRefreshInterval * 60, self)
	    if (self.mentionsRefreshInterval != 0):
		    self.mentionrefresh = witter.RefreshTask(self.getMentionsWrapper, 0, self.showBusy)
		    self.mentionrefresh.start(self.mentionsRefreshInterval * 60, self)
	    if (self.publicRefreshInterval != 0) :
		    self.publicrefresh = witter.RefreshTask(self.getPublicWrapper, 0, self.showBusy)
		    self.publicrefresh.start(self.publicRefreshInterval * 60, self)
	    if (self.searchRefreshInterval != 0) :
		    self.searchrefresh = witter.RefreshTask(self.getSearchWrapper, 0, self.showBusy)
		    self.searchrefresh.start(self.searchRefreshInterval * 60, self)
	    print "end refresh setup"

    def getTweetsWrapper(self, get_older=False, more=0, autoval=None):

	    self.getTweets(auto=autoval, older=get_older, get_count=more)

	    return "done"

    def getDMsWrapper(self, get_older=False, autoval=None, more=0, *args):
	    #we want to randomise the streams so they don't clash
	    #time.sleep(random.randint(1, 30))
	    #if (self.gettingTweets == False):
	    self.getDMs(auto=autoval, older=get_older, get_count=more)

	    return "done"

    def getMentionsWrapper(self, get_older=False, autoval=None, more=0, *args):
	    #we want to randomise the streams so they don't clash
	    #time.sleep(random.randint(1, 30))
	    #if (self.gettingTweets == False):
	    self.getMentions(auto=autoval, older=get_older, get_count=more)

	    return "done"

    def getPublicWrapper(self, get_older=False, autoval=None, more=0, *args):
	    #we want to randomise the streams so they don't clash
	    #time.sleep(random.randint(1, 30))
	    #if (self.gettingTweets == False):
	    self.getPublic(auto=autoval, older=get_older, get_count=more)
	    return "done"

    def getSearchWrapper(self, get_older=False, autoval=None, more=0, *args):
	    self.getSearch(auto=autoval, older=get_older, get_count=more)

	    return "done"

    def getFriendsWrapper(self, get_older=False, autoval=None, more=0, *args):

        self.getFriends()

        return "done"
    def getUserHistWrapper(self, get_older=False, autoval=None, more=0, *args):
        user = self.builder.get_object("TweetText").get_text()
        self.window.set_title(self.serviceName + " " + user + " - History")
        self.getUserHistory(friend=user, auto=autoval)
        self.builder.get_object("TweetText").set_text("")
        return "done"



    def getTrendsWrapper(self, get_older=False, autoval=None, more=0, *args):

        self.getTrends()

        return "done"

    def showBusy(self, increment, *args):
        #increment might be +1 or -1 to take the counter up or down
        self.busyCounter = self.busyCounter + increment
        print "running tasks: " + str(self.busyCounter)
        if (self.busyCounter > 0):
            #at least one thing running
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
        else:
            #no more tasks busy
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
            #in case we missed it somewhere, no longer getting Tweets
            self.gettingTweets = False

        return


    def gesture(self, widget, direction, startx, starty):
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        #get the selected tweet for the view we're in and scroll to what
        #we had selecte last time we were in the view we're switching to
        widget.scroll_to(0, 0)
        print "scroll to last known position"
        if (direction == 3):
            if (self.treeview.get_model() == self.liststore):
                self.switchViewTo(self.treeview, "user")
            elif (self.treeview.get_model() == self.dmliststore):
                self.switchViewTo(self.treeview, "mentions")
            elif (self.treeview.get_model() == self.mentionliststore):
                self.switchViewTo(self.treeview, "timeline")
            elif (self.treeview.get_model() == self.publicliststore):
                self.switchViewTo(self.treeview, "trends")
            elif (self.treeview.get_model() == self.trendliststore):
                self.switchViewTo(self.treeview, "friends")
            elif (self.treeview.get_model() == self.friendsliststore):
                self.switchViewTo(self.treeview, "search")
            elif (self.treeview.get_model() == self.searchliststore):
                self.switchViewTo(self.treeview, "direct")
            elif (self.treeview.get_model() == self.userhistoryliststore):
                self.switchViewTo(self.treeview, "public")


        if (direction == 2):
            if (self.treeview.get_model() == self.liststore):
                self.switchViewTo(self.treeview, "mentions")
            elif (self.treeview.get_model() == self.dmliststore):
    		    self.switchViewTo(self.treeview, "search")
            elif (self.treeview.get_model() == self.mentionliststore):
    		    self.switchViewTo(self.treeview, "direct")
            elif (self.treeview.get_model() == self.publicliststore):
    		    self.switchViewTo(self.treeview, "user")
            elif (self.treeview.get_model() == self.trendliststore):
    		    self.switchViewTo(self.treeview, "public")
            elif (self.treeview.get_model() == self.friendsliststore):
    		    self.switchViewTo(self.treeview, "trends")
            elif (self.treeview.get_model() == self.searchliststore):
    		    self.switchViewTo(self.treeview, "friends")
            elif (self.treeview.get_model() == self.userhistoryliststore):
                self.switchViewTo(self.treeview, "timeline")

    def scrolling (self, widget, direction, startx, starty):
        #decided to try keeping top row of buttons at all times
        self.builder.get_object("hbox1").hide_all()
        #self.builder.get_object("hbox2").hide_all()
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()
        self.window.fullscreen ()
        fullscrButton = self.builder.get_object("fullscr")
        image = gtk.Image()
        image.set_from_file("/opt/witter/icons/unfullscr.png")
        image.show()
        fullscrButton.set_image(image)


    def buildActionButtons(self):
        #method called when you click a tweet to build the buttons to show
        #at the bottom of the window
        replyButton = hildon.Button("Reply")

    def showMoreButtons(self, *args):
        if (self.showingMore == True):
            self.builder.get_object("hbuttonbox-more").hide_all()
            self.showingMore = False
            extraButton = self.builder.get_object("extra-controls")
            image2 = gtk.Image()
            image2.set_from_file("/opt/witter/icons/plus.png")
            image2.show()
            extraButton.set_image(image2)
        else:
            self.builder.get_object("hbuttonbox-more").show_all()
            self.showingMore = True
            extraButton = self.builder.get_object("extra-controls")
            image2 = gtk.Image()
            image2.set_from_file("/opt/witter/icons/minus.png")
            image2.show()
            extraButton.set_image(image2)


    def getMore(self, more, *args):
        #call the get method for whichever liststore we're viewing
        if (self.treeview.get_model() == self.liststore):
            #self.getTweets()
            refreshtask = witter.RefreshTask(self.getTweetsWrapper, more, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.dmliststore):
            refreshtask = witter.RefreshTask(self.getDMsWrapper, more, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.mentionliststore):

            refreshtask = witter.RefreshTask(self.getMentionsWrapper, more, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.publicliststore):
            refreshtask = witter.RefreshTask(self.getPublicWrapper, more, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.trendliststore):
            refreshtask = witter.RefreshTask(self.getTrendsWrapper, more, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.friendsliststore):
            refreshtask = witter.RefreshTask(self.getFriendsWrapper, more, self.showBusy)
            refreshtask.refresh()
        elif (self.treeview.get_model() == self.searchliststore):
            refreshtask = witter.RefreshTask(self.getSearchWrapper, more, self.showBusy)
            refreshtask.refresh()


    def get20More(self, *args):
        self.getMore(20)

    def get50More(self, *args):
        self.getMore(50)

    def get100More(self, *args):
        self.getMore(100)

    def get200More(self, *args):
        self.getMore(200)

    def showHist(self, widget, user):
        self.showBusy(1)
        self.hideActionButtons()
        self.switchViewTo(widget, "user")
        self.builder.get_object("TweetText").set_text(user)

        #need to strip the @ symbol from the user before we request their history
        refreshtask = witter.RefreshTask(self.getUserHistWrapper, 0, self.showBusy)
        refreshtask.refresh()

        self.showBusy(-1)

    def hideActionButtons(self):
        self.builder.get_object("hbuttonbox-act1").hide_all()
        self.builder.get_object("hbuttonbox-act2").hide_all()
        self.builder.get_object("hbuttonbox-act3").hide_all()
        self.builder.get_object("hbuttonbox-act4").hide_all()

    def tweetAt(self, *args):
        self.hideActionButtons()
        self.builder.get_object("TweetText").set_text(self.reply_to_name)


    def tweetAtUser(self, widget, user, *args):
        self.hideActionButtons()
        self.builder.get_object("TweetText").set_text(user)

    def top_colour_changed(self, widget):
        color = widget.get_color()
        print "Current color is: (red=%s, green=%s, blue=%s, pixel=%s)" % (color.red, color.green, color.blue, color.pixel)
        self.cell.set_property('backgroundt_r', color.red)
        self.cell.set_property('backgroundt_g', color.green)
        self.cell.set_property('backgroundt_b', color.blue)
        self.cell.set_property('backgroundt_p', color.pixel)
        self.bg_top_color = color
    def bottom_colour_changed(self, widget):
        color = widget.get_color()
        print "Current color is: (red=%s, green=%s, blue=%s, pixel=%s)" % (color.red, color.green, color.blue, color.pixel)
        self.cell.set_property('backgroundb_r', color.red)
        self.cell.set_property('backgroundb_g', color.green)
        self.cell.set_property('backgroundb_b', color.blue)
        self.cell.set_property('backgroundb_p', color.pixel)
        self.bg_bottom_color = color

if __name__ == "__main__":
    #this is just what initialises the app and calls run
    app = Witter()

    app.run()


