import unittest
from unit.pie import *

class PieTest(unittest.TestCase):
    
    def test_never(self):
        mock = Mock()
        mock.replay()
        verify(mock, never()).fakeMethod()
    
    
    def test_neverFail(self):
        mock = Mock()
        mock.replay()
        mock.fakeMethod()
        try:
            verify(mock, never()).fakeMethod()
            raise Exception("The fake method was called - the verify statement should fail")
        except:
            pass
        
    
    def test_onceSuccess(self):
        mock = Mock()
        given(mock).method().willReturn(True)
        mock.replay()
        result = mock.method()
        assert result is True
        verify(mock, once()).method()
    
    
    def test_onceFail(self):
        mock = Mock()
        given(mock).method().willReturn(True)
        mock.replay()
        try:
            verify(mock, once()).method()
            raise Exception("The method was never called - the verify step should fail")
        except:
            pass
        
    
    def test_implicitOnce_undefinedReturn_WithArguments(self):
        mock = Mock()
        mock.replay()
        url = 'http://sample.argument'
        mock.openUrl(url)
        verify(mock).openUrl(url)
    

if __name__ == '__main__':
    unittest.main()
