
class NetworkSetting(object):
    '''
    The settings specified for a network
    '''

    def __init__(self, settings=None):
        self._attributes = {}
        if (settings):
            for key in settings:
                self._attributes[key] = settings[key]
        if not self._attributes.has_key('launch'):
            self.setLaunchingOfBrowserEnabled(False)
    
    def getNetworkName(self):
        return self._attributes['name']
    
    
    def setNetworkName(self, name):
        self._attributes['name'] = name
        
        
    def getLaunchingOfBrowserEnabled(self):
        return self._attributes['launch'] is True
        
        
    def setLaunchingOfBrowserEnabled(self, value):
        self._attributes['launch'] = value
        
        
    def getNameOfBrowserToLaunch(self):
        if self._attributes.has_key('browser'):
            return self._attributes['browser']
        return "default"
    
    
    def setNameOfBrowserToLaunch(self, browser):
        self._attributes['browser'] = browser
    
    
    def getBrowserOptions(self):
        if self._attributes.has_key('options'):
            return self._attributes['options']
        return {}
    
    
    def setBrowserOptions(self, options):
        self._attributes['options'] = options
    