#ifndef AUTHPARAMS_H
#define AUTHPARAMS_H

#include <QString>
#include <QStringList>
#include <QList>

class AuthParams
{
    public:
        AuthParams();
        virtual ~AuthParams();

        void parseParams(const QStringList &params);

        const QString &getTitle();
        const QString &getClientID();
        const QList<QRegExp *> &getRegExps();
        const QList<QString *> &getReturnParams();
        const QList<QString *> &getContextParams();

        QList<QVariant> prepareSignalParams(const QString & authResult, bool withRetParams);
        QList<QVariant> prepareCaptchaSignalParams(const QString & captchaResult, bool withRetParams);
        QList<QVariant> prepareLogInSignalParams(const QStringList & loginResult);

        void clear();

    private:
        QList<QRegExp *> getParamsRegExp(const QList<QString*> &params);
        QString getParamsAuthTitle(const QList<QString*> &params);
        QString getParamsClientID(const QList<QString*> &params);

        void parseParametersByPostfixes(const QStringList &params);
        void removePostfix(QString *parameter, QString typePostfix);

        QList<QString *> params;
        QList<QString *> returnParams;
        QList<QString *> contextParams;

        QString title;
        QString clientID;
        QList<QRegExp *> regexpList;
};

#endif // AUTHPARAMS_H
