/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef SLOONO_HPP
#define SLOONO_HPP

// Local includes
#include "../providerinterface.hpp"

// Forward declarations
class SloonoPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class Sloono : public ProviderInterface
{
  Q_OBJECT
  Q_INTERFACES(ProviderInterface)

public:
  Sloono(QObject* parent = 0);
  ~Sloono();

  // ProviderInterface overrides
  void loadSettings(const QByteArray& data);
  QByteArray saveSettings() const;

  QList<MessageType> messageTypes() const;

  bool showAccountSettingsDialog(QWidget* parent);

  /// SendMessage returns a unique message id for this instance
  void sendMessage(const Message& message);

  void updateBalance();

private:
  SloonoPrivate* d;
  friend class SloonoPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // SLOONO_HPP
