/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "providerinterface.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

ProviderInterface::ProviderInterface(QObject* parent /* = 0 */)
: QObject(parent)
{
}

//////////////////////////////////////////////////////////////////////////

ProviderInterface::~ProviderInterface()
{
}

//////////////////////////////////////////////////////////////////////////

void ProviderInterface::updateBalance()
{
  emit balanceReply( QString() );
}

//////////////////////////////////////////////////////////////////////////

bool ProviderInterface::isLoggedIn() const
{
  return true;
}

//////////////////////////////////////////////////////////////////////////

CallbackType ProviderInterface::login()
{
  return Callback_Sync;
}

//////////////////////////////////////////////////////////////////////////

CallbackType ProviderInterface::logout()
{
  return Callback_Sync;
}

//////////////////////////////////////////////////////////////////////////

QList<MessageType> ProviderInterface::messageTypes() const
{
  return QList<MessageType>();
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
