#include "wpnew.h"
#include "ui_wpnew.h"
#include "wpmanager.h"
#include "ui_wpmanager.h"
#include "wallpaeper.h"
#include "ui_wallpaeper.h"

wallPaeper::wallPaeper(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::wallPaeper)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);

    ui->titleLbl->setStyleSheet("color: deepskyblue");
    ui->newBtn->setStyleSheet("text-align: left");
    ui->manBtn->setStyleSheet("text-align: left");

    setupWPMenuBar();

    connect(ui->newBtn, SIGNAL(clicked()),
            this, SLOT(newBtnClicked()));
    connect(ui->manBtn, SIGNAL(clicked()),
            this, SLOT(manBtnClicked()));

    // On startup, buttons are allowed to open windows (naturally)
    openNewWin = true;
    openManWin = true;
}





wallPaeper::~wallPaeper()
{
    delete ui;
}





void wallPaeper::newBtnClicked() {
    // Make sure a button doesn't open multiple windows
    if(openNewWin == true) {
        openNewWin = false;
        openManWin = false;

        newWin = new wpNew(this);
        newWin->setAttribute(Qt::WA_Maemo5StackedWindow);
        newWin->setAttribute(Qt::WA_DeleteOnClose);

        connect(newWin, SIGNAL(destroyed()),
                this, SLOT(openWinTrue()));

        newWin->show();
    }
}





void wallPaeper::manBtnClicked() {
    // Make sure a button doesn't open multiple windows
    if(openManWin == true) {
        openNewWin = false;
        openManWin = false;

        manWin = new wpManager(this);
        manWin->setAttribute(Qt::WA_Maemo5StackedWindow);
        manWin->setAttribute(Qt::WA_DeleteOnClose);

        connect(manWin, SIGNAL(destroyed()),
                this, SLOT(openWinTrue()));

        manWin->show();
    }
}





void wallPaeper::openWinTrue() {
    // Allow buttons to open windows again
    openNewWin = true;
    openManWin = true;
}





void wallPaeper::setupWPMenuBar() {
    // The main menu
    wpMenuActionAbout = new QAction(tr("About..."), this);

    wpMenu = menuBar()->addMenu("");
    wpMenu->addAction(wpMenuActionAbout);

    connect(wpMenuActionAbout, SIGNAL(triggered()),
            this, SLOT(createAbtDialog()));
}





void wallPaeper::createAbtDialog() {
    // Create a new About dialog
    abtDialog = new aboutDialog(this);

    abtDialog->ui->aboutText1->adjustSize();
    abtDialog->ui->aboutText2->adjustSize();

    connect(abtDialog->ui->aboutBtnBox, SIGNAL(accepted()),
            this->abtDialog, SLOT(close()));

    abtDialog->adjustSize();
    abtDialog->show();
}
