#ifndef VOLUMECONTROLDAEMON_H
#define VOLUMECONTROLDAEMON_H

#include <QObject>
#include <QDBusConnection>
#include <QDBusMessage>
#include <QFileSystemWatcher>

#define STATE_FILE "/sys/devices/platform/gpio-switch/headphone/state"

class VolumeControlDaemon : public QObject
{
    Q_OBJECT
public:
    explicit VolumeControlDaemon(QObject *parent = 0);
    ~VolumeControlDaemon();

    void Start();

private:
    void SetHeadphoneVolume(int vol);
    bool IsHeadphoneConnected();

    void AdjustVolume(int currentVolume=-1);

signals:
    void quit();

private slots:
    void Init();
    void VolumeChangedSlot(const QDBusMessage &);
    void MediaChangedSlot(int, QString);
    void StateChangedSlot(int);
    void IncomingCallSlot(const QDBusMessage &);
    void AudioCallConnectedSlot(const QDBusMessage &);
};

#endif // VOLUMECONTROLDAEMON_H
