#include <QCoreApplication>
#include <iostream>
#include "volumecontroldaemon.h"

#define QUOTE_(x) #x
#define QUOTE(x) QUOTE_(x)

bool m_Debug;
void SimpleLoggingHandler(QtMsgType type, const char *msg)
{
    if (!m_Debug)
        return;

    switch (type) {
        case QtDebugMsg:
            std::cout << "Debug: " << msg << std::endl;
            break;
        case QtCriticalMsg:
            std::cout  << "Critical: " << msg << std::endl;
            break;
        case QtWarningMsg:
            std::cout  << "Warning: " << msg << std::endl;
            break;
        case QtFatalMsg:
            std::cout  << "Fatal: " << msg << std::endl;
            abort();
    }
}

int main(int argc, char *argv[])
{
    m_Debug = false;
    if (argc > 1 && QString(argv[1]) == "-d")
        m_Debug = true;

    QCoreApplication a(argc, argv);
    a.setApplicationVersion(QUOTE(APP_VERSION));
    qInstallMsgHandler(SimpleLoggingHandler);

    VolumeControlDaemon* daemon = new VolumeControlDaemon();
    QObject::connect(daemon, SIGNAL(quit()), &a, SLOT(quit()));
    daemon->Start();

    return a.exec();
}
