//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "settingswindow.h"
#include "ui_settingswindow.h"
#include <QListView>
#include <QDir>
#include "commonstatic.h"

SettingsWindow::SettingsWindow(QWidget *parent, Settings* settings, VodafoneWidget* vodafone) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{    
    ui->setupUi(this);

    ui->scrollAreaWidgetContents->layout()->setSizeConstraint(QLayout::SetMinAndMaxSize);
    ui->frame_8->layout()->setSizeConstraint(QLayout::SetMinAndMaxSize);

    m_Vodafone = vodafone;
    ui->cmbUpdateOn->addItem("Wlan");
    ui->cmbUpdateOn->addItem("GPRS");
    ui->cmbUpdateOn->addItem("Qualsiasi conn.");

    m_Settings = settings;
    connect(ui->btnCancel, SIGNAL(clicked()), this, SLOT(CancelSlot()));
    connect(ui->btnSave, SIGNAL(clicked()), this, SLOT(SaveSlot()));

    ui->chkAnimation->setChecked(m_Settings->Animation);
    ui->txUsername->setText(m_Settings->Username);
    ui->txPassword->setText(m_Settings->Password);

    ui->chkLabels->setChecked(m_Settings->ShowLabels);
    ui->chkShowCredito->setChecked(m_Settings->ShowCredito);
    ui->chkShowPunti->setChecked(m_Settings->ShowPunti);
    ui->cmbUpdateOn->setCurrentIndex(m_Settings->UpdateOn);

    ui->cmbCounterStyle->addItem("Testuale", Counter::widgetTextOnly);
    ui->cmbCounterStyle->addItem("Minimal", Counter::widgetMinimal);
    ui->cmbCounterStyle->addItem("Medium", Counter::widgetMedium);
    ui->cmbCounterStyle->setCurrentIndex(ui->cmbCounterStyle->findData(m_Settings->CounterStyle));

    ui->cmbWidth->addItem("200", 200);
    ui->cmbWidth->addItem("250", 250);
    ui->cmbWidth->addItem("300", 300);
    ui->cmbWidth->addItem("350", 350);
    ui->cmbWidth->addItem("400", 400);
    ui->cmbWidth->setCurrentIndex((m_Settings->WidgetWidth - 200) / 50);

    int time = 0;
    for (int i=0; i<20; i++){
        ui->cmbAutoUpdate->addItem(CommonStatic::FormatHourMinutes(time), time);
        if (m_Settings->UpdateInterval == time)
            ui->cmbAutoUpdate->setCurrentIndex(i);
        time += 300;
    }

    ui->cmbStyleSheet->clear();
    ui->cmbStyleSheet->addItem("Default", "Default");
    ui->cmbStyleSheet->addItem("System", "System");
    foreach (QString s, GetStyleSheets()){
        QString name = s;
        name.remove(name.length() - 4, 4);
        ui->cmbStyleSheet->addItem(name, s);
    }
    int index = ui->cmbStyleSheet->findText(m_Settings->StyleSheetName);
    if (index < 0)
        index = 0;
    ui->cmbStyleSheet->setCurrentIndex(index);
    ui->cmbStyleSheet->setView(new QListView());    

    m_CountersLayout = new QVBoxLayout();
    m_CountersLayout->setSizeConstraint(QLayout::SetMinAndMaxSize);
    m_CountersLayout->setContentsMargins(0,0,0,0);
    m_CountersLayout->setSpacing(3);
    ui->frmCounters->setLayout(m_CountersLayout);

    CreateCountersCheckbox();

    ui->cmbSim->clear();
    if (m_Settings->AllSIM.count() > 0){
        int i = 0;
        foreach (QString sim, m_Settings->AllSIM){
            ui->cmbSim->addItem(sim, sim);
            if (m_Settings->SIM == sim)
                ui->cmbSim->setCurrentIndex(i);
            i++;
        }
    }else{
        if (!m_Settings->SIM.isEmpty()){
            ui->cmbSim->addItem(m_Settings->SIM, m_Settings->SIM);
            ui->cmbSim->setCurrentIndex(0);
        }
    }
    connect(ui->cmbStyleSheet, SIGNAL(activated(int)), SLOT(StyleSlot(int)));
    connect(ui->btnUpdateCounters, SIGNAL(clicked()), SLOT(UpdateDataSlot()));

    ui->txUsername->setFocus();
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::CancelSlot()
{
    close();
}

void SettingsWindow::SaveSlot()
{
    m_Settings->CounterStyle = (Counter::widgetSize)ui->cmbCounterStyle->itemData(ui->cmbCounterStyle->currentIndex()).toInt();
    m_Settings->Animation = ui->chkAnimation->isChecked();
    m_Settings->WidgetWidth = ui->cmbWidth->currentText().toInt();
    m_Settings->Username = ui->txUsername->text();
    m_Settings->Password = ui->txPassword->text();

    m_Settings->ShowLabels = ui->chkLabels->isChecked();
    m_Settings->ShowCredito = ui->chkShowCredito->isChecked();
    m_Settings->ShowPunti = ui->chkShowPunti->isChecked();

    m_Settings->StyleSheetName = ui->cmbStyleSheet->currentText();

    m_Settings->UpdateOn = (Settings::connections)ui->cmbUpdateOn->currentIndex();
    m_Settings->UpdateInterval = ui->cmbAutoUpdate->itemData(ui->cmbAutoUpdate->currentIndex()).toInt();

    m_Settings->SIM = ui->cmbSim->currentText();
    for (int i=0; i<m_Settings->ShowCounters.count(); i++){
        Counter* c = m_Settings->ShowCounters.at(i);
        delete c;
    }       
    m_Settings->ShowCounters.clear();

    QLayoutItem *child;
    while ((child = m_CountersLayout->takeAt(0)) != 0) {
        QCheckBox* ck = (QCheckBox*)child->widget();
        if (ck->isChecked()){
            QStringList ele = ck->objectName().split("|");
            Counter* c = new Counter();
            c->Description = ck->text();
            c->Class = ele.at(0);
            c->Type = ele.at(1);
            c->Code = ele.at(2);

            m_Settings->ShowCounters.append(c);
        }
    }

    m_Settings->Save();
    close();
    emit SettingsChanged();
}

QStringList SettingsWindow::GetStyleSheets()
{
    QDir myDir(CommonStatic::GetStylesheetFolder());
    QStringList ext = QStringList() << "*.css";
    return myDir.entryList(ext);
}

void SettingsWindow::StyleSlot(int index)
{
    if (index == 0)
        CommonStatic::SetDefaultStylesheet((QWidget*)parent());
    else if (index == 1)
        CommonStatic::SetSystemStylesheet((QWidget*)parent());
    else{
        QString filename = QString("%1/%2").arg(CommonStatic::GetStylesheetFolder())
                                           .arg(ui->cmbStyleSheet->itemData(ui->cmbStyleSheet->currentIndex()).toString());
        CommonStatic::SetStylesheet((QWidget*)parent(), filename);
    }
}

void SettingsWindow::CreateCountersCheckbox()
{
    QLayoutItem *child;
    while ((child = m_CountersLayout->takeAt(0)) != 0) {
        delete child->widget();
        delete child;
    }

    foreach (Counter* c, m_Settings->AllCounters){
        QCheckBox* check = new QCheckBox(ui->frmCounters);
        check->setObjectName(QString("%1|%2|%3").arg(c->Class).arg(c->Type).arg(c->Code));
        check->setText(c->Description);
        foreach (Counter* sc, m_Settings->ShowCounters){
            if (sc->Class == c->Class && sc->Code == c->Code && sc->Type == c->Type){
                check->setChecked(true);
                break;
            }
        }

        m_CountersLayout->addWidget(check);
    }
}

bool counterToAscending(const Counter* s1 , const Counter* s2)
{
    return s1->Type < s2->Type;
}

void SettingsWindow::UpdateDataSlot()
{
    if (ui->txUsername->text().isEmpty() || ui->txPassword->text().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Inserire utente e password."));
        return;
    }

    ui->btnUpdateCounters->setEnabled(false);
    ui->frmCounters->setEnabled(false);

    bool logged = true;
    m_Vodafone->SetCredentials(ui->txUsername->text(), ui->txPassword->text());
    if (!m_Vodafone->IsLoggedIn() && !m_Vodafone->Login()){
        CommonStatic::ErrorMessage(this, tr("Login fallito."));
        logged = false;
    }

    if (logged){
        ui->cmbSim->clear();
        m_Settings->AllSIM.clear();
        int i=0;
        foreach (QString sim, m_Vodafone->GetSims()) {            
            m_Settings->AllSIM.append(sim);
            ui->cmbSim->addItem(sim, sim);
            if (sim == m_Settings->SIM)
                ui->cmbSim->setCurrentIndex(i);
            i++;
        }

        QList<Counter*>* list = m_Vodafone->GetListaContatori(true);
        qSort(list->begin() , list->end(), counterToAscending );

        for (int i=0; i<m_Settings->AllCounters.count(); i++){
            Counter* c = m_Settings->AllCounters.at(i);
            delete c;
        }
        m_Settings->AllCounters.clear();

        m_Settings->AllCounters = *list;
        CreateCountersCheckbox();
    }

    ui->frmCounters->setEnabled(true);
    ui->btnUpdateCounters->setEnabled(true);
    raise();
    activateWindow();
}
