//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "desktopwidget.h"
#include <QtGui>
#include <QDir>
#include <iostream>
#include "widgetmanager.h"
#include "qtsingleapplication/qtsingleapplication.h"
#include "settings.h"
#include "commonstatic.h"

#define QUOTE_(x) #x
#define QUOTE(x) QUOTE_(x)

void SimpleLoggingHandler(QtMsgType type, const char *msg)
{
    if (!WidgetManager::Debug)
        return;

    switch (type) {
        case QtDebugMsg:
            std::cout << "Debug: " << msg << std::endl;
            break;
        case QtCriticalMsg:
            std::cout  << "Critical: " << msg << std::endl;
            break;
        case QtWarningMsg:
            std::cout  << "Warning: " << msg << std::endl;
            break;
        case QtFatalMsg:
            std::cout  << "Fatal: " << msg << std::endl;
            abort();
    }
}

int main(int argc, char **argv)
{
    WidgetManager::Debug = false;
    if (argc > 1 && QString(argv[1]) == "-d")
        WidgetManager::Debug = true;

    QtSingleApplication app(argc, argv);

    app.setApplicationName("Vodafone190 Desktop Widget");
    app.setOrganizationName("sakya");
    app.setApplicationVersion(QUOTE(APP_VERSION));
    qInstallMsgHandler(SimpleLoggingHandler);

    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        qDebug() << "Asking to create a new widget.";
        app.sendMessage(MESSAGE_ADD_WIDGET);
        return 0;
    }

    WidgetManager* manager = new WidgetManager(NULL);
    QObject::connect(&app, SIGNAL(messageReceived(const QString&)), manager, SLOT(receiveMessage(const QString&)));

    QString folder = CommonStatic::GetSettingsFolder();
    if (!QDir().exists(folder))
        QDir().mkdir(folder);

    WidgetManager::RestoreWidgets();

    return app.exec();
}
