#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtDeclarative/QDeclarativeView>
#include <QDesktopWidget>
#include <QtGui/QMainWindow>
#include <QDeclarativeView>
#include <QDeclarativeContext>
#include <QObject>
#include <QString>
// #include "Notty.h" //notifications

#include <QDebug>

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_HILDON)
#include <QtDBus/QtDBus>
#include <QDialog>
#include <QtMaemo5/QMaemo5InformationBox>
// #include <q-extras/qemaemo5notification.h>
#include <QList>
#include "qmaemo5extra/qmaemo5notification.h"
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include "qmaemo5extra/maemo5deviceevents.h"

#define APP_DBUS_PATH "/net/mece/tweedsuit"
#define APP_DBUS_SERVICE "net.mece.tweedsuit"
#define APP_DBUS_INTERFACE "net.mece.tweedsuit"

#else
#if !defined(Q_WS_WIN)
#undef signals // Collides with GTK symbols
#include <libnotify/notify.h>
#endif
#endif

#if defined(USE_OPENGL)
#   include <QtOpenGL>
#endif

#define QT_USE_FAST_CONCATENATION
#define QT_USE_FAST_OPERATOR_PLUS


class MainWindow : public QMainWindow
{
  Q_OBJECT

public:
    explicit MainWindow(QDesktopWidget *parent);
    QDeclarativeView *viewer;
#if defined(USE_OPENGL)
    QGLWidget *glWidget;
#endif
#if defined(Q_WS_MAEMO_5)
    QDBusMessage *dbusMessage;
    //QDBusMessage *reply;
    //QeMaemo5Notification *notification;
    // QDBusInterface interface;
            // vibrate
/*        QDBusMessage reply = interface->call(MCE_ENABLE_VIBRATOR);
        if (reply.type() == QDBusMessage::ErrorMessage)
                qDebug() << reply.errorMessage(); */
#endif

    ~MainWindow();

        Q_INVOKABLE void notify(const QString &title, const QString &text);
private:
#if defined(Q_WS_MAEMO_5)
    QDBusInterface *interface;
#endif
};

#endif // MAINWINDOW_H
