import Qt 4.7

Item {
    id: columnBox
    x: screen.width > 480 ? -601 : -381
    y: 70
    z: 5
    // property string state

    Behavior on x {
        SpringAnimation { mass: 0.8; spring: 8; damping: 0.3 }
    }
    Rectangle {
        opacity: 0
        clip: true
        id: inputArea
        width: screen.width > 480 ?  600 : 380
        height: buttonrow.height + buttonrow.y + 10
        //color: "grey"
        smooth: true
        z: 1
        // border.width: 1
        // border.color: "#cbcbcb"
        radius: 5
        gradient: boxgrad
        Gradient {
            id: boxgrad
            GradientStop { position: 0.0; color: "#666" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        Rectangle {
            x: 0; y: 0; z:1
            width: parent - 1
            height: timeoutInputContainer.height + timeoutInputContainer.y + 4
            color: "transparent"
            border.width: 1
            border.color: "grey"
            radius: 5
        }
        Image { // moving background
            z: 0
            id: bgimage
            source: "images/flower_blue_1.png"
            x: -140
            y: 100
            smooth: true
            Behavior on x {
                NumberAnimation { duration: 20000; }
            }
            Behavior on y {
                NumberAnimation { duration: 20000; }
            }
        }
        Text {
            id: label
            text: "Search phrase or rss url"
            font.pointSize: 12
            x: 10
            y: 5
        }

        Rectangle {
            id: searchInputContainer
            width: parent.width - 30
            height: screen.width > 480 ? 60 : 85
            color: "white"
            border.width: 1
            border.color: "#cbcbcb"
            radius: 5
            x: 15
            y: label.y + label.height + 3
            TextEdit {
                x: 5
                y: 2
                Keys.onReturnPressed: inputArea.addColumn("search");
                Keys.onEnterPressed: inputArea.addColumn("search");
                font.pointSize: 15
                id: searchInput
                width: parent.width - 10
                height: parent.height - 4
                wrapMode: TextEdit.Wrap
            }
        }
        Text {
            id: label2
            text: "Refresh rate"
            font.pointSize: 12
            x: 10
            y: searchInputContainer.y +  searchInputContainer.height + 2

        }


        Rectangle {
            id: timeoutInputContainer
            width: 50; height: 30;
            color: "white"
            border.color: "#cbcbcb"
            border.width: 1
            radius: 5
            x: 15; y: label2.y + label.height + 1
            TextInput {
                x: 5
                y: 2
                font.pointSize: 15
                id: timeoutInput
                text: "0"
                width: parent.width - 10
                height: parent.height - 4
            }
        }
	Text {
            id: lblRefRate
            text: "seconds"
            font.pointSize: 9
            x: timeoutInputContainer.x + timeoutInputContainer.width + 2
            y: timeoutInputContainer.y + 15
	}
        Rectangle {
            color: "transparent"
            id: buttonrow
            x: lblRefRate.x + lblRefRate.width + 5
            y: searchInputContainer.y + searchInputContainer.height + 5
            width: parent.width - lblRefRate.x - lblRefRate.width - 10
            height: screen.width > 480 ? 45 : 93
            Flow {
                // anchors.right: parent.right
                anchors.fill: parent
                id: buttonflow
                spacing: 3
                // x: parent.width - 5 - width
                // y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))

                NewButton {
                    useimg: false
                    usecheckbox: true
                    // x: label2.x + label2.width + lblRefRate.width
                    // y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
                    property int notify: 0
                    text: "Notify"
                    id: notifyToggle
                    onClicked: {
                        if (notify > 0) {
                            notify = 0;
                            checked = false
                        } else {
                            notify = 1;
                            checked = true
                        }
                    }
                }
                NewButton {
                    useimg: false
                    text: "more"
                    onClicked: {
                        if (moreButtonsArea.state == "")
                            moreButtonsArea.state = "show";
                        else
                            moreButtonsArea.state = "";

                    }
                    id: moreButton
                }


                NewButton {
                    useimg: false
                    // x: dmButton.x - 5 - width
                    // y: Math.round(((label2.y + timeoutInputContainer.height + timeoutInputContainer.y) / 2) - (height/2))
                    text: "Add RSS"
                    onClicked: inputArea.addColumn("rss")
                    id: rssButton
                }

                NewButton {
                    useimg: false
                    text: "Add User"
                    onClicked: inputArea.addColumn("user")
                    id: userButton
                }

                NewButton {
                    useimg: false
                    // x: parent.width - 5 - width
                    text: "Add Search"
                    onClicked: inputArea.addColumn("search")
                    id: searchButton
                    //fontSize: 12;
                }
            }
        }

        Rectangle {
            y: searchButton.y + searchButton.height
            height: 5
            color: "transparent"
        }

        function addColumn (type) {
            console.log ("add column clicked")
            screen.addNewTwitterColumn(searchInput.text, type, parseInt(timeoutInput.text), notifyToggle.notify);

            // mainrowModel.append({ search: searchInput.text })
            columnBox.state = "closed"
            searchInput.text = ""
            return true
            // mainrowModel.reload()
        }
    }
    Rectangle {
        property bool shown: false
        opacity: 0
        id: moreButtonsArea
        x: 10; y: 5; z: 0
        width: inputArea.width - 20;
        height: inputArea.height - 20;
        // opacity: ((inputArea.height - (moreButtonsArea.height - moreButtonsRow.height - 10) + y - 10) / (inputArea.height - (moreButtonsArea.height - moreButtonsRow.height - 10) - 5)) - 1
        gradient: Gradient {
            GradientStop { position: 0.0; color: "#bbb" }
            GradientStop { position: 1.0; color: "#eee" }
        }
        border.width: 1
        border.color: "#cbcbcb"
        Behavior on opacity {
            NumberAnimation { duration: 500; }
        }
        states: [
            State {
                name: "show"
                PropertyChanges {
                    target: moreButtonsArea
                    y: inputArea.height - (moreButtonsArea.height - moreButtonsRow.height - 10)
                }
                PropertyChanges {
                    target: moreButtonsArea
                    opacity: inputArea.opacity
                }
            }
        ]
        transitions: [
            Transition {
                NumberAnimation { target: moreButtonsArea; property: "y"; duration: 100 }
            }
        ]

        Rectangle {
            color: "transparent"
            id: moreButtonsRow
            x: moreButtonsArea.width - 5 - width
            y: moreButtonsArea.height - 5 - height
            width: parent.width - 6
            height: screen.width > 480 ? 45 : 93
            Flow {
                width: parent.width
                spacing: 3
                NewButton {
                    useimg: false
                    text: "Add home"
                    onClicked: inputArea.addColumn("home")
                    id: homeButton
                }

                NewButton {
                    useimg: false
                    text: "Add Mentions"
                    onClicked: inputArea.addColumn("mentions")
                    id: mentionsButton
                }

                NewButton {
                    useimg: false
                    text: "Add DM"
                    onClicked: inputArea.addColumn("dm")
                    id: dmButton
                }
                NewButton {
                    useimg: false
                    text: "Add List"
                    onClicked: inputArea.addColumn("list")
                    id: listButton
                }
            }
        }
    }
    Rectangle {
        id: dragArea
        width: 60
        height: 50
        z: 2
        //color: "grey"
        gradient: boxgrad
        smooth: true
        border.width: 1
        border.color: "grey"
        radius: 10
        x: inputArea.x + inputArea.width - 5
        y: inputArea.y + 10
        NewButton {
            id: dragbutton
            anchors.centerIn: parent
            z:2
            flat: true
            useimgsize:  true
            bsource: 'images/add_40x40.png'
            onClicked: {
                if (columnBox.state != "open") {
                    columnBox.state = "open"
                    tweetBox.state = "closed"
                    console.log("Opened");
                    searchInput.forceActiveFocus()
                } else {
                    columnBox.state = "closed";
                    mainrow.forceActiveFocus()
                    console.log("Closed");
                }
            }
            button.drag.axis: Drag.XAxis
            button.drag.target: columnBox
            onReleased: {
                if (button.drag.active == true) {
                    console.log("dragging")
                    if (columnBox.state != "closed") {
                        if (columnBox.x < 0) {
                            columnBox.state = "closed"
                            mainrow.forceActiveFocus()
                        } else {
                            tweetBox.state = "closed"
                            columnBox.state = "move"
                            columnBox.state = "open"
                            searchInput.forceActiveFocus()
                        }
                    } else {
                        if (columnBox.x > -541) {
                            tweetBox.state = "closed"
                            columnBox.state = "open"
                            searchInput.forceActiveFocus()
                        } else {
                            columnBox.state = "move"
                            columnBox.state = "closed"
                            mainrow.forceActiveFocus()
                        }
                    }
                }
            }
        }
    }

    states: [
        State {
            name: "closed"
            PropertyChanges { target: columnBox; x: screen.width > 480 ? -601 : -381 }
            PropertyChanges { target: inputArea; opacity: 0 }
            PropertyChanges { target: bgimage; x: -140; y: 100 }


        },

        State {
            name: "open"
            PropertyChanges { target: columnBox; x: screen.width > 480 ? 60 : 50 }
            PropertyChanges { target: inputArea; opacity: 1 }
            PropertyChanges { target: bgimage; x: 0; y: 0 }
         },
        State {
            name: "move"
            when: dragbutton.button.drag.active == true
            PropertyChanges { target: inputArea; opacity: 1 }
        }
    ]
}
