#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QStringList>
#include <QXmlStreamReader>
#include <QDebug>
#include <QWidget>
#include <QMaemo5InformationBox>

#include "tubeapi.h"

struct TubeApiPrivate {
	QStringList results;
	QUrl apiUrl;
	QNetworkAccessManager *manager;
	int maxItems;
};

TubeApi::TubeApi( QObject *parent, int function)
        : QObject( parent )
{
	d = new TubeApiPrivate;
	d->manager = new QNetworkAccessManager( this );
	connect( d->manager, SIGNAL(finished(QNetworkReply*)), SLOT(finished(QNetworkReply *)) );
	_function = function;
}

TubeApi::~TubeApi()
{
	delete d;
}

void TubeApi::setUrl(QUrl url) 
{
	d->apiUrl = url;
}

QStringList TubeApi::results() const
{
	return d->results;
}

void TubeApi::search()
{
	//qDebug() << "Constructed search URL" << d->apiUrl;

	d->manager->get( QNetworkRequest(d->apiUrl) );
}

void TubeApi::finished( QNetworkReply *reply )
{
	if ( reply->error() != QNetworkReply::NoError ) {
		//qDebug() << "Request failed, " << reply->errorString();
		emit finished(false);
		return;
	}
	
	bool ok;
	if ( isRoutingFunc() )
	{
		//qDebug() << "Routing request succeeded";
		ok = processRoutingApiResult( reply );
	}
	else if ( isStatusFunc() )
	{
		//qDebug() << "Status request succeeded";
		ok = processStatusApiResult( reply );
	}

	emit finished( ok );
}

bool TubeApi::processStatusApiResult( QIODevice *source )
{
	d->results.clear();

	QXmlStreamReader reader( source );
	QString currId;
	QString line1;
	while ( !reader.atEnd() ) 
	{
		QXmlStreamReader::TokenType tokenType = reader.readNext();
		//qDebug() << "Token" << int(tokenType);
		//qDebug() << "Token: " << reader.tokenString() << "Name : " << reader.name();
		if ( tokenType == QXmlStreamReader::StartElement && (reader.name() == "id" || reader.name() == "status") )
		{
			if ( reader.name() == "id" )
			{
				reader.readNext();
				currId = reader.text().toString();
				line1 += currId;
			}
			else  // status
			{
				reader.readNext();
				line1 += " has " + reader.text().toString();
				d->results << line1;
				line1.clear();
			}
		}
		else if ( tokenType == QXmlStreamReader::StartElement && reader.name() == "messages" )
		{
			reader.readNext();
			QString line2;
			while(tokenType != QXmlStreamReader::EndElement && reader.name() != "messages")
			{
				if ( tokenType == QXmlStreamReader::StartElement && reader.name() == "message" )
				{
					reader.readNext();
					//qDebug() << "Data: " << reader.text();
					line2 += reader.text().toString();
				}
				reader.readNext();
			}
			d->results << line2;
		}

	}

	//qDebug() << "Results" << d->results;
	return true;
}

bool TubeApi::processRoutingApiResult( QIODevice *source )
{
	d->results.clear();

	d->results << source->readAll();

	//qDebug() << "Results" << d->results;

	return true;
}
