﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

from PyQt4.QtNetwork import QNetworkRequest
import HTMLParser,  re
import ConfigParser
from urlparse import urlparse
from utils.htmlTools import htmlTools
from utils.DebugLog import DebugLog, DebugFile
from Extractor import Extractor
from model.RideModel import Ride

class TableParserTramway(Extractor, HTMLParser.HTMLParser):

   def __init__(self):
      DebugLog("TableParserTramway::__init__")

      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagHeurePassage = False
      self.tagHeurePassageB = False
      self.tagDestination = False
      self.tagDestinationB = False
      self.tagUnavailable = False
      self.station = False
      self.tagNoTrain = False
      self.train = ''
      Extractor.Clear(self)
      self.stopParsing = False

   def Feed(self, html):
      DebugLog("TableParserTramway::Feed")
      self.Clear()
      self.html = htmlTools.unescape(html.strip().decode('iso-8859-1'))
      self.feed(self.html)

   def handle_starttag(self, tag, attrs):
      if tag == 'div' and dict(attrs).has_key('class'):
         if dict(attrs)['class'] == 'bg1' or dict(attrs)['class'] == 'bg3':
            self.tagDestination = True
            self.currentRide = Ride()
         elif dict(attrs)['class'] == 'error':
            self.tagUnavailable = True
            self.currentRide = Ride()

         elif dict(attrs)['class'] == 'schmsg1' or dict(attrs)['class'] == 'schmsg3':
            self.tagHeurePassage = True

      elif self.tagHeurePassage and tag == 'b':
         self.tagHeurePassageB = True
         
      elif self.tagDestination and tag == 'b':
         self.tagDestinationB = True

   def handle_data(self, data):
      if self.tagDestination:
         u = data.replace('>', '').strip()
         self.currentRide.setDestination(u)
         
      if self.tagDestinationB:
         u = data.replace('>', '').strip()
         self.currentRide.setDestination(u)

      if self.tagHeurePassageB:
         heure = data.strip()
         # On raccourcit 'Train a l'approche' et 'Train a quai'
         heure = heure.replace('Train ', '')
         self.currentRide.setHeure(heure)

      if self.tagNoTrain:
         self.currentRide = Ride()
         self.currentRide.setTrain(u'Aucun train pour ce trajet')
         self.currentRide.setNoTrain(True)
         
      if self.tagUnavailable:
         self.currentRide = Ride()
         self.currentRide.setNoTrain(True)
         self.currentRide.setTrain(data.strip())

   def handle_endtag(self, tag):
      if self.tagUnavailable:
         self.listRides.append(self.currentRide)
         self.currentRide = None
         self.tagUnavailable = None
   
      if self.tagHeurePassageB and tag=='b':
         self.tagHeurePassage = False
         self.tagHeurePassageB = False
         self.listRides.append(self.currentRide)
         self.currentRide = None

      if self.tagDestination and tag=='div':
         self.tagDestination = False
         
      if self.tagDestinationB and tag=='b':
         self.tagDestinationB = False
         self.tagDestination = False

      if self.tagNoTrain:
         self.listRides.append(self.currentRide)
         self.currentRide = None
         self.tagNoTrain ^= (self.tagNoTrain and tag == 'div')

   def fillModel(self, imax):
      DebugLog("TableParserTramway::fillModel")
      self.AppendRidesToModel(imax)
      self.perturbation='perturb'

   def ParsePerturbation(self, str):
      DebugLog("TableParserTramway::ParsePerturbation")

      res = re.findall('<div class="trafic">(.+?)</div>', str, re.DOTALL)
      if res:
         for p in res:
            s = 'alt=["\']\s*Ligne %s["\'].+?(?:</b|<br)>(.+?)(?:<img.+?alt=["\']M)'%self.ligne
            r = re.search(s, p, re.DOTALL)
            
            if not r:
               s = 'alt=["\']\s*Ligne %s["\'].+?(?:</b|<br)>(.+?)(?:<b>Trafic normal)'%self.ligne
               r = re.search(s, p, re.DOTALL)
               if not r:
                  continue

            p=r.group(1)
            if not p:
               continue
         
            p=p.replace('\n',' ').replace('<br>', '\n')
            p=re.sub('\s+', ' ', p)
            p = re.sub('<.+?>', '', p).strip().replace('&#39;', "'")

            self.rideModel.AddPerturbation( unicode(p, 'utf-8') )

class ExtractorTramway(TableParserTramway):
   def __init__(self, ligne):
      DebugLog("ExtractorTramway::__init__")

      Extractor.__init__(self, ligne.id)

      self.depart = ligne.depart
      self.station = ligne.codeDepart
      self.ligne = ligne.ligne
      self.sens = ligne.direction
      lineTitle = ( ('T', self.ligne, 32), self.depart + ' > '+ligne.arrivee)
      self.rideModel.setIconTitle( lineTitle )

      urlMobi = 'http://wap.ratp.fr/siv/schedule?service=next&reseau=tram&lineid=BT%s&directionsens=%s&stationid=%s'
      self.url = urlMobi%(self.ligne, self.sens, self.station )
      DebugLog(self.url)
      self.urlPerturb = 'http://www.ratp.fr/informer/trafic/trafic.php?cat=3'

      TableParserTramway.__init__(self)
