#!/usr/bin/python
# -*- coding: utf-8 -*-

import os, re
from utils.DebugLog import DebugLog, getScriptPath
from utils.Config import RidesConfig, ConfFile, RideConf
from utils.TrainDb import DbTrain, DbBus
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import Qt
from PyQt4.QtGui import  QCompleter, QLineEdit, QStringListModel

class Completer(QCompleter):
   def __init__(self, parent=None):
      super(Completer,self).__init__(parent)
      model = QStringListModel()
      self.setModel(model)
      self.stringlist=QtCore.QStringList()

   def setStringList(self, stringlist):
      self.stringlist=stringlist
      self.model().setStringList(stringlist)

   def Filter(self, completionText):
      s = unicode(completionText)
      s = re.sub(u"([âaàä])",  u"[âaàä]", s)
      s = re.sub(u"([éèêeë])", u"[éèêeë]",s)
      s = re.sub(u"([iîï])",   u"[iîï]",  s)
      s = re.sub(u"([uüûù])",  u"[uüûù]", s)
      s = re.sub(u"([oôö])",   u"[oôö]",  s)
      s = re.sub(u"([\-\s'])",  u"[\-\s']",  s)
      r = QtCore.QRegExp(s)
      r.setCaseSensitivity(Qt.CaseInsensitive)
      filtered=self.stringlist.filter(r)
      self.model().setStringList(filtered)

class LineEdit(QLineEdit):
   def __init__(self, parent=None):
      super(LineEdit,self).__init__(parent)
      self.cmp=None

   def setCompleter(self,completer):
      if self.cmp:
         self.disconnect(self.cmp,0,0)
      self.cmp=completer
      self.cmp.setWidget(self)
      self.cmp.setCompletionMode(QCompleter.PopupCompletion)
      self.cmp.setCaseSensitivity(Qt.CaseInsensitive)
      self.connect(self.cmp, QtCore.SIGNAL('activated(QString)'),self.insertCompletion)

   def insertCompletion(self,string):
      self.setText(string)

   def mousePressEvent(self, e):
      self.ShowCompletion()

   def keyPressEvent(self,e):
      if e.key() in (Qt.Key_Enter,Qt.Key_Return,Qt.Key_Escape,Qt.Key_Tab,Qt.Key_Backtab,Qt.Key_Alt):
         e.ignore()
         return

      super(LineEdit, self).keyPressEvent(e)

      if e.text():
         self.cmp.Filter( self.text() )

      self.ShowCompletion()

   def ShowCompletion(self):
      cr = self.childrenRect()
      self.cmp.complete(cr)

class SelectLine(QtGui.QDialog):
   def __init__(self, lines):
      QtGui.QDialog.__init__(self)
      self.ligne = ''

      self.setWindowTitle(u'Plusieurs lignes possible pour ce trajet')
      iconsPath = os.path.join(os.path.dirname(getScriptPath()), 'icons')

      self.lignes = QtGui.QComboBox()

      for l in lines:
         iconPath = os.path.join(iconsPath, 'tec/%dx%d/%s.png'%(32, 32, l) )
         self.lignes.addItem(QtGui.QIcon(iconPath), l.replace('M', u'Métro ').replace('R', u'RER '))

      buttons = QtGui.QDialogButtonBox()
      buttons.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
      self.connect(buttons, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.connect(buttons, QtCore.SIGNAL("rejected()"), self.OnCancel)

      vbox = QtGui.QVBoxLayout()
      vbox.addWidget(self.lignes)
      vbox.addWidget(buttons)
      self.setLayout(vbox)

      self.setModal(True)

   def OnOK(self):
      self.ligne = unicode(self.lignes.currentText())
      self.accept()

   def OnCancel(self):
      self.reject()

class AddRideDlg(QtGui.QDialog):

   def __init__(self, garesConf=None, sens=0):
      QtGui.QDialog.__init__(self)

      self.setWindowTitle(u'Ajouter un trajet')
      self.garesConf = garesConf
      self.CreateLayouts()
      self.added = None
      self.setModal(True)
      self.sens=sens

   def UpdateCompleter2(self, gareName):
      # With station name, we look for station on same line
      c = self.db.execute('SELECT gares.rowid, name, ligne, exploitant, position FROM gares,lignes WHERE name="%s" AND gares.rowid=lignes.gareid'%gareName)
      lignes=[]
      for row in c:
         lignes.append( (row[2], row[3]) )

      req=''
      for lig, exp in lignes:
         if req:
            req += ' OR '
         req += '(lignes.ligne="%s"'%lig
         req += ')'

      if req:
         req = 'AND (%s)'%req

      # Get station that are on same line
      req = 'SELECT name FROM gares,lignes WHERE gares.rowid=lignes.gareid AND name<>"%s" %s GROUP BY name ORDER BY name'%(gareName, req)
      DebugLog(req)
      c = self.db.execute(req)
      gares=QtCore.QStringList()
      for row in c:
         DebugLog(row[0])
         gares << row[0]

      self.completer2.setStringList(gares)


   def UpdateCompleterBus(self, line):
      # With station name, we look for station on same line
      c = self.dbBus.execute('SELECT name FROM gares WHERE ligne="%s" AND code<>""'%line)
      gares=QtCore.QStringList()
      DebugLog("Gares:")
      for row in c:
         DebugLog(row[0])
         gares << row[0]
      self.completerBD.setStringList(gares)

      DebugLog("Directions:")
      c = self.dbBus.execute('SELECT name FROM gares WHERE ligne="%s" AND direction<>""'%line)
      dirs=QtCore.QStringList()
      for row in c:
         DebugLog(row[0])
         dirs << row[0]
      self.completerBA.setStringList(dirs)

   def CreateLayouts(self):
      self.tabW = QtGui.QTabWidget()

      self.CreateLayoutMetroRER()
      self.CreateLayoutBus()

      layout = QtGui.QHBoxLayout()
      layout.addWidget(self.tabW)
      self.setLayout(layout)

   def CreateLabelEdit(self, parent, text, completer):
      label = QtGui.QLabel(parent)
      label.setText(text)
      edit = LineEdit(parent)
      edit.setCompleter(completer)
      return label, edit

   def PackLabelEdit(self, vbox, label, edit):
      hbox = QtGui.QHBoxLayout()
      hbox.addWidget(label)
      hbox.addWidget(edit)
      vbox.addLayout(hbox)

   def CreateLayoutBus(self):
      tab1 = QtGui.QWidget()

      list = QtCore.QStringList()
      self.dbBus = DbBus()
      c = self.dbBus.execute('SELECT ligne FROM gares GROUP BY ligne')

      for row in c:
         list << row[0]

      completer = Completer()
      completer.setStringList(list)
      self.completerBD = Completer()
      self.completerBA = Completer()
      #self.completerB2.setStringList(list)

      labelBL, self.editBL = self.CreateLabelEdit(tab1, u"Ligne", completer)
      labelBD, self.editBD = self.CreateLabelEdit(tab1, u"Départ", self.completerBD)
      labelBA, self.editBA = self.CreateLabelEdit(tab1, u"Direction", self.completerBA)

      self.connect(completer, QtCore.SIGNAL('activated(QString)'), self.editBL.insertCompletion)
      self.connect(completer, QtCore.SIGNAL('activated(QString)'), self.UpdateCompleterBus)

      c.close()

      vbox = QtGui.QVBoxLayout()
      self.PackLabelEdit(vbox, labelBL, self.editBL)
      self.PackLabelEdit(vbox, labelBD, self.editBD)
      self.PackLabelEdit(vbox, labelBA, self.editBA)

      hLayout3 = QtGui.QHBoxLayout()
      buttons = QtGui.QDialogButtonBox(tab1)
      buttons.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
      self.connect(buttons, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.connect(buttons, QtCore.SIGNAL("rejected()"), self.OnCancel)

      hLayout3.addWidget(buttons)
      vbox.addLayout(hLayout3)
      tab1.setLayout(vbox)

      self.tabW.addTab(tab1, u'Bus')

   def CreateLayoutMetroRER(self):
      tab1 = QtGui.QWidget()

      list = QtCore.QStringList()
      self.db = DbTrain()
      c = self.db.execute('SELECT * FROM gares ORDER BY name')

      for row in c:
         list << row[0]

      completer = Completer()
      completer.setStringList(list)

      self.completer2 = Completer()
      self.completer2.setStringList(list)

      labelD, self.editD = self.CreateLabelEdit(tab1, u"Départ", completer)
      labelA, self.editA = self.CreateLabelEdit(tab1, u"Arrivée", self.completer2)
      vbox = QtGui.QVBoxLayout()
      vbox.addWidget(labelD)
      vbox.addWidget(self.editD)
      vbox.addWidget(labelA)
      vbox.addWidget(self.editA)

      self.connect(completer, QtCore.SIGNAL('activated(QString)'), self.editD.insertCompletion)
      self.connect(completer, QtCore.SIGNAL('activated(QString)'), self.UpdateCompleter2)

      hLayout3 = QtGui.QHBoxLayout()
      buttons = QtGui.QDialogButtonBox(tab1)
      buttons.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
      self.connect(buttons, QtCore.SIGNAL("accepted()"), self.OnOK)
      self.connect(buttons, QtCore.SIGNAL("rejected()"), self.OnCancel)

      hLayout3.addWidget(buttons)
      vbox.addLayout(hLayout3)
      tab1.setLayout(vbox)

      self.tabW.addTab(tab1, u'Métro/RER')
      self.editD.setFocus()

   def ReadConfig(self):
      if self.garesConf:
         self.garesConf.ReadRides()

   def WriteConfig(self):
      if self.garesConf:
         self.garesConf.WriteRides()

   def IsRATPcode(self, val):
      try:
         if int(val)>0:
            return True
         else:
            return False
      except:
         return False

   def AddTrajet(self, depart, arrivee):
      if not depart:
         raise RuntimeError("Gare de départ non renseignée")

      if not arrivee:
         raise RuntimeError("Gare d'arrivée non renseignée")

      req = 'SELECT ligne FROM gares, lignes WHERE gares.name="%s" AND gares.rowid=lignes.gareid' % depart
      DebugLog(req)
      c = self.db.execute(req)
      lignesD=[]
      for row in c:
         lignesD.append(row[0])

      if len(lignesD)==0:
         DebugLog("Gare '%s' inconnue"%depart)
         raise RuntimeError("Gare '%s' inconnue"%depart)

      req = 'SELECT ligne FROM gares, lignes WHERE gares.name="%s" AND gares.rowid=lignes.gareid' % arrivee
      DebugLog(req)
      c = self.db.execute(req)

      lignesA=[]
      for row in c:
         if row[0] in lignesD:
            ligne=row[0]
            if ligne not in lignesA:
               lignesA.append(ligne)
               DebugLog("commun : "+ligne)

      if len(lignesA)==0:
         DebugLog("Gare '%s' inconnue"%arrivee)
         raise RuntimeError("Gare '%s' inconnue"%arrivee)

      elif len(lignesA)>1:
         selLigneDlg = SelectLine(lignesA)
         selLigneDlg.exec_()
         if not selLigneDlg.ligne:
            raise RuntimeError("Aucune ligne choisie")
         else:
            ligne = selLigneDlg.ligne.replace(u'Métro ',u'M').replace(u'RER ',u'R')

      DebugLog(str(lignesA))

      req='SELECT name, code, exploitant, position FROM gares, lignes WHERE gares.name="%s" AND gares.rowid=lignes.gareid AND ligne="%s"' % (depart, ligne)
      DebugLog(req)
      c = self.db.execute(req)

      res = c.fetchone()
      if not res:
         return False

      codeDepart = res[1]
      exploitantD = res[2]

      DebugLog(str(res))

      if exploitantD=='R' and not self.IsRATPcode(codeDepart):
         for res in c:
            DebugLog(str(res))
            if self.IsRATPcode(res[1])>0:
               codeDepart = res[1]
            else:
               DebugLog("%s not RATP code"%res[1])

      tec = ''
      if ligne[0]=='M':
         tec = 'Metro'
      elif ligne[0]=='R':
         tec = 'RER'
      elif ligne[0:2]=='TR':
         tec = 'Transilien'
      elif ligne[0]=='T':
         tec = 'Tramway'
      else:
         raise RuntimeError('tec inconnu "%s"'%ligne)

      depart = res[0]
      posDepart = 0
      posArrivee = 0

      if res[3]:
         posDepart = int(res[3])

      req = 'SELECT name, code, exploitant, position FROM gares, lignes WHERE gares.name="%s" AND gares.rowid=lignes.gareid AND ligne="%s"' % (arrivee, ligne)
      DebugLog(req)
      c = self.db.execute(req)
      res = c.fetchone()

      DebugLog(str(res))
      codeArrivee = res[1]
      exploitantA = res[2]

      if exploitantA!=exploitantD or \
         (exploitantA=='R' and not self.IsRATPcode(codeArrivee)):
         for res in c:
            DebugLog(str(res))
            if self.IsRATPcode(res[1]):
               if exploitantD=='R':
                  DebugLog(' exploitantD==R %s'%res[1])
                  codeArrivee = res[1]
            else:
               if exploitantD=='S':
                  DebugLog('exploitantD==S %s'%res[1])
                  codeArrivee = res[1]

      if ligne[0:2]=='TR':
         ligne=ligne[2:]
      else:
         ligne = ligne[1:]
      arrivee = res[0]
      if res[3]:
         posArrivee = int(res[3])

      if posDepart-posArrivee>0:
         direction = 'A'
      elif posDepart-posArrivee<0:
         direction = 'R'
      else:
         direction = ''

      DebugLog('posD=%d, posA=%d, dir=%s'%(posDepart, posArrivee, direction))

      l = RideConf(ligne, tec, depart, arrivee, codeDepart, codeArrivee, exploitantD, direction, self.sens)
      if self.garesConf:
         self.garesConf.AddRide(l)
      return l

   def AddTrajetBus(self, ligne, depart, direction):
      if not depart:
         raise RuntimeError(u"Gare de départ non renseignée")

      if not direction:
         raise RuntimeError(u"Direction non renseignée")

      c = self.dbBus.execute("SELECT code FROM gares WHERE gares.name='%s' AND gares.ligne='%s'"%(depart,ligne))
      row = c.fetchone()

      if not row:
         DebugLog("Gare '%s' inconnue"%depart)
         raise RuntimeError("Gare '%s' inconnue"%depart)

      codeDepart = row[0]

      c = self.dbBus.execute("SELECT direction FROM gares WHERE gares.name='%s' AND gares.ligne='%s' AND direction<>''"%(direction,ligne))
      row = c.fetchone()

      if not row:
         DebugLog("Gare '%s' inconnue"%direction)
         raise RuntimeError("Gare '%s' inconnue"%direction)

      dir = row[0]
      tec = 'Bus'
      DebugLog('posD=%s, dir=%s'%(codeDepart, str(direction)))

      l = RideConf(str(ligne), tec, str(depart), '', codeDepart, '', 'R', dir, self.sens)
      if self.garesConf:
         self.garesConf.AddRide(l)
      return l

   def OnOK(self):
      try:
         if self.tabW.currentIndex()==0:
            self.added = self.AddTrajet( self.editD.text(), self.editA.text() )
         elif self.tabW.currentIndex()==1:
            self.added = self.AddTrajetBus( self.editBL.text(), self.editBD.text(), self.editBA.text() )
         self.WriteConfig()
      except RuntimeError, e:
         u=unicode(str(e), 'utf-8')
         QtGui.QMessageBox.critical(self, u'Erreur', u )
      self.accept()

   def OnCancel(self):
      self.reject()
