#!/usr/bin/python
# -*- coding: utf-8 -*-

import HTMLParser, re
from urlparse import urlparse
from Extractor import Extractor
from model.RideModel import Ride
from utils.DebugLog import DebugLog, DebugFile

class TableParserTransilien(Extractor, HTMLParser.HTMLParser):
   def __init__(self):
      DebugLog("TableParserTransilien::__init__")
      HTMLParser.HTMLParser.__init__(self)
      self.Clear()

   def Clear(self):
      self.tagTableHoraires = False
      self.tagHeurePassage = False
      self.tagDestination = False
      self.tagCodeMission = False
      self.tagHeurePassageB = False
      self.noTrain = False
      self.tagError = False
      self.tagVoie = False
      Extractor.Clear(self)

   def Feed(self, html):
      DebugLog("TableParserTransilien::Feed")
      self.Clear()
      self.html = html.decode('iso-8859-1')
      self.feed(self.html)

   def handle_starttag(self, tag, attrs):
      if tag == 'table' and dict(attrs).has_key('id') and (dict(attrs)['id'] == 'listeTrain'):
         self.tagTableHoraires = True

      elif dict(attrs).has_key('id') and dict(attrs)['id']=='message':
         DebugLog("  Error found!")
         self.tagError = True

      elif tag=='div' and dict(attrs).has_key('id') and dict(attrs)['id'] == 'noTrain':
         self.noTrain = True
         
      elif self.tagTableHoraires and tag == 'div':
         try:
            self.tagCodeMission = ( dict(attrs)['id'] == 'Train')
            self.tagHeurePassage = ( dict(attrs)['id'] == 'heure')
            self.tagVoie = ( dict(attrs)['id'] == 'voie')
            self.tagDestination = ( dict(attrs)['id'] == 'destination')

         except KeyError:
            if dict(attrs).has_key('id'):
               raise
            else:
               pass
               
      elif dict(attrs).has_key('id') and dict(attrs)['id']=='libHoraireTheorique':
         if not self.currentRide:
            self.currentRide = Ride()
            self.currentRide.setTrain(u'Attention : Horaires théoriques')
            self.currentRide.setNoTrain(True)
            self.listRides.append(self.currentRide)
            self.currentRide = None

      elif tag=='a' and dict(attrs).has_key('class') and (dict(attrs)['class'] == 'lienIcv'):
         DebugLog("Found perturbation")
         self.perturbation = dict(attrs)['href']
         if self.perturbation:
            o = urlparse(self.url)
            self.urlPerturb = "%s://%s%s"%(o.scheme, o.netloc, self.perturbation)
      else:
         self.tagHeurePassageB = (tag == 'b' and self.tagHeurePassage)

   def handle_data(self, data):
      # execute pour chaque contenu de balise
      if self.tagCodeMission:
         self.currentRide = Ride()
         self.currentRide.setTrain(data.strip())

      if self.tagHeurePassageB:
         self.currentRide.setHeure(data.strip())

      if self.tagDestination:
         data = data.strip().strip('\r').strip('\n')
         if data:
            self.currentRide.setDestination(data.strip())

      if self.tagVoie:
         data = data.strip().strip('\r').strip('\n')
         if data:
            self.currentRide.setVoie(data.strip())

      if self.noTrain:
         self.currentRide = Ride()
         self.currentRide.setTrain(u'Aucun train pour ce trajet')
         self.currentRide.setNoTrain(True)

      if self.tagError:
         if not self.currentRide:
            self.currentRide = Ride()
         self.currentRide.setError(self.currentRide.error+data.strip())
         DebugLog(data.strip())
         
   def handle_endtag(self, tag):
      if self.tagDestination or self.tagError or self.noTrain:
         self.listRides.append(self.currentRide)
         self.currentRide = None

      self.tagCodeMission ^= (self.tagCodeMission and tag == 'div')
      self.tagHeurePassageB ^= (self.tagHeurePassageB and tag == 'b')
      self.tagDestination ^= (self.tagDestination and tag == 'div')
      self.tagVoie ^= (self.tagVoie and tag == 'div')
      self.tagError ^= (self.tagError and tag=='div')
      self.noTrain ^= (self.noTrain and tag=='div')
      self.noTrain = False

   def fillModel(self, imax):
      DebugLog("TableParserTransilien::fillModel(%s)"%self.id)
      self.AppendRidesToModel(imax)

   def ParsePerturbation(self, str):
      DebugLog("TableParserTransilien::ParsePerturbation")

      res = re.findall('<div id="icv".+?>(.+?)</div>', str, re.DOTALL)
      if res:
         for perturbation in res:
            p = re.sub('\s+', ' ',perturbation).strip().replace('&#39;', "'")
            self.rideModel.AddPerturbation(p)
      
class ExtractorTransilien(TableParserTransilien):
   def __init__(self, ligne):
      DebugLog("ExtractorTransilien::Init")

      Extractor.__init__(self, ligne.id)

      self.gare_depart = ligne.codeDepart
      self.gare_arrivee = ligne.codeArrivee
      self.ligne = ligne.ligne

      if ligne.tec=='Transilien':
         lineTitle = ( ('TR', self.ligne, 32), ligne.depart + ' > ' + ligne.arrivee)
      else:
         lineTitle = ( ('R', self.ligne, 32), ligne.depart + ' > ' + ligne.arrivee)
      self.rideModel.setIconTitle( lineTitle )

#      urlMobi = 'http://www.transilien.mobi/TempReelRetourListe.do?depart.code=%s&arrivee.code=%s'
      urlMobi='http://transilien.mobi/TempReelSaisieSubmit.do?etapeDepart=1&etapeArrivee=1&codeGareDepart=%s&codeGareArrivee=%s'
      
      self.url = urlMobi%(self.gare_depart, self.gare_arrivee)
      DebugLog(self.url)

      TableParserTransilien.__init__(self)

