/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;

public class DERBitString
extends ASN1Object
implements DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected byte[] data;
    private int padBits;

    public static DERBitString getInstance(Object object) {
        while (true) {
            if (object == null || object instanceof DERBitString) {
                return (DERBitString)object;
            }
            if (object instanceof ASN1OctetString) {
                byte[] byArray = ((ASN1OctetString)object).getOctets();
                object = byArray;
                byte by = byArray[0];
                byte[] byArray2 = new byte[((Object)object).length - 1];
                System.arraycopy(object, 1, byArray2, 0, ((Object)object).length - 1);
                return new DERBitString(byArray2, by);
            }
            if (!(object instanceof ASN1TaggedObject)) break;
            object = ((ASN1TaggedObject)object).getObject();
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBitString getInstance$2618b8d4(ASN1TaggedObject aSN1TaggedObject) {
        return DERBitString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERBitString(byte[] byArray, int n) {
        this.data = byArray;
        this.padBits = n;
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DERBitString(DEREncodable dEREncodable) {
        try {
            this.data = dEREncodable.getDERObject().getEncoded("DER");
            this.padBits = 0;
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    public final byte[] getBytes() {
        return this.data;
    }

    public final int getPadBits() {
        return this.padBits;
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        DERBitString dERBitString = this;
        byte[] byArray = new byte[dERBitString.data.length + 1];
        byte[] byArray2 = byArray;
        dERBitString = this;
        byArray[0] = (byte)dERBitString.padBits;
        dERBitString = this;
        System.arraycopy(dERBitString.data, 0, byArray2, 1, byArray2.length - 1);
        dEROutputStream.writeEncoded(3, byArray2);
    }

    @Override
    public int hashCode() {
        return this.padBits ^ AsymmetricKeyParameter.hashCode(this.data);
    }

    @Override
    protected final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERBitString)) {
            return false;
        }
        dERObject = (DERBitString)dERObject;
        return this.padBits == ((DERBitString)dERObject).padBits && AsymmetricKeyParameter.areEqual(this.data, ((DERBitString)dERObject).data);
    }

    @Override
    public final String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        Object object = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)object);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        object = ((ByteArrayOutputStream)object).toByteArray();
        for (int i = 0; i != ((Object)object).length; ++i) {
            stringBuffer.append(table[object[i] >>> 4 & 0xF]);
            stringBuffer.append(table[object[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }
}

