/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERFactory;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERFactory;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public final class BERTaggedObjectParser
implements DEREncodable {
    private int _baseTag;
    private int _tagNumber;
    private InputStream _contentStream;
    private boolean _indefiniteLength;

    protected BERTaggedObjectParser(int n, int n2, InputStream inputStream) {
        this._baseTag = n;
        this._tagNumber = n2;
        this._contentStream = inputStream;
        this._indefiniteLength = inputStream instanceof IndefiniteLengthInputStream;
    }

    private static ASN1EncodableVector rLoadVector(InputStream inputStream) {
        try {
            return new ASN1StreamParser(inputStream).readVector();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public final DERObject getDERObject() {
        if (this._indefiniteLength) {
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector = BERTaggedObjectParser.rLoadVector(this._contentStream);
            if (aSN1EncodableVector.v.size() == 1) {
                return new BERTaggedObject(true, this._tagNumber, aSN1EncodableVector.get(0));
            }
            return new BERTaggedObject(false, this._tagNumber, BERFactory.createSequence(aSN1EncodableVector));
        }
        Object object = this;
        if ((((BERTaggedObjectParser)object)._baseTag & 0x20) != 0) {
            object = BERTaggedObjectParser.rLoadVector(this._contentStream);
            ASN1EncodableVector aSN1EncodableVector = object;
            if (((DEREncodableVector)object).v.size() == 1) {
                return new DERTaggedObject(true, this._tagNumber, ((DEREncodableVector)object).get(0));
            }
            return new DERTaggedObject(false, this._tagNumber, DERFactory.createSequence((ASN1EncodableVector)object));
        }
        try {
            object = (DefiniteLengthInputStream)this._contentStream;
            return new DERTaggedObject(false, this._tagNumber, new DEROctetString(((DefiniteLengthInputStream)object).toByteArray()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }
}

