/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui.tree;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.kxml2.kdom.Element;
import to_do_o.core.Constants;
import to_do_o.core.settings.SettingsStore;
import to_do_o.core.settings.SettingsStoreSingleton;
import to_do_o.gui.IconProvider;
import to_do_o.gui.tree.AbstractItem;

public final class ToDoItem
extends AbstractItem {
    private Date date;
    private String todoIconColor;
    private boolean isDone = false;

    protected ToDoItem(Element object, Widget object2, int n) {
        super((Element)object, (Widget)object2, n);
        object = this;
        this.todoIconColor = ((ToDoItem)object).element.getAttributeValue("", "color");
        object2 = ((ToDoItem)object).element.getAttributeValue("", "done");
        ((ToDoItem)object).isDone = object2 != null && ((String)object2).equalsIgnoreCase("true");
        object2 = ((ToDoItem)object).element.getAttributeValue("", "date");
        if (object2 != null) {
            ((ToDoItem)object).date = new Date(Long.parseLong((String)object2));
        }
        ((AbstractItem)object).update();
    }

    public final String getIconColor() {
        if (this.todoIconColor != null && this.todoIconColor.length() > 0) {
            return this.todoIconColor;
        }
        return "blue";
    }

    @Override
    protected final Image iconImageHook() {
        return IconProvider.getIconImage("/icons/to-do" + (this.isDone ? "_done" : "") + "_" + (this.todoIconColor != null ? this.todoIconColor : "blue") + ".png");
    }

    public final boolean isDone() {
        return this.isDone;
    }

    public final void markDone(boolean done) {
        this.isDone = done;
        this.element.setAttribute("", "done", String.valueOf(this.isDone));
        this.update();
        this.notifyTree();
    }

    public final void deleteDate() {
        this.date = null;
        this.element.setAttribute("", "date", null);
        this.update();
        this.notifyTree();
    }

    public final void setDate(Date date) {
        this.date = date;
        this.element.setAttribute("", "date", String.valueOf(this.date.getTime()));
        this.update();
        this.notifyTree();
    }

    public final void setIconColor(String todoIconColor) {
        this.todoIconColor = todoIconColor;
        this.element.setAttribute("", "color", this.todoIconColor);
        this.update();
        this.notifyTree();
    }

    @Override
    public final String toString() {
        String string;
        Object object = SettingsStoreSingleton.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.date != null && ((SettingsStore)object).getBoolean("DrawDates")) {
            StringBuilder stringBuilder2 = new StringBuilder();
            object = this.date;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            int n = calendar.get(2);
            if (Constants.EMBEDDED) {
                ++n;
            }
            int n2 = calendar.get(5);
            String string2 = calendar.get(1) + "-" + (n > 9 ? "" : "0") + n + "-" + (n2 > 9 ? "" : "0") + n2;
            string = stringBuilder2.append(string2).append(" ").toString();
        } else {
            string = "";
        }
        return stringBuilder.append(string).append(super.toString()).toString();
    }

    public final Date getDate() {
        return this.date;
    }
}

