/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.oiw;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public final class ElGamalParameter
extends ASN1Encodable {
    private DERInteger p;
    private DERInteger g;

    public ElGamalParameter(BigInteger bigInteger, BigInteger bigInteger2) {
        this.p = new DERInteger(bigInteger);
        this.g = new DERInteger(bigInteger2);
    }

    public ElGamalParameter(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        this.p = (DERInteger)object.nextElement();
        this.g = (DERInteger)object.nextElement();
    }

    public final BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public final BigInteger getG() {
        return this.g.getPositiveValue();
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.g);
        return new DERSequence(aSN1EncodableVector);
    }
}

