/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;

public final class DERObjectIdentifier
extends ASN1Object {
    private String identifier;

    public static DERObjectIdentifier getInstance(Object object) {
        while (true) {
            if (object == null || object instanceof DERObjectIdentifier) {
                return (DERObjectIdentifier)object;
            }
            if (object instanceof ASN1OctetString) {
                return new DERObjectIdentifier(((ASN1OctetString)object).getOctets());
            }
            if (!(object instanceof ASN1TaggedObject)) break;
            object = ((ASN1TaggedObject)object).getObject();
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i = 0; i != byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (l < 0x80000000000000L) {
                l = (l << 7) + (long)(n & 0x7F);
                if ((n & 0x80) != 0) continue;
                if (bl) {
                    switch ((int)l / 40) {
                        case 0: {
                            stringBuffer.append('0');
                            break;
                        }
                        case 1: {
                            stringBuffer.append('1');
                            l -= 40L;
                            break;
                        }
                        default: {
                            stringBuffer.append('2');
                            l -= 80L;
                        }
                    }
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(l);
                l = 0L;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            bigInteger = bigInteger.shiftLeft(7);
            bigInteger = bigInteger.or(BigInteger.valueOf(n & 0x7F));
            if ((n & 0x80) != 0) continue;
            stringBuffer.append('.');
            stringBuffer.append(bigInteger);
            bigInteger = null;
            l = 0L;
        }
        this.identifier = stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public DERObjectIdentifier(String string) {
        char c;
        block10: {
            String string2 = string;
            if (string2.length() < 3 || string2.charAt(1) != '.') {
                c = '\u0000';
            } else {
                char c2 = string2.charAt(0);
                if (c2 < '0' || c2 > '2') {
                    c = '\u0000';
                } else {
                    c2 = '\u0000';
                    for (int i = string2.length() - 1; i >= 2; --i) {
                        char c3 = string2.charAt(i);
                        if ('0' <= c3 && c3 <= '9') {
                            c2 = '\u0001';
                            continue;
                        }
                        if (c3 == '.') {
                            if (c2 == '\u0000') {
                                c = '\u0000';
                                break block10;
                            } else {
                                c2 = '\u0000';
                                continue;
                            }
                        }
                        c = '\u0000';
                        break block10;
                    }
                    c = c2;
                }
            }
        }
        if (c == '\u0000') {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    public final String getId() {
        return this.identifier;
    }

    private static void writeField(OutputStream outputStream, long l) throws IOException {
        if (l >= 128L) {
            if (l >= 16384L) {
                if (l >= 0x200000L) {
                    if (l >= 0x10000000L) {
                        if (l >= 0x800000000L) {
                            if (l >= 0x40000000000L) {
                                if (l >= 0x2000000000000L) {
                                    if (l >= 0x100000000000000L) {
                                        outputStream.write((int)(l >> 56) | 0x80);
                                    }
                                    outputStream.write((int)(l >> 49) | 0x80);
                                }
                                outputStream.write((int)(l >> 42) | 0x80);
                            }
                            outputStream.write((int)(l >> 35) | 0x80);
                        }
                        outputStream.write((int)(l >> 28) | 0x80);
                    }
                    outputStream.write((int)(l >> 21) | 0x80);
                }
                outputStream.write((int)(l >> 14) | 0x80);
            }
            outputStream.write((int)(l >> 7) | 0x80);
        }
        outputStream.write((int)l & 0x7F);
    }

    private static void writeField(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        int n = (bigInteger.bitLength() + 6) / 7;
        if (n == 0) {
            outputStream.write(0);
            return;
        }
        byte[] byArray = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            byArray[i] = (byte)(bigInteger.intValue() & 0x7F | 0x80);
            bigInteger = bigInteger.shiftRight(7);
        }
        int n2 = n - 1;
        byArray[n2] = (byte)(byArray[n2] & 0x7F);
        outputStream.write(byArray);
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        Object object;
        EC5Util eC5Util = new EC5Util(this.identifier);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream2 = new DEROutputStream(byteArrayOutputStream);
        DERObjectIdentifier.writeField((OutputStream)byteArrayOutputStream, Integer.parseInt(eC5Util.nextToken()) * 40 + Integer.parseInt(eC5Util.nextToken()));
        while (eC5Util.hasMoreTokens()) {
            object = eC5Util.nextToken();
            if (((String)object).length() < 18) {
                DERObjectIdentifier.writeField((OutputStream)byteArrayOutputStream, Long.parseLong((String)object));
                continue;
            }
            DERObjectIdentifier.writeField((OutputStream)byteArrayOutputStream, new BigInteger((String)object));
        }
        dEROutputStream2.close();
        object = byteArrayOutputStream.toByteArray();
        dEROutputStream.writeEncoded(6, (byte[])object);
    }

    @Override
    public final int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)dERObject).identifier);
    }

    public final String toString() {
        DERObjectIdentifier dERObjectIdentifier = this;
        return dERObjectIdentifier.identifier;
    }
}

