/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class ASN1Encodable
implements DEREncodable {
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this);
        return byteArrayOutputStream.toByteArray();
    }

    public final byte[] getEncoded(String object) throws IOException {
        if (((String)object).equals("DER")) {
            object = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)object);
            dEROutputStream.writeObject(this);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        return this.getEncoded();
    }

    public final byte[] getDEREncoded() {
        try {
            return this.getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.toASN1Object().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DEREncodable)) {
            return false;
        }
        object = (DEREncodable)object;
        return this.toASN1Object().equals(object.getDERObject());
    }

    @Override
    public final DERObject getDERObject() {
        return this.toASN1Object();
    }

    public abstract DERObject toASN1Object();
}

