/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.core.pki;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JDKKeyPairGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import to_do_o.core.config.SWTConstants;

public final class CA {
    private static CA instance;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private X509Certificate cert;
    private KeyStore keyStore;
    private KeyStore trustStore;

    public static synchronized CA getInstance() {
        if (instance == null) {
            instance = new CA();
        }
        return instance;
    }

    private static String getSystemID() throws UnknownHostException {
        InetAddress localAddr = InetAddress.getLocalHost();
        String systemId = "To-Do-O: " + System.getProperty("user.name") + "@" + localAddr.getHostName() + "_" + System.getProperty("os.name");
        return systemId;
    }

    public static boolean isCreated() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        Object object = new File(SWTConstants.KEYSTORE_FILE);
        File file = new File(SWTConstants.TRUSTSTORE_FILE);
        if (((File)object).exists() && file.exists()) {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream((File)object), "quaerite et invenietis".toCharArray());
            keyStore2.load(new FileInputStream(file), "quaerite et invenietis".toCharArray());
            object = CA.getSystemID();
            return keyStore.containsAlias((String)object) && keyStore2.containsAlias((String)object);
        }
        return false;
    }

    private CA() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            if (CA.isCreated()) {
                CA cA = this;
                this.keyStore = KeyStore.getInstance("JKS");
                cA.trustStore = KeyStore.getInstance("JKS");
                cA.keyStore.load(new FileInputStream(SWTConstants.KEYSTORE_FILE), "quaerite et invenietis".toCharArray());
                cA.trustStore.load(new FileInputStream(SWTConstants.TRUSTSTORE_FILE), "quaerite et invenietis".toCharArray());
                String string = CA.getSystemID();
                cA.privateKey = (PrivateKey)cA.keyStore.getKey(string, "quaerite et invenietis".toCharArray());
                cA.cert = (X509Certificate)cA.trustStore.getCertificate(string);
                cA.publicKey = cA.cert.getPublicKey();
            } else {
                CA cA = this;
                Object object = new File(SWTConstants.TODO_O_HOME);
                if (!((File)object).exists()) {
                    ((File)object).mkdirs();
                } else if (!((File)object).isDirectory()) {
                    ((File)object).delete();
                    ((File)object).mkdirs();
                }
                cA.keyStore = KeyStore.getInstance("JKS");
                if (new File(SWTConstants.KEYSTORE_FILE).exists()) {
                    cA.keyStore.load(new FileInputStream(SWTConstants.KEYSTORE_FILE), "quaerite et invenietis".toCharArray());
                } else {
                    cA.keyStore.load(null);
                }
                cA.trustStore = KeyStore.getInstance("JKS");
                if (new File(SWTConstants.TRUSTSTORE_FILE).exists()) {
                    cA.trustStore.load(new FileInputStream(SWTConstants.TRUSTSTORE_FILE), "quaerite et invenietis".toCharArray());
                } else {
                    cA.trustStore.load(null);
                }
                object = CA.getSystemID();
                if (!cA.keyStore.containsAlias((String)object) || !cA.trustStore.containsAlias((String)object)) {
                    Object object2 = new JDKKeyPairGenerator.RSA();
                    object2.initialize(1024);
                    object2 = object2.generateKeyPair();
                    cA.publicKey = ((KeyPair)object2).getPublic();
                    cA.privateKey = ((KeyPair)object2).getPrivate();
                    object2 = new X500Principal("CN=" + (String)object);
                    Object object3 = GregorianCalendar.getInstance();
                    object3.set(2010, 1, 1);
                    Object object4 = ((Calendar)object3).getTime();
                    object3.set(2020, 12, 31);
                    object3 = ((Calendar)object3).getTime();
                    X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
                    x509V3CertificateGenerator.setSerialNumber(new BigInteger("1"));
                    x509V3CertificateGenerator.setIssuerDN((X500Principal)object2);
                    x509V3CertificateGenerator.setSubjectDN((X500Principal)object2);
                    x509V3CertificateGenerator.setNotBefore((Date)object4);
                    x509V3CertificateGenerator.setNotAfter((Date)object3);
                    x509V3CertificateGenerator.setPublicKey(cA.publicKey);
                    x509V3CertificateGenerator.setSignatureAlgorithm("SHA1withRSA");
                    object4 = "BC";
                    object3 = cA.privateKey;
                    object2 = x509V3CertificateGenerator;
                    cA.cert = object2.generate((PrivateKey)object3, (String)object4, null);
                    cA.keyStore.setKeyEntry((String)object, cA.privateKey, "quaerite et invenietis".toCharArray(), new Certificate[]{cA.cert});
                    cA.keyStore.store(new FileOutputStream(SWTConstants.KEYSTORE_FILE), "quaerite et invenietis".toCharArray());
                    cA.trustStore.setCertificateEntry((String)object, cA.cert);
                    cA.trustStore.store(new FileOutputStream(SWTConstants.TRUSTSTORE_FILE), "quaerite et invenietis".toCharArray());
                }
            }
            System.setProperty((String)"javax.net.ssl.keyStore", (String)SWTConstants.KEYSTORE_FILE);
            System.setProperty((String)"javax.net.ssl.keyStorePassword", (String)"quaerite et invenietis");
            System.setProperty((String)"javax.net.ssl.trustStore", (String)SWTConstants.TRUSTSTORE_FILE);
            System.setProperty((String)"javax.net.ssl.trustStorePassword", (String)"quaerite et invenietis");
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

