/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public abstract class ECCurve {
    ECFieldElement a;
    ECFieldElement b;

    public abstract int getFieldSize();

    public abstract ECPoint createPoint(BigInteger var1, BigInteger var2, boolean var3);

    public abstract ECPoint decodePoint(byte[] var1);

    public final ECFieldElement getA() {
        return this.a;
    }

    public final ECFieldElement getB() {
        return this.b;
    }

    public final class F2m
    extends ECCurve {
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private ECPoint.F2m infinity;

        public F2m(int n, int n2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this(n, n2, 0, 0, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2) {
            this(n, n2, n3, n4, bigInteger, bigInteger2, null, null);
        }

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            if (n2 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (n3 == 0) {
                if (n4 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
            } else {
                if (n3 <= n2) {
                    throw new IllegalArgumentException("k2 must be > k1");
                }
                if (n4 <= n3) {
                    throw new IllegalArgumentException("k3 must be > k2");
                }
            }
            this.a = this.fromBigInteger(bigInteger);
            this.b = this.fromBigInteger(bigInteger2);
            this.infinity = new ECPoint.F2m(this, null, null);
        }

        @Override
        public final int getFieldSize() {
            return this.m;
        }

        private ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, bigInteger);
        }

        @Override
        public final ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
            return new ECPoint.F2m(this, this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2), bl);
        }

        @Override
        public final ECPoint decodePoint(byte[] object) {
            switch (object[0]) {
                case 0: {
                    F2m f2m = this;
                    object = f2m;
                    object = f2m.infinity;
                    break;
                }
                case 2: 
                case 3: {
                    byte[] byArray = new byte[((byte[])object).length - 1];
                    System.arraycopy(object, 1, byArray, 0, byArray.length);
                    if (object[0] == 2) {
                        object = this.decompressPoint(byArray, 0);
                        break;
                    }
                    object = this.decompressPoint(byArray, 1);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] byArray = new byte[(((byte[])object).length - 1) / 2];
                    byte[] byArray2 = new byte[(((byte[])object).length - 1) / 2];
                    System.arraycopy(object, 1, byArray, 0, byArray.length);
                    System.arraycopy(object, byArray.length + 1, byArray2, 0, byArray2.length);
                    object = new ECPoint.F2m(this, new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(1, byArray)), new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(1, byArray2)), false);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(object[0], 16));
                }
            }
            return object;
        }

        private ECPoint decompressPoint(byte[] object, int n) {
            ECFieldElement eCFieldElement;
            ECFieldElement.F2m f2m = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(1, (byte[])object));
            object = f2m;
            if (((ECFieldElement)f2m).toBigInteger().equals(ECConstants.ZERO)) {
                eCFieldElement = (ECFieldElement.F2m)this.b;
                for (int i = 0; i < this.m - 1; ++i) {
                    eCFieldElement = ((ECFieldElement)eCFieldElement).square();
                }
            } else {
                ECFieldElement eCFieldElement2 = ((ECFieldElement)object).add(this.a).add(this.b.multiply(((ECFieldElement)object).square().invert()));
                if ((eCFieldElement2 = this.solveQuadradicEquation(eCFieldElement2)) == null) {
                    throw new RuntimeException("Invalid point compression");
                }
                int n2 = 0;
                if (eCFieldElement2.toBigInteger().testBit(0)) {
                    n2 = 1;
                }
                if (n2 != n) {
                    eCFieldElement2 = eCFieldElement2.add(new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ONE));
                }
                eCFieldElement = ((ECFieldElement)object).multiply(eCFieldElement2);
            }
            return new ECPoint.F2m(this, (ECFieldElement)object, eCFieldElement);
        }

        private ECFieldElement solveQuadradicEquation(ECFieldElement eCFieldElement) {
            ECFieldElement.F2m f2m = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ZERO);
            if (eCFieldElement.toBigInteger().equals(ECConstants.ZERO)) {
                return f2m;
            }
            ECFieldElement eCFieldElement2 = null;
            ECFieldElement eCFieldElement3 = null;
            Random random = new Random();
            do {
                eCFieldElement3 = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(this.m, random));
                eCFieldElement2 = f2m;
                ECFieldElement eCFieldElement4 = eCFieldElement;
                for (int i = 1; i <= this.m - 1; ++i) {
                    eCFieldElement4 = eCFieldElement4.square();
                    eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement4.multiply(eCFieldElement3));
                    eCFieldElement4 = eCFieldElement4.add(eCFieldElement);
                }
                if (eCFieldElement4.toBigInteger().equals(ECConstants.ZERO)) continue;
                return null;
            } while (((ECFieldElement)(eCFieldElement3 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement2))).toBigInteger().equals(ECConstants.ZERO));
            return eCFieldElement2;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            object = (F2m)object;
            return this.m == ((F2m)object).m && this.k1 == ((F2m)object).k1 && this.k2 == ((F2m)object).k2 && this.k3 == ((F2m)object).k3 && this.a.equals(((F2m)object).a) && this.b.equals(((F2m)object).b);
        }

        public final int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }

        public final int getM() {
            return this.m;
        }

        public final boolean isTrinomial() {
            return this.k2 == 0 && this.k3 == 0;
        }

        public final int getK1() {
            return this.k1;
        }

        public final int getK2() {
            return this.k2;
        }

        public final int getK3() {
            return this.k3;
        }
    }

    public final class Fp
    extends ECCurve {
        private BigInteger q;
        private ECPoint.Fp infinity;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.q = bigInteger;
            this.a = this.fromBigInteger(bigInteger2);
            this.b = this.fromBigInteger(bigInteger3);
            this.infinity = new ECPoint.Fp(this, null, null);
        }

        public final BigInteger getQ() {
            return this.q;
        }

        @Override
        public final int getFieldSize() {
            return this.q.bitLength();
        }

        private ECFieldElement fromBigInteger(BigInteger bigInteger) {
            return new ECFieldElement.Fp(this.q, bigInteger);
        }

        @Override
        public final ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
            return new ECPoint.Fp(this, this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2), bl);
        }

        @Override
        public final ECPoint decodePoint(byte[] object) {
            switch (object[0]) {
                case 0: {
                    Fp fp = this;
                    object = fp;
                    object = fp.infinity;
                    break;
                }
                case 2: 
                case 3: {
                    int n = object[0] & 1;
                    Object object2 = new byte[((byte[])object).length - 1];
                    System.arraycopy(object, 1, object2, 0, ((byte[])object2).length);
                    ECFieldElement.Fp fp = new ECFieldElement.Fp(this.q, new BigInteger(1, (byte[])object2));
                    object = fp;
                    ECFieldElement eCFieldElement = ((ECFieldElement)fp).multiply(((ECFieldElement)object).square().add(this.a)).add(this.b);
                    object2 = eCFieldElement;
                    ECFieldElement eCFieldElement2 = eCFieldElement.sqrt();
                    object2 = eCFieldElement2;
                    if (eCFieldElement2 == null) {
                        throw new RuntimeException("Invalid point compression");
                    }
                    int n2 = ((ECFieldElement)object2).toBigInteger().testBit(0) ? 1 : 0;
                    if (n2 == n) {
                        object = new ECPoint.Fp(this, (ECFieldElement)object, (ECFieldElement)object2, true);
                        break;
                    }
                    object = new ECPoint.Fp(this, (ECFieldElement)object, new ECFieldElement.Fp(this.q, this.q.subtract(((ECFieldElement)object2).toBigInteger())), true);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    byte[] byArray = new byte[(((byte[])object).length - 1) / 2];
                    byte[] byArray2 = new byte[(((byte[])object).length - 1) / 2];
                    System.arraycopy(object, 1, byArray, 0, byArray.length);
                    System.arraycopy(object, byArray.length + 1, byArray2, 0, byArray2.length);
                    object = new ECPoint.Fp(this, new ECFieldElement.Fp(this.q, new BigInteger(1, byArray)), new ECFieldElement.Fp(this.q, new BigInteger(1, byArray2)));
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid point encoding 0x" + Integer.toString(object[0], 16));
                }
            }
            return object;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            object = (Fp)object;
            return this.q.equals(((Fp)object).q) && this.a.equals(((Fp)object).a) && this.b.equals(((Fp)object).b);
        }

        public final int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.q.hashCode();
        }
    }
}

