/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public final class DERPrintableString
extends ASN1Object
implements DERString {
    private String string;

    public DERPrintableString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        this.string = new String(cArray);
    }

    @Override
    public final String getString() {
        return this.string;
    }

    @Override
    final void encode(DEROutputStream object) throws IOException {
        DEROutputStream dEROutputStream = object;
        object = this;
        char[] cArray = ((DERPrintableString)object).string.toCharArray();
        object = cArray;
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != ((Object)object).length; ++i) {
            byArray[i] = (byte)object[i];
        }
        dEROutputStream.writeEncoded(19, byArray);
    }

    @Override
    public final int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERPrintableString)) {
            return false;
        }
        dERObject = (DERPrintableString)dERObject;
        return this.getString().equals(((DERPrintableString)dERObject).getString());
    }

    public final String toString() {
        return this.string;
    }
}

