/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef NUMBERITEM_H
#define NUMBERITEM_H

class CRotator;

#define NUMBER_ITEM_WIDTH 200
#define SEPARATOR_WIDTH 50
#define NUMBER_ITEM_HEIGHT 200
#define NUMBER_HEIGHT 128
#define NUMBER_WIDTH 100

class CNumberItem : public QGraphicsItem
{
public:
    CNumberItem(CRotator* pRotator, int x, int y, bool bSeparator);
    virtual ~CNumberItem();

    void setPosition(int x, int y);
    void setYAdjustment(int offset);
    void setValue(int value);
    void showBackground(bool bShow);
    int value() { return m_Value; }
    void setReflection(bool bReflection) { m_bReflection = bReflection; update(); }
    void setDimmed(bool bDimmed) { m_bDimmed = bDimmed; update(); }

    QRectF boundingRect() const;
    void paint(QPainter* pPainter, const QStyleOptionGraphicsItem* pOption, QWidget* pWidget);

protected:
    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void mousePressEvent(QGraphicsSceneMouseEvent* pEvent);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* pEvent);

private:
    int m_OrigY;                ///< The y position
    int m_W;                    ///< The width of the item
    int m_H;                    ///< The height if the imem
    bool m_bSeparator;          ///< True if this is a separator
    QPoint m_Offset;            ///< The item's offset relative to origo (when pos = 0,0)
    QPoint m_Position;          ///< The item's position

    int m_Value;                ///< The current value
    bool m_bShowBackground;     ///< True when in edit mode (i.e. the background should be drawn)
    bool m_bReflection;         ///< True when reflection should be painted
    bool m_bDimmed;             ///< True when dimmed numbers should be drawn instead normal ones

    CRotator* m_pRotator;       ///< Pointer to the rotator which owns this
};

#endif // NUMBERITEM_H
