/*
** Copyright (c) 2009  Kimmo 'Rainy' Pekkola
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see http://www.gnu.org/licenses.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include "rotator.h"
#include "custombutton.h"
#include "debugtext.h"

#ifdef Q_WS_HILDON
#include <libosso.h>
#endif

class CMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    CMainWindow(QWidget* pParent = 0);
    ~CMainWindow();

    void intialize();
    void stopUpdates(bool bStop);

public slots:
    void onHoursChanged(int value);
    void onMinutesChanged(int value);
    void onSecondsChanged(int value);
    void onReset();
    void onStart();
    void onTimeout();
    void onAbout();
    void onChooseAlarm();

protected:
    virtual void resizeEvent(QResizeEvent* pEvent);

private:
    void updateValues();
    void enableEditMode(bool bEnable);
    void turnBacklightOn();

    QGraphicsScene* m_pScene;        ///< Pointer to the scene
    QGraphicsView* m_pView;          ///< Pointer to the view

    CRotator* m_pHours;              ///< The rotator for the hours
    CRotator* m_pMinutes;            ///< The rotator for the minutes
    CRotator* m_pSeconds;            ///< The rotator for the seconds

    CCustomButton* m_pButtonStart;     ///< Start/Pause/Resume button
    CCustomButton* m_pButtonReset;     ///< Reset button

    QTimer m_Timer;                  ///< Timer for the count down/up
    int m_CurrentValue;              ///< The current time value in seconds
    bool m_bEditMode;                ///< True if the application is in the edit mode
    bool m_bCountDown;               ///< True if timer counts down
    bool m_bStopUpdates;             ///< If true the backlight is dimmed so no need top update the UI

    QString m_strAlarm;              ///< Sound or file to be executed when counter goes to 0

#ifdef Q_WS_HILDON
    osso_context_t* m_pOssoContext;  ///< The OSSO context for backlight
#endif
};

#endif // MAINWINDOW_H
