function [r] = integ_from_zero_to_T(a, T)
	r = sum(a) * T / length(a);
endfunction

function [r] = fouriercoefs(f, n)
	T = length(f);
	x = 0:T-1;
	
	r = zeros(2, n);

	w = 2 * %pi / T;

	for i = 1:1:n
		r(1, i) = (2 / T) * integ_from_zero_to_T(f .* cos(i * w * x), T);
		r(2, i) = (2 / T) * integ_from_zero_to_T(f .* sin(i * w * x), T);
	end
endfunction

function [y] = fourierrow(x, coefs, fr)
	y = zeros(1, length(x));

	w = fr * 2 * %pi;

	for i = 1:1:size(coefs, 2)
		y = y + coefs(1, i) * cos(i * x * w);
		y = y + coefs(2, i) * sin(i * x * w);
	end
endfunction

//xx = -%pi:0.01:%pi;
w = loadwave("theremin.wav");
//w = sin(xx);
w = w / max(w);
fr = 1/length(w);


coefs = fouriercoefs(w, 2);

//coefs = [0 0; -1 -0.2];

//coefs = [0.178, -0.378, -0.059,  0.204,   0.05, 0.034, -0.018,     0, 0.015, -0.008, 0.002, -0.051,      0, -0.001, 0.005;
//		-0.022,   0.07, -0.017, -0.276, -0.048, 0.134,  0.005, -0.02, 0.007,  -0.04, 0.003,  0.005, -0.003,  -0.01,  0.01];

x = 0:length(w)-1;
y = fourierrow(x, coefs, fr);
plot(x, y, 'b');
plot(x, w, 'r');

longx = 0:100000;
longy = fourierrow(longx, coefs, fr );//110 / 44100);
sound(longy, 44100);
