// (c) Ivan Gagis
// e-mail: igagis@gmail.com
// Version: 1

// Description:
//	Cast server

#include "Cast.hpp"

#include <ting/Timer.hpp>

#include "Client.hpp"


void Cast::PushNewMusicDataPacket(ting::Array<ting::byte> d){
	this->lastChunkArrivalTimeStamp = ting::GetTicks();
	this->bufferedChunk = d;//save the chunk as buffered

	//send the packet to all listeners
	for(
			T_ListenersIter i = this->listeners.begin();
			i != this->listeners.end();
			++i
		)
	{
//		TRACE(<< "Cast::PushNewMusicDataPacket(): sending " << this->bufferedChunk.SizeInBytes() << " bytes" << std::endl)
		(*i)->SendNetworkDataCopy_ts(this->bufferedChunk);
	}
}



void Cast::RemoveListener(ting::Ref<Client>& c){
	for(
			T_ListenersIter i = this->listeners.begin();
			i != this->listeners.end();
			++i
		)
	{
		if(*i == c){
			this->listeners.erase(i);
			break;
		}
	}
}

void Cast::AddListenerAndSendDataToClient(ting::Ref<Client>& c){
	this->listeners.push_back(c);

	c->SendPlayingPlayer(this->GetPlayer()->username);

	//send buffered chunk to client if it is not too old
	if(ting::GetTicks() - this->lastChunkArrivalTimeStamp < 3000){ // 3 seconds
		c->SendNetworkDataCopy_ts(this->bufferedChunk);
	}
}
