// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item
{
    id : checkbox_item
    property    bool    selected : false
    property    int     radius : 360

    Rectangle
    {
        anchors.fill: parent
        radius : checkbox_item.radius
        scale : (checkbox_ma.pressed) ? 0.9 : 1.0
        color : "transparent"
        smooth : true
        border
        {
            width : 3
            color : "grey"
        }
    }
    Rectangle
    {
        id : checkPress
        scale : (checkbox_ma.pressed) ? 0.9 : 1.0
        Behavior on opacity {NumberAnimation {duration : 500}}
        opacity : (checkbox_item.selected) ? 1.0 : 0
        radius : checkbox_item.radius
        color : "green"
        gradient :
            Gradient {
            GradientStop {position : 0.0; color : "#01DF01"}
            GradientStop {position : 1.0; color : "#298A08"}
        }
        smooth : true
        anchors
        {
            fill : parent
            leftMargin : parent.width / 10
            rightMargin : parent.width  / 10
            topMargin : parent.height  / 10
            bottomMargin : parent.height / 10
        }
    }
    MouseArea
    {
        id : checkbox_ma
        anchors.fill: parent
        onClicked:
        {
            checkbox_item.selected = !checkbox_item.selected;
        }
    }
}
