#include "agendalogic.h"
#include <iostream>

int TaskElem::nextId = 0;

TaskElem::TaskElem(QObject *p) : ListItem(p)
{
    this->task_id = TaskElem::nextId++;
}

TaskElem::TaskElem(QString idT, QString name, QString comment,
                    int hoursStart, int minStart,
                    int dayStart, int monthStart, int yearStart,
                    int hoursEnd, int minEnd,
                    int dayEnd, int monthEnd, int yearEnd, int id,
                    QObject *p) : ListItem(p)
{
    if (id == -1)
        this->task_id = TaskElem::nextId++;
    else
        this->task_id = id;
    this->idTime = idT;
    this->task_name = name;
    this->task_comment = comment;

    this->task_start_hour = hoursStart;
    this->task_start_min = minStart;
    this->task_start_day = dayStart;
    this->task_start_month = monthStart;
    this->task_start_year = yearStart;

    this->task_end_hour = hoursEnd;
    this->task_end_min = minEnd;
    this->task_end_day = dayEnd;
    this->task_end_month = monthEnd;
    this->task_end_year = yearEnd;
}

int     TaskElem::id() const
{
    return this->task_id;
}

QString     TaskElem::getIdTime() const
{
    return this->idTime;
}

QString     TaskElem::getTaskName() const
{
    return this->task_name;
}

QString     TaskElem::getTaskComment() const
{
    return this->task_comment;
}

int         TaskElem::getHourStart() const
{
    return this->task_start_hour;
}

int         TaskElem::getMinStart() const
{
    return this->task_start_min;
}

int         TaskElem::getDayStart() const
{
    return this->task_start_day;
}

int         TaskElem::getMonthStart() const
{
    return this->task_start_month;
}

int         TaskElem::getYearStart() const
{
    return this->task_start_year;
}

int         TaskElem::getHourEnd() const
{
    return this->task_end_hour;
}

int         TaskElem::getMinEnd() const
{
    return this->task_end_min;
}

int         TaskElem::getDayEnd() const
{
    return this->task_end_day;
}

int         TaskElem::getMonthEnd() const
{
    return this->task_end_month;
}

int         TaskElem::getYearEnd() const
{
    return this->task_end_year;
}

void        TaskElem::setHourStart(int a)
{
    this->task_start_hour = a;
}

void        TaskElem::setHourEnd(int a)
{
    this->task_end_hour = a;
}

void        TaskElem::setMinStart(int a)
{
    this->task_start_min = a;
}

void        TaskElem::setMinEnd(int a)
{
    this->task_end_min = a;
}

void        TaskElem::setDayStart(int a)
{
    this->task_start_day = a;
}

void        TaskElem::setDayEnd(int a)
{
    this->task_end_day = a;
}

void        TaskElem::setMonthStart(int a)
{
    this->task_start_month = a;
}

void        TaskElem::setMonthEnd(int a)
{
    this->task_end_month = a;
}

void        TaskElem::setYearStart(int a)
{
    this->task_start_year = a;
}

void        TaskElem::setYearEnd(int a)
{
    this->task_end_year = a;
}

void        TaskElem::setTaskName(QString a)
{
    this->task_name = a;
}

void        TaskElem::setComment(QString a)
{
    this->task_comment = a;
}

QVariant    TaskElem::data(int role) const
{
    switch (role)
    {
    case taskName :
        return this->getTaskName();
    case taskComment :
        return this->getTaskComment();
    case taskStartHour :
        return this->getHourStart();
    case taskStartDay :
        return this->getDayStart();
    case taskStartMonth :
        return this->getMonthStart();
    case taskStartYear :
        return this->getYearStart();
    case taskStartMin :
        return this->getMinStart();
    case taskEndHour :
        return this->getHourEnd();
    case taskEndMin :
        return this->getMinEnd();
    case taskEndDay :
        return this->getDayEnd();
    case taskEndMonth :
        return this->getMonthEnd();
    case taskEndYear :
        return this->getYearEnd();
    case taskId :
        return this->id();
    default :
        return QVariant();
    }
}

QHash<int, QByteArray> TaskElem::roleNames() const
{
    QHash<int, QByteArray>  roles;
    roles[taskName] = "taskName";
    roles[taskStartHour] = "taskStartHour";
    roles[taskStartMin] = "taskStartMin";
    roles[taskStartDay] = "taskStartDay";
    roles[taskStartMonth] = "taskStartMonth";
    roles[taskStartYear] = "taskStartYear";
    roles[taskEndHour] = "taskEndHour";
    roles[taskEndMin] = "taskEndMin";
    roles[taskEndDay] = "taskEndDay";
    roles[taskEndMonth] = "taskEndMonth";
    roles[taskEndYear] = "taskEndYear";
    roles[taskComment] = "taskComment";
    roles[taskId] = "taskId";
    return roles;
}


AgendaLogic::AgendaLogic() : QObject()
{
    this->taskModel = new ListModel(new TaskElem()); // MODEL CONTAINING ALL TASK FOR ALL TIMES
    this->curDayTaskModel = new ListModel(new TaskElem()); // MODEL CONTAINING TASK FOR THE CURRENT DAY
    this->curWeekTaskModel = new ListModel(new TaskElem()); // MODEL FOR TASK OF CURRENT WEEK
    this->curDate = QDate::currentDate();
}

ListModel * AgendaLogic::getCurTaskModel()
{
    this->updateDayModel();
    this->updateWeekModel();
    return this->curDayTaskModel;
}

ListModel * AgendaLogic::getCurWeekTaskModel()
{
    this->updateDayModel();
    this->updateWeekModel();
    return this->curWeekTaskModel;
}

void        AgendaLogic::updateDayModel()
{
    this->curDayTaskModel->removeRows(0, this->curDayTaskModel->rowCount());
    QList<ListItem *> list = this->taskModel->getModelList();
    foreach(ListItem *e, list)
    {
        TaskElem *t = (TaskElem*)e;
        QDate tmps(t->getYearStart(), t->getMonthStart(), t->getDayStart());
        QDate tmpe(t->getYearEnd(), t->getMonthEnd(), t->getDayEnd());
        if (tmps <= this->curDate && tmpe >= this->curDate)
        {
            this->curDayTaskModel->appendRow(new TaskElem(t->getIdTime(), t->getTaskName(), t->getTaskComment(),
                                                          t->getHourStart(), t->getMinStart(),
                                                          t->getDayStart(), t->getMonthStart(), t->getYearStart(),
                                                          t->getHourEnd(), t->getMonthEnd(),
                                                          t->getDayEnd(), t->getMonthEnd(), t->getYearEnd(), t->id()));
        }
    }
}

void    AgendaLogic::updateWeekModel()
{
    this->curWeekTaskModel->removeRows(0, this->curWeekTaskModel->rowCount());
    QList<ListItem *> list = this->taskModel->getModelList();
    foreach(ListItem *e, list)
    {
        TaskElem *t = (TaskElem*)e;
        QDate tmps(t->getYearStart(), t->getMonthStart(), t->getDayStart());
        QDate tmpe(t->getYearEnd(), t->getMonthEnd(), t->getDayEnd());

        QDate begDate = this->curDate;
        QDate endDate = this->curDate;
        begDate.addDays(1 - this->curDate.dayOfWeek());
        endDate.addDays(7 - this->curDate.dayOfWeek());
        if (tmps <= begDate && tmpe >= endDate)
        {
            this->curWeekTaskModel->appendRow(new TaskElem(t->getIdTime(), t->getTaskName(), t->getTaskComment(),
                                                          t->getHourStart(), t->getMinStart(),
                                                          t->getDayStart(), t->getMonthStart(), t->getYearStart(),
                                                          t->getHourEnd(), t->getMonthEnd(),
                                                          t->getDayEnd(), t->getMonthEnd(), t->getYearEnd(), t->id()));
        }
    }
}

void    AgendaLogic::loadTasksFromDB()
{
    QString query = "SELECT * FROM agenda";
    emit(SendQueryAgenda(query, ASKTASK));
}

void    AgendaLogic::removeTask(int taskId)
{
    ListItem *c = this->taskModel->find(taskId);
    std::cout << "REMOVING -------------------" << std::endl;
    if (c == NULL)
        return ;
    int row = this->taskModel->getRowFromItem(c);
    std::cout << "REMOVING -------------------" << std::endl;
    if (row > -1)
    {
        std::cout << "REMOVING -------------------" << std::endl;
        TaskElem *T = (TaskElem *)c;
        QString query = "UPDATE agenda SET status =";
        query += QString::number(DEL);
        query += ", lastup ='";
        query +=  QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "' WHERE id = '";
        query += T->getIdTime();
        query += "'";
        emit(SendQueryAgenda(query, SETTASK));
        this->taskModel->removeRow(row);
        this->updateDayModel();
        this->updateWeekModel();
    }
}

void        AgendaLogic::setTaskModelDate(int d, int m, int y)
{
    this->curDate.setDate(y, m, d);
    this->updateDayModel();
    this->updateWeekModel();
}

void        AgendaLogic::addTask(QString t, QString c, int hs, int ms, int ds, int mts, int ys, int he, int me, int de, int mte, int ye)
{
    QString curDateTime = QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
    this->taskModel->appendRow(new TaskElem(curDateTime, t, c, hs, ms, ds, mts, ys, he, me, de, mte, ye));
    this->updateDayModel();
    this->updateWeekModel();

    QDateTime   start;
    start.setDate(QDate(ys, mts, ds));
    start.setTime(QTime(hs, ms));
    QDateTime   end;
    end.setDate(QDate(ye, mte, de));
    end.setTime(QTime(he, me));

    QString query;
    query = "INSERT INTO agenda (id, lastup, taskName, taskComment, taskStartDate, taskEndDate, status) VALUES('";
    query += curDateTime;
    query += "', '";
    query += curDateTime;
    query += "', '";
    query += t;
    query += "', '";
    query += c;
    query += "', '";
    query += start.toString("hh.mm.dd.MM.yyyy");
    query += "', '";
    query += end.toString("hh.mm.dd.MM.yyyy");
    query += "', ";
    query += QString::number(MODIF);
    query += ");";
    emit(SendQueryAgenda(query, SETTASK));
}

void        AgendaLogic::editTask(QString t, QString c, int hs, int ms, int ds, int mts, int ys, int he, int me, int de, int mte, int ye, int id)
{
    TaskElem *T = (TaskElem *)this->taskModel->find(id);
    if (T != NULL)
    {
        QDateTime   start;
        start.setDate(QDate(ys, mts, ds));
        start.setTime(QTime(hs, ms));
        QDateTime   end;
        end.setDate(QDate(ye, mte, de));
        end.setTime(QTime(he, me));
        std::cout << "----------------------------------------------EDIT------------------------------------------------" << std::endl;
        QString query = "UPDATE agenda SET taskName ='";
        query += t;
        query += "', taskComment = '";
        query += c;
        query += "', lastup = '";
        query +=  QDateTime::currentDateTime().toString("dd.MM.yyyy.hh.mm.ss.zzz");
        query += "', taskStartDate = '";
        query += start.toString("hh.mm.dd.MM.yyyy");
        query += "', taskEndDate = '";
        query += end.toString("hh.mm.dd.MM.yyyy");
        query += "', status = ";
        query += QString::number(MODIF);
        query += " WHERE id = '";
        query += T->getIdTime();
        query += "' AND status != ";
        query += QString::number(DEL);

        T->setComment(c);
        T->setTaskName(t);
        T->setHourStart(hs);
        T->setMinStart(ms);
        T->setDayStart(ds);
        T->setMonthStart(mts);
        T->setYearStart(ys);
        T->setHourEnd(he);
        T->setMinEnd(me);
        T->setDayEnd(de);
        T->setMonthEnd(mte);
        T->setYearEnd(ye);
        this->taskModel->updateModelFromElem(T);
        this->updateDayModel();
        this->updateWeekModel();
        emit(SendQueryAgenda(query, SETTASK));
    }
}

void        AgendaLogic::rcvTask(QList<QSqlRecord> t, int id)
{
    if (id == ASKTASK)
    {
        QList<QSqlRecord>::iterator it = t.begin();
        ++it;
        std::cout << "IN RCV TASK" << std::endl;
        this->taskModel->removeRows(0, this->taskModel->rowCount());
        while (it != t.end())
        {
            if ((*it).value("status").toInt() != DEL)
            {
                std::cout << (*it).value("taskName").toString().toStdString() << std::endl;
                std::cout << "RESTORING TASK" << std::endl;

                QDateTime start = QDateTime::fromString((*it).value("taskStartDate").toString(), "hh.mm.dd.MM.yyyy");
                QDateTime end = QDateTime::fromString((*it).value("taskEndDate").toString(), "hh.mm.dd.MM.yyyy");

                this->taskModel->appendRow(new TaskElem((*it).value("id").toString(), (*it).value("taskName").toString(), (*it).value("taskComment").toString(),
                                                        start.time().hour(), start.time().minute(),
                                                        start.date().day(), start.date().month(), start.date().year(),
                                                        end.time().hour(),  end.time().minute(),
                                                        end.date().day(), end.date().month(), end.date().year()));
            }
            ++it;
        }
    }
}
