import QtQuick 1.1
// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5

Rectangle
{
    property bool   selectedButton
    property string highLightColor : "#0099CC"
    property string highLightColor2 : "#000066"
    property color  elemBackColor : "black";
    property real   elemBackOpacity : 0.4
    property string backgroundImg : (apCtrl.getBackGround() === "") ? "Buttons/loading_wallpaper.jpg" : apCtrl.getBackGround()
    property real   xBeg
    property int    mobileRes : (main_win_rec.width >= 1280) ? 139 : (main_win_rec.width >= 800) ? 80 : 60
    property int    textSize :  (mobileRes == 139) ? 15 : (mobileRes == 80) ? 12 : 4
//    property int    textSize :  (mobileRes == 139) ? 7 : (mobileRes == 80) ? 5 : 4 //ANDROID
    property string screenSize : (mobileRes == 139) ? "large" : (mobileRes == 80) ? "medium" : "small";
    property real   syncProg : 1.0;


    id: background_rect
    color: "#ffffff"
    anchors.fill: parent
    onBackgroundImgChanged:
    {
        console.log("IMG CHANGED");
        background_animation.running = true;
    }

    SequentialAnimation
    {
        id : background_animation
        running : false;
        NumberAnimation { target: background_trans_rec; property: "opacity"; to : 1; duration: 1000; easing.type: Easing.InOutQuad }
        NumberAnimation { target: background_trans_rec; property: "opacity"; to : 0; duration: 1000; easing.type: Easing.InOutQuad }
    }

    function    synchingProgress(progress)
    {
        syncProg = progress;
    }

    Gradient
    {
        id : blue_black_grad
        GradientStop {position : 0.0; color : "#000033"}
        GradientStop {position : 1.0; color : "black"}
    }

    Gradient
    {
        id : qt_green_grad
        GradientStop {position : 0.0; color : "#01DF01"}
        GradientStop {position : 1.0; color : "#298A08"}
    }

    Gradient
    {
        id : highlight_grad
        GradientStop {position : 0.0; color : tepee.highLightColor}
        GradientStop {position : 1.0; color : tepee.highLightColor2}
    }


    function changeDesktopFlip(direction)
    {
        if (direction == "right")
            bar.changeSelectedRight();
        else if (direction == "left")
            bar.changeSelectedLeft();
    }

    function clearSelection()
    {
        bar.clearSelected();
    }

    function checkLoadedSettingsMenu()
    {
        if (menu_settings.status != Loader.Ready)
            menu_settings.source = "register.qml"
    }


    MouseArea
    {
        id : flick_screen
        anchors.fill : parent;
        onPressed : {xBeg = flick_screen.mouseX;}
        onReleased :
        {
            if (Math.abs(xBeg - flick_screen.mouseX) >= 200)
            {
                if (xBeg > flick_screen.mouseX)
                    tepee.changeDesktopFlip("right")
                else if (xBeg < flick_screen.mouseX)
                    tepee.changeDesktopFlip("left");
            }
        }
        onPressAndHold:
        {
            clearSelection();
            tepee.state = "Home View";
            if (home_view.status != Loader.Ready)
                home_view.source = "HomeView.qml"
        }
    }


    Image
    {
        // property string resBackground : setWallName(main_win_rec.width);
        id: background_img
        source: backgroundImg
        fillMode: Image.PreserveAspectCrop
        anchors.fill: parent
    }

    Rectangle
    {
        id : background_trans_rec
        anchors.fill: parent
        color : "black"
        opacity : 1
    }

    ButtonBar
    {
        id : bar
        mobileView : mobileRes
    }


    TimeBar
    {
        id : timeb
        mobileView : mobileRes
    }

    Loader
    {
        id : home_view
        opacity : 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id : menu_settings
        opacity : 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id : main_note;
        opacity: 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id : event_win;
        opacity: 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id : main_fileftp;
        opacity: 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id : contact_win
        opacity : 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id : main_bookmarks
        onLoaded: console.log("LOADED LOADER");
        onStatusChanged: console.log(main_bookmarks.status)
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    Loader
    {
        id  : agenda_win
        opacity : 0
        Behavior on opacity {NumberAnimation {duration : 500}}
    }


    Loader
    {
        id : weather_win
        opacity : 0;
        Behavior on opacity {NumberAnimation {duration : 500}}
    }

    states :      //DO NOT FORGET TO SET OTHER STATES OPACITY TO 0
                  [
        State
        {
            name : "Notes State"
            PropertyChanges {target : main_note; opacity : 1}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Files State"
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 1}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Contacts State"
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 1}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "BookMarks State"
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 1}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Agenda State"
            PropertyChanges {target : agenda_win; opacity : 1}
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Weather State"
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 1}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Setting State"
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 1}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Event State"
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 1}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
            PropertyChanges {target : home_view; opacity : 0}
        },
        State
        {
            name : "Home View"
            PropertyChanges {target : home_view; opacity : 1}
            PropertyChanges {target : main_note; opacity : 0}
            PropertyChanges {target : event_win; opacity : 0}
            PropertyChanges {target : menu_settings; opacity : 0}
            PropertyChanges {target : main_bookmarks; opacity : 0}
            PropertyChanges {target : weather_win; opacity : 0}
            PropertyChanges {target : agenda_win; opacity : 0}
            PropertyChanges {target : contact_win; opacity : 0}
            PropertyChanges {target : main_fileftp; opacity : 0}
        }

    ]
}
