// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Item
{
    id  : sync_data_item
    width : main_win_rec.width - (2 * tepee.mobileRes)
    height : main_win_rec.height - (2 * tepee.mobileRes)
    x : 0
    y : 0

    Rectangle
    {
        anchors.fill : parent
        radius : 45
        border
        {
            color : "grey"
            width : 1
        }
        color : tepee.elemBackColor
        opacity : tepee.elemBackOpacity
        gradient :
            Gradient {
            GradientStop {position : 0.0; color : tepee.highLightColor}
            GradientStop {position : 1.0; color : tepee.highLightColor2}
        }
    }
    ListView
    {
        id : sync_view
        clip : true
        spacing : 2
        delegate: sync_del
        anchors
        {
            fill : parent
            margins : tepee.mobileRes / 2
        }
    }

    Component
    {
        id : sync_del
        Item
        {
            id : sync_item
            width : sync_view.width
            height : tepee.mobileRes
            Rectangle
            {
                anchors.fill: parent
                color : "red"
            }
            MouseArea
            {
                anchors.fill: parent
            }
        }
    }
}
