#include "thumbnailjob.h"
#include <iostream>

thumbnailJob::thumbnailJob(QUrl url, QObject *parent) :
    QObject(parent)
{
    this->curUrl = url;
    this->curState = Queued;
    this->netPage = NULL;
}

thumbnailJob::~thumbnailJob()
{
    delete this->netPage;
}

QUrl        thumbnailJob::getUrl() const
{
    return this->curUrl;
}

const QPixmap&     thumbnailJob::getPixmap() const
{
        return this->pixImg;
}

int         thumbnailJob::getState() const
{
    return this->curState;
}

void        thumbnailJob::startJob(int width, int height)
{
    this->netPage = new QWebPage;
    QWebSettings * settings = this->netPage->settings();
    settings->setAttribute(QWebSettings::AutoLoadImages, true);
    settings->setAttribute(QWebSettings::JavascriptEnabled, false);
    settings->setAttribute(QWebSettings::PluginsEnabled, false);
    settings->setAttribute(QWebSettings::JavaEnabled, false);
    settings->setAttribute(QWebSettings::DeveloperExtrasEnabled, false);
    settings->setAttribute(QWebSettings::OfflineStorageDatabaseEnabled, false);
    settings->setAttribute(QWebSettings::OfflineWebApplicationCacheEnabled, false);
    settings->setAttribute(QWebSettings::LocalStorageDatabaseEnabled, false);

    this->netPage->mainFrame()->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOff);
    this->netPage->mainFrame()->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOff);
    this->netPage->mainFrame()->setZoomFactor( 0.5 );
    this->netPage->setViewportSize(QSize(width, height));

    connect(this->netPage, SIGNAL(loadStarted()), this, SIGNAL(started()));
    connect(this->netPage, SIGNAL(loadProgress(int)), this, SIGNAL(progress(int)));
    connect(this->netPage, SIGNAL(loadFinished(bool)), this, SLOT(pageLoadFinished(bool)));

    this->netPage->mainFrame()->load(this->curUrl);
}

void        thumbnailJob::pageLoadFinished(bool ok)
{
    if (ok)
    {
        this->curState = Loaded;
        QImage  img(QSize(256, 256), QImage::Format_ARGB32_Premultiplied);
        QPainter paint(&img);
        paint.setRenderHint(QPainter::Antialiasing, true);
        paint.setRenderHint(QPainter::TextAntialiasing, true);
        paint.setRenderHint(QPainter::SmoothPixmapTransform, true);
        this->netPage->mainFrame()->render(&paint, QRegion(0, 0, 256, 256));
        paint.end();

        this->pixImg = QPixmap::fromImage(img);
        emit (finished(this->pixImg));
    }
    else
    {
        this->curState = Error;
        emit (error());
    }
    this->netPage->deleteLater();
//    delete this->netPage;
    this->netPage = NULL;
    emit (jobDone(this));
}
