#ifndef CONNECTIONTHREAD_H
#define CONNECTIONTHREAD_H

#include <QThread>
#include <QObject>
#include "connection.h"
#include "manage.h"
#include "Command.h"
#include "managecommand.h"

class ConnectionThread : public QThread
{
    Q_OBJECT
signals :

    void        connectToServer(QString, int);
    void        sendData(unsigned char *, int len);
    void        queryBM(QString , int);
    void        retQueryBm(QList<QSqlRecord>,int);

    void        socketConnected();
    void        socketDisconnected();
    void        AuthOnServer(QString, QString);
    void        synchingProgress(QVariant);

public:
    ConnectionThread();
    ~ConnectionThread();

    void        run();
    void        initSyncServer(QString, int, QString, QString);

private slots :

//    void        sendAuthOnConnect();
    void        connectionDisconnected();
    void        connectionConnected();

private :
    QString                  user;
    QString                  pass;
    QList<Command *>         inCommands;
    QList<Command *>         outCommands;
};

#endif // CONNECTIONTHREAD_H
