 import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
//import QtQuick 1.1
import Qt.labs.folderlistmodel 1.0

Item
{
    property string selectedNameAction
    property int mobileView : tepee.mobileRes
    property string backGroundPath : tepee.backgroundImg;
    property string filenameselectme
    property string fileidselectme
    width: main_win_rec.width - (2 * mobileView)
    height: main_win_rec.height -(2 * mobileView)
    y : mobileView
    x : mobileView

    Item
    {
        id : connectFTP
        opacity: 1
        anchors.fill: parent
        Behavior on opacity {NumberAnimation {duration : 500}}

        Button
        {
            id : connectButtomFtp; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            text: "Connect";
            resImg: mobileView;
            clickActionState: ""
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            onButtonClicked:
            {
                console.log("Connect PRESSED");
                apCtrl.connectToFtp();
                connectFTP.opacity = 0;
                ftpmenu.opacity = 1;
            }
            opacity : 1
        }
    }
    Item
    {
        Behavior on opacity {NumberAnimation {duration : 500}}
        anchors.fill : parent
        id : ftpmenu
        opacity : 0
        Rectangle
        {
            id : titleonlinefile
            y :  mobileView / 4

            color : "grey"
            radius : 20
            width : 2 * mobileView
            height: mobileView / 3
            opacity : 0.40
            anchors.left : parent.left
            anchors.leftMargin: -mobileView / 2
            anchors.right: parent.horizontalCenter
            Text
            {
                text: "Online"
                color : "white";
                font.pointSize: tepee.textSize
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
            }
        }
        Rectangle
        {
            id : contentfilercv

            width: main_win_rec.width / 3 + mobileView
            height: main_win_rec.height / 2
            color : "grey"
            anchors.top : titleonlinefile.bottom
            anchors.topMargin: mobileView / 4
            anchors.left: parent.left
            anchors.leftMargin: -mobileView / 2
            anchors.right: parent.horizontalCenter

             radius : 20
            opacity: 0.4
            Text
            {
                id : waitLoading1
                text : "Loading ..."
                color : "white"
                font.pointSize: tepee.textSize
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
                opacity : 1
            }
            Image
            {
                anchors.centerIn: parent
                width : tepee.mobileRes
                height : width
                id: waitLoading
                source: "ui_svg/busy.svg";
                visible: true
                smooth: true
                sourceSize.width: parent.width
                sourceSize.height: parent.height
                NumberAnimation on rotation
                {
                    running: true; from: 0; to: 360; loops: Animation.Infinite; duration: 1200
                }
            }
            ListView
            {
                id : file_view
                anchors.fill: parent
                model : fileftpModel
                interactive: true
                orientation : ListView.Vertical
                spacing : 5
                clip : true
                delegate: fileftp_del
            }
            Component
            {
                id : fileftp_del
                Item
                {
                    id : file_selct_item
                    property bool current: ListView.isCurrentItem
                    width: 5 * (mobileView)
                    height:  (mobileView) / 2
                    scale : del_fileftp_ma.pressed ? 0.9 : 1.0
                    onCurrentChanged:{
                        if (current)
                        {
                            waitLoading.opacity = 0
                            waitLoading1.opacity = 0

                            filenameselectme = namefile
                            fileidselectme = filercvId
                        }
                    }

                    Rectangle
                    {
                        id : rect_content_del
                        color : "transparent"
                        anchors.fill: parent
                        Rectangle
                        {
                            anchors.fill : parent;
                            radius : 10
                            smooth : true
                            color: file_selct_item.ListView.isCurrentItem ? "white" : "black"
                            border.color : "grey"
                            border.width : 2
                        }
                        Text
                        {
                            id : descriptionfile
                            anchors.top: parent.top
                            anchors.topMargin: 5
                            anchors.horizontalCenter: parent.horizontalCenter
                            text: namefile
                            color : "white";
                            font.pointSize: tepee.textSize
                        }
                        Text
                        {
                            id : descriptionsizefile
                            anchors.top:descriptionfile.bottom
                            anchors.topMargin: 1
                            anchors.left : rect_content_del.left
                            anchors.leftMargin: mobileView / 2
                            text:  sizefile + " Ko"
                            color : "white";
                            font.pointSize: tepee.textSize
                        }
                        Text
                        {
                            id : descriptionlufile
                            anchors.top:descriptionfile.bottom
                            anchors.topMargin: 1
                            anchors.right : rect_content_del.right
                            anchors.rightMargin: mobileView / 2
                            text:  lu
                            color : "white";
                            font.pointSize:tepee.textSize
                        }
                        MouseArea
                        {
                            id : del_fileftp_ma
                            anchors.fill: parent
                            onClicked:
                            {
                                file_view.currentIndex = index;
                            }
                            onDoubleClicked:
                            {
                                file_view.currentIndex = index;
                                apCtrl.dowloadFile(filenameselectme);
                                dowloadpage.opacity = 1;
                                ftpmenu.opacity = 0;
                                timedowload.running = true;
                                openButtomFtp.ok = false;
                                backButtomFtp.ok = false;
                            }
                            onPressAndHold:
                            {
                                file_view.currentIndex = index;
                                apCtrl.delFile(filenameselectme, fileidselectme);
                            }
                        }
                    }
                }
            }
        }
        Rectangle
        {
            id : titlelocalfile
            y :  mobileView/ 4
            color : "grey"
            radius : 20
            width : 2 * mobileView
            height: mobileView / 3
            opacity : 0.40
            anchors.right: parent.right
              anchors.rightMargin: - mobileView / 2
            anchors.left: parent.horizontalCenter
            //anchors.rightMargin: main_win_rec.width / 3
           // anchors.horizontalCenter: parent.horizontalCenter
            //anchors.top: contentfilercv.bottom
            anchors.topMargin: mobileView / 4
            Text
            {
                text: "Local"
                color : "white";
                font.pointSize: tepee.textSize
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
            }
        }
        Rectangle
        {
            id : contentfilelocal
            anchors.top:titlelocalfile.bottom
            anchors.topMargin: mobileView / 4
//            width: (main_win_rec.width - (2 * mobileView)) / 2
//            height: (main_win_rec.height -(2 * mobileView)) / 3
            anchors.right: parent.right
            anchors.left: parent.horizontalCenter
            anchors.rightMargin: - mobileView / 2
            width: main_win_rec.width / 3 + mobileView
            height: main_win_rec.height / 2
            color : "grey"
            opacity: 0.40
            radius : 20
            BrowserLoader
            {
                id : fileBackSelectLoader
                filename_loader : "file:///" + apCtrl.getDirFtp();
                //filterSearch_loader: ["*.png", "*.jpg"];
                source : "FileBrowserFtp.qml"
                anchors.fill: parent;
                cellHeight: (mobileView) / 2
                width: 2 * mobileView
                height : 2
                Behavior on opacity {NumberAnimation {duration : 500}}
                opacity: 1
                showPic : false
                onSelectedNameChanged:
                {
                    console.log("CHANGE DE FENETRE " + selectedName);
                    selectedNameAction = selectedName;
                    ftpmenu.opacity = 0;
                    selectFileAction.opacity = 1;

                }
            }
        }
    }
    Item {
        id: dowloadpage
        opacity :0
        anchors.fill: parent
        Behavior on opacity {NumberAnimation {duration : 500}}

        Rectangle
        {
            id : totalbar
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            width : 5 * mobileView
            height :mobileView / 2
            radius: 8
            color : "black"
            opacity : 0.40
        }
        Rectangle
        {
            id : donebar
            anchors.top: totalbar.top
            anchors.left : totalbar.left
            height : mobileView / 2
            clip: true
            width : 0
            color : "green"
            border.color: "transparent"
            border.width : 1
            Behavior on width {
                SmoothedAnimation {
                    velocity: 1200
                }
            }
            opacity : 1
        }
        Text
        {
            id : textload
            opacity : 1
            color : "white"
            anchors.horizontalCenter: parent.horizontalCenter;
            anchors.verticalCenter: parent.verticalCenter;
            text : "BEGIN"
            font.pointSize: tepee.textSize
        }

        Timer {
            id : timedowload
            interval: 100; running: true; repeat: true
            onTriggered:
            {
                textload.text = Math.floor(((100* apCtrl.getDone()) / apCtrl.getTotal())) + " %";
                if (textload.text == "100 %")
                {
                    console.log("DOWLOAD END");
                    timedowload.running = false;
                    openButtomFtp.opacity = 1;
                    backButtomFtp.opacity = 1;
                    openButtomFtp.ok = true;
                    backButtomFtp.ok = true;
                }

                donebar.width = ((5 * mobileView* apCtrl.getDone()) / apCtrl.getTotal());
            }
        }
        Button
        {
            property bool ok : false;
            id : openButtomFtp; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            text: "Open";
            resImg: mobileView;
            clickActionState: ""
            anchors.top : donebar.bottom
            anchors.topMargin: mobileView
            anchors.right: totalbar.right
            anchors.rightMargin: mobileView
            onButtonClicked:
            {
                if (ok)
                {
                    console.log("open PRESSED --- " + apCtrl.getDirFtp() + filenameselectme);
                    //Qt.openUrlExternally(filenameselectme);
                    apCtrl.openFile( "file:///" + apCtrl.getDirFtp() + filenameselectme);
                }
            }
            opacity : 0.40
        }
        Button
        {
            property bool ok : false;
            id : backButtomFtp; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            text: "Back";
            resImg: mobileView;
            clickActionState: ""
            anchors.top : donebar.bottom
            anchors.topMargin: mobileView
            anchors.left: totalbar.left
            anchors.leftMargin: mobileView
            onButtonClicked:
            {
                if (ok)
                {
                    console.log("back PRESSED");
                    dowloadpage.opacity = 0;
                    ftpmenu.opacity = 1;
                    apCtrl.setDone(0);
                    apCtrl.setTotal(999);
                    donebar.width = 0;
                    openButtomFtp.opacity = 0.40;
                    backButtomFtp.opacity = 0.40;
                    fileBackSelectLoader.source = ""
                    fileBackSelectLoader.source = "FileBrowserFtp.qml"
                }
            }
            opacity : 0.40
        }
    }
    Item
    {

        id : selectFileAction
        Behavior on opacity {NumberAnimation {duration : 500}}
        anchors.fill : parent
        opacity : 0
        Rectangle
        {
            id : contentaction
            y :  mobileView/ 4
            color : "grey"
            radius : 20
            width : 5 * mobileView
            height: mobileView * 2
            opacity : 0.40
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
        }
        Button
        {
            id : backButtomselect; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            anchors.verticalCenter: contentaction.verticalCenter
            anchors.left: contentaction.left
            anchors.leftMargin: mobileView / 2
            text: "Back";
            resImg: mobileView;
            clickActionState: ""
            onButtonClicked:
            {
                selectFileAction.opacity = 0;
                ftpmenu.opacity = 1;
            }
            opacity : 1
        }
        Button
        {
            id : uploadButtomselect; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            anchors.verticalCenter: contentaction.verticalCenter
            anchors.horizontalCenter: contentaction.horizontalCenter
            text: "Upload";
            resImg: mobileView;
            clickActionState: ""
            onButtonClicked:
            {
                selectFileAction.opacity = 0;
                uploadpage.opacity = 1;
                apCtrl.uploadFile(selectedNameAction);
                timedowloadup.running = true
            }
            opacity : 1
        }
        Button
        {
            id : openButtomselect; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            anchors.verticalCenter: contentaction.verticalCenter
            anchors.right: contentaction.right
            anchors.rightMargin: mobileView / 2
            text: "Open";
            resImg: mobileView;
            clickActionState: ""
            onButtonClicked:
            {
                apCtrl.openFile(selectedNameAction);
            }
            opacity : 1
        }

    }
    Item {
        id: uploadpage
        opacity :0
        anchors.fill: parent
        Behavior on opacity {NumberAnimation {duration : 500}}

        Rectangle
        {
            id : totalbarup
            anchors.verticalCenter: parent.verticalCenter
            anchors.horizontalCenter: parent.horizontalCenter
            width : 5 * mobileView
            height :mobileView / 2
            radius: 8
            color : "black"
            opacity : 0.40
        }
        Rectangle
        {
            id : donebarup
            anchors.top: totalbarup.top
            anchors.left : totalbarup.left
            height : mobileView / 2
            clip: true
            width : 0
            color : "green"
            border.color: "transparent"
            border.width : 1
            Behavior on width {
                SmoothedAnimation {
                    velocity: 1200
                }
            }
            opacity : 1
        }
        Text
        {
            id : textloadup
            opacity : 1
            color : "white"
            anchors.horizontalCenter: parent.horizontalCenter;
            anchors.verticalCenter: parent.verticalCenter;
            text : "BEGIN"
            font.pointSize:tepee.textSize
        }

        Timer {
            id : timedowloadup
            interval: 100; running: true; repeat: true
            onTriggered:
            {
                textloadup.text = Math.floor(((100* apCtrl.getDone()) / apCtrl.getTotal())) + " %";
                if (textloadup.text == "100 %")
                {
                    console.log("UPLOAD END");
                    timedowloadup.running = false;
                    okButtomFtpup.opacity = 1;
                    okButtomFtpup.ok = true
                }

                donebarup.width = ((5 * mobileView* apCtrl.getDone()) / apCtrl.getTotal());
            }
        }
        Button
        {
            property bool ok : false;
            id : okButtomFtpup; buttonColor: "green"; buttonShape: "round"
            numId: 1;
            text: "OK";
            resImg: mobileView;
            clickActionState: ""
            anchors.top : donebarup.bottom
            anchors.topMargin: mobileView
            anchors.horizontalCenter: parent.horizontalCenter
            onButtonClicked:
            {
                if (ok)
                {
                    apCtrl.listFile();
                    waitLoading.opacity = 1
                    waitLoading1.opacity = 1
                    ftpmenu.opacity = 1;
                    uploadpage.opacity = 0;
                    apCtrl.setDone(0);
                    apCtrl.setTotal(999);
                    donebarup.width = 0;
                }
            }
            opacity : 0.40
        }
    }
}


