# -*- coding: utf-8 -*-
'''
Task Poach - Strives to be a Task Coach compatible TODO app.
Copyright (C) 2012 computerinfo21@gmail.com>

Task Poach is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Task Poach is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''
"""
Module implementing taskProperties.
"""

from PyQt4.QtGui import QMainWindow
from PyQt4 import QtCore
from PyQt4.QtCore import pyqtSignature, QDate, QTime
from PyQt4.QtGui import * 
from PyQt4.QtCore import *
from xml.etree.ElementTree import *
from Ui_taskProperties import Ui_taskProperties
from thirdparty import relativedelta
from thirdparty import parser
from datetime import date
import time

global selection, maemo5
global EXPANDALL
global COLORCOMPLETED, ICONCOMPLETED, COLOROVERDUE, ICONOVERDUE, COLORDUESOON, ICONDUESOON, COLORACTIVE, COLORACTIVEMAEMO, ICONACTIVE

class taskProperties(QMainWindow, Ui_taskProperties):
    """
    Class documentation goes here.
    """
    def __init__(self, parent,  task = None, qSITask = None, parentTask = None, etree = None, taskModel = None, qSIRow = None, categoryModel = None, settings=None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        
        #Don't have these settings yet, so just hiding them
        self.label_5.hide()
        self.comboBox_3.hide()
        
        
        QApplication.desktop().resized.connect(self.on_desktop_resized)
        #Ui_taskProperties.__init__(self, parent)
        
        #Cannot initialize a QPaintDevice before an application exists, so setting global variable values here
        self.settings = settings
        self.loadSettings()
        
        
        #Set up maemo5 global, it is not shared correctly between this and the main window
        global maemo5
        maemo5 = parent.maemo5()
        
        global EXPANDALL
        EXPANDALL = False
        
        #Set all dates to current now, will get over written if the task has dates set, if not will be current without having to change anything
        currentDate = QDate.currentDate()
        currentTime = QTime.currentTime()                
        self.tabDateDueTime.setTime(QTime.fromString("23:59:59", "hh:mm:ss"))
        self.tabDateDueDate.setDate(currentDate)
        self.tabDateStartTime.setTime(currentTime)
        self.tabDateStartDate.setDate(currentDate)
        self.tabDateCompletionTime.setTime(currentTime)
        self.tabDateCompletionDate.setDate(currentDate)
        
        
        #Track whether to save changes, will not save unless they click "Done" button anyway
        self.__saveChanges = False
        self.__parent = parent
        self.__task = task
        #print self.__task
        self.__qSITask = qSITask
        self.__parentTask = parentTask
        self.__taskModel = taskModel
        self.__etree = etree
        self.__action = None
        self.__qSIRow = qSIRow
        self.__categoryModel = categoryModel
        
        #Edit task - there will be only a task passed (since it is already in the model with a parent)
        if etree == None and parentTask == None:
            self.__action = "modify"
            #print "Modifying an existing task"
            self.loadTaskInfo()
            
        elif parentTask == self.__etree.getroot():
            #New task - there will be a etree & parent item (or something special for a top level item? but no need to load anything, it is a new task)
            self.__action = "newTask"
            #print "Creating a new top level task"
        else: #A parent is passed, so will be adding as a subelement of that parent to the existing etree
            #print "Creating a new subtask"
            self.__action = "newSubtask"
        
        #does not matter what type it is, need to show category listing
        self.initializeCategoriesList()
        
        #Have to set self.__task for the genQSI to work properly
        if self.__task == None:
            self.__task = Element("task")
            #print self.__task
            
        self.__temp0 = self.genQSI()
        self.__temp1 = self.genQSI()
        self.__temp2 = self.genQSI()
        self.__temp3 = self.genQSI()
        self.__temp4 = self.genQSI()
    
    def loadSettings(self):
        self.colors()
        self.icons()
    
    def icons(self):
        global ICONCOMPLETED, ICONOVERDUE, ICONDUESOON, ICONACTIVE
        ICONCOMPLETED = self.settings.geticon("icons", "iconcompleted")
        ICONOVERDUE = self.settings.geticon("icons", "iconoverdue")
        ICONDUESOON = self.settings.geticon("icons", "iconduesoon")
        ICONACTIVE = self.settings.geticon("icons", "iconactive")
        
    def colors(self):
        global COLORCOMPLETED, COLOROVERDUE, COLORDUESOON, COLORACTIVE, COLORACTIVEMAEMO
        COLORCOMPLETED = self.settings.getcolor("color", "completedtasks")
        COLOROVERDUE = self.settings.getcolor("color", "overduetasks")
        COLORDUESOON = self.settings.getcolor("color", "duesoontasks")
        COLORACTIVE = self.settings.getcolor("color", "activetasks")
        COLORACTIVEMAEMO = self.settings.getcolor("color", "activetasksmaemo")
        
    def genQSI(self):
        temp = QStandardItem()
        temp.setData(self.__task)
        temp.setText("task")
        return temp
        
    def loadTaskInfo(self):
        #print "the task is: " + self.__task.attrib["subject"]
        try:
            self.__task.attrib["id"]
        except KeyError:
            self.__task.attrib = []
        else:
            try:
                self.__task.attrib["subject"]
            except KeyError:
                pass
            else:
                self.inputSubject.setText(self.__task.attrib["subject"])
                
            for children in self.__task.getchildren():
                if children.tag == "description":
                    #Get rid of beginning and ending new lines or the text in the box has them
                    children.text = children.text.rstrip()
                    children.text = children.text.lstrip()
                    self.inputDescription.setPlainText(children.text)
            
            try:
                self.__task.attrib["priority"]
            except KeyError:
                pass
            else:
                #print self.__task.attrib["priority"]
                self.priorityInput.setValue(float(self.__task.attrib["priority"]))
                
            try:
                self.__task.attrib["duedate"]
            except KeyError:
                #No duedate, set duedate checkbox to unchecked
                self.tabDateDueDateCheckBox.setChecked(False)
                #Set default date and time to current?
            else:
                self.tabDateDueDateCheckBox.setChecked(True)
                duedateTimeString = self.__task.attrib["duedate"].split(' ')
                dueDateString = duedateTimeString[0]
                dueTimeString = duedateTimeString[1]
                #python way works to parse, but need Qt objects for widgets
                #self.__duedate =  time.strptime(self.__task.attrib["duedate"],"%Y-%m-%d %H:%M:%S")
                
                duedate = QDate.fromString(dueDateString, "yyyy-MM-dd")
                #print date.toString("dd/MM/yyyy")
                self.tabDateDueDate.setDate(duedate)
                if len(dueTimeString) == 8:
                    timeFormat = "hh:mm:ss"
                else:
                    timeFormat = "hh:mm:ss.zzzzzz"
                duetime = QTime.fromString(dueTimeString, timeFormat)
                self.tabDateDueTime.setTime(duetime)
                
            
            try:
                self.__task.attrib["startdate"]
            except KeyError:
                #No startdate, set startdate checkbox to unchecked
                self.tabDateStartDateCheckBox.setChecked(False)
                #Set default date and time to current?
            else:
                self.tabDateStartDateCheckBox.setChecked(True)
                startDateTimeString = self.__task.attrib["startdate"].split(' ')
                startDateString = startDateTimeString[0]
                startTimeString = startDateTimeString[1]
                #python way works to parse, but need Qt objects for widgets
                #self.__startdate =  time.strptime(self.__task.attrib["startdate"],"%Y-%m-%d %H:%M:%S")
                
                startdate = QDate.fromString(startDateString, "yyyy-MM-dd")
                #print date.toString("dd/MM/yyyy")
                self.tabDateStartDate.setDate(startdate)
                if len(startTimeString) == 8:
                    timeFormat = "hh:mm:ss"
                else:
                    timeFormat = "hh:mm:ss.zzzzzz"
                starttime = QTime.fromString(startTimeString, timeFormat)
                self.tabDateStartTime.setTime(starttime)
                
            try:
                self.__task.attrib["completiondate"]
            except KeyError:
                #No completiondate, set completiondate checkbox to unchecked
                self.tabDateCompletionDateCheckBox.setChecked(False)
                #Set default date and time to current?
            else:
                self.tabDateCompletionDateCheckBox.setChecked(True)
                completiondDateTimeString = self.__task.attrib["completiondate"].split(' ')
                completionDateString = completiondDateTimeString[0]
                completionTimeString = completiondDateTimeString[1]
                #python way works to parse, but need Qt objects for widgets
                #self.__completiondate =  time.strptime(self.__task.attrib["completiondate"],"%Y-%m-%d %H:%M:%S")
                #print completionDateString
                completiondate = QDate.fromString(completionDateString, "yyyy-MM-dd")
                #print date.toString("dd/MM/yyyy")
                self.tabDateCompletionDate.setDate(completiondate)
                if len(completionTimeString) == 8:
                    timeFormat = "hh:mm:ss"
                else:
                    #Have to trim the time string sometimes saved by WX, Qt only does 3 milliseconds
                    completionTimeString = completionTimeString[0:12]
                    timeFormat = "hh:mm:ss.z"
                    #print completionTimeString
                completiontime = QTime.fromString(completionTimeString, timeFormat)
                self.tabDateCompletionTime.setTime(completiontime)
                
            for subelement in self.__task:
                if subelement.tag == "recurrence":
                    #print "the subelement is: " + subelement.tag
                    #print "subelement unit is: " + subelement.attrib["unit"]
                    tempRecurUnit = str(subelement.attrib["unit"]).split()[-1]
                    tempRecurUnit = "Recur " + tempRecurUnit.capitalize()
                    #print tempRecurUnit.capitalize() + " is capitalized"
                    index = self.comboBoxRecurrence.findText(tempRecurUnit)
                    
                    if index == -1:
                        print "Error: recurrence unit '" + subelement.attrib["unit"] + "' not found in list"
                    else:
                        self.comboBoxRecurrence.setCurrentIndex(index)
                    try:
                        subelement.attrib["max"]
                    except KeyError:
                        pass
                    else:
                        self.checkBoxMaxRecurrences.setChecked(True)
                        self.spinBoxMaxRecurrences.setValue(int(subelement.attrib["max"]))
                    
                    try:
                        subelement.attrib["amount"]
                    except KeyError:
                        pass
                    else:
                        self.spinBoxRecurrencePeriod.setValue(int(subelement.attrib["amount"]))
                    
                    
                    try:
                        subelement.attrib["sameWeekday"]
                    except KeyError:
                        pass
                    else:
                       self.checkBoxKeepSameWeekday.setChecked(True)

            
            try:
                self.__task.attrib["percentageComplete"]
            except KeyError:
                #No progress
                pass
            else:
                self.percentSlider.setValue(int(self.__task.attrib["percentageComplete"]))
            
                
            #Following creates a time object from the taskcoach date string
            #this =  time.strptime("2007-05-10 00:00:00","%Y-%m-%d %H:%M:%S")
            
            #Following returns parts of that string
            #print time.strftime("%Y-%m-%d", this)
    def initializeCategoriesList(self):
        global EXPANDALL
        if self.__categoryModel != None:
                self.categoryProxy = QSortFilterProxyModel()
                #self.categoryProxy.dynamicSortFilter = True
                self.categoryProxy.setSourceModel(self.__categoryModel)
                self.categoryTreeView.setModel(self.categoryProxy)
                if EXPANDALL:
                    self.categoryTreeView.expandAll()
                self.categoryTreeView.hideColumn(1)
                self.categoryTreeView.sortByColumn(0,QtCore.Qt.AscendingOrder)
                self.__categoryModel.setHeaderData(0, Qt.Horizontal, QVariant("Categories"))
                
                #Need to clear any checked categories that were left if someone closed the window without saving
                self.unCheckAllParents()
                #A task can only have categories assigned to it that existed previously
                #print self.__parent.modelFilter.viewSelectedCategories
                #Now put check mark on any categories that are assigned to this task, or any based on filter when adding tasks
                self.checkParentCategories()
        
    def unCheckAllParents(self):
        for i in range (0, self.__categoryModel.rowCount()):
            #print self.__categoryModel.index(j, 0, self.__categoryModel.indexFromItem(parent))
            itemIndex = self.__categoryModel.index(i, 0)
            self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Unchecked), Qt.CheckStateRole)
            if self.__categoryModel.item(i, 0).hasChildren():
                self.unCheckAllChildren(self.__categoryModel.itemFromIndex(itemIndex))
    
    def unCheckAllChildren(self, parent):
        for j in range (0, self.__categoryModel.rowCount(self.__categoryModel.indexFromItem(parent))):
            #print self.__categoryModel.index(j, 0, self.__categoryModel.indexFromItem(parent))
            itemIndex = self.__categoryModel.index(j, 0, self.__categoryModel.indexFromItem(parent))
            self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Unchecked), Qt.CheckStateRole)
            if self.__categoryModel.itemFromIndex(itemIndex).hasChildren():
                self.unCheckAllChildren(self.__categoryModel.itemFromIndex(itemIndex))
        
    def saveParentCategories(self):
        #Go through top level categories and if checked be sure the id of this task is saved in the categorizable list for said category
        for i in range (0, self.__categoryModel.rowCount()):
            itemIndex = self.__categoryModel.index(i, 0)
            category = self.__categoryModel.itemFromIndex(itemIndex).data().toPyObject()
            #print "Category: " + category.attrib["subject"]
            state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][self.__categoryModel.itemFromIndex(itemIndex).checkState()]
            
            #Keep track of whether we found what we were looking for when adding assigning a category to a task
            found = False
            
            try:
                category.attrib["categorizables"]
            except KeyError:
                #print "nothing in this category yet"
                if state == 'CHECKED':
                    category.attrib["categorizables"] = self.__task.attrib["id"]
                #Need to add the id of this task to categorizables
            else:
                #Get the ids of tasks in this category
                list = category.attrib["categorizables"].split()
                if state == 'CHECKED':
                    #now find out if the id is already in the list (already assigned), but only for an existing task, new tasks or subtasks won't be assigned to any categories
                    if self.__action == "modify":
                        for id in list:
                            if self.__task.attrib["id"] == id:
                                #exit this loop, we found the ID already present
                                found = True
                                #print "found it"
                                break
                    #if it was not already in the list we need to add it
                    if not found == True:
                        #print "did not find it, but adding now"
                        category.attrib["categorizables"] = category.attrib["categorizables"] + " " + self.__task.attrib["id"]
                elif state == 'UNCHECKED':
                    #now find out if the id is already in the list (already assigned), but only for an existing task, new tasks or subtasks won't be assigned any
                    if self.__action == "modify":
                        for id in list:
                            if self.__task.attrib["id"] == id:
                                list.remove(self.__task.attrib["id"])
                                #print 
                                category.attrib["categorizables"] = " ".join(list)
                                
                                break
                                #Do we want to exit loop & assume only 1 occurance of each id is in each categorizable list? Might save a little time, so added break

                    #Go through the ids looking for to see if this task in assigned this category
                    #print "IDs in this category"
                
                #Clear any checks so next task won't show incorrect categories assigned
                self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Unchecked), Qt.CheckStateRole)
                
                if self.__categoryModel.itemFromIndex(itemIndex).hasChildren():
                     self.saveChildCategories(self.__categoryModel.itemFromIndex(itemIndex))
                        
        #Otherwise need to go through the categorizable list and be sure to remove it if it is present
        #Go through all child categories of this parent
        
    def saveChildCategories(self, parent):
        #Go through child level categories and if checked be sure the id of this task is saved in the categorizable list for said category
        for j in range (0, self.__categoryModel.rowCount(self.__categoryModel.indexFromItem(parent))):
            itemIndex = self.__categoryModel.index(j, 0, self.__categoryModel.indexFromItem(parent))
            category = self.__categoryModel.itemFromIndex(itemIndex).data().toPyObject()
            #print "SubCategory: " + category.attrib["subject"]
            state = ['UNCHECKED', 'TRISTATE',  'CHECKED'][self.__categoryModel.itemFromIndex(itemIndex).checkState()]
            
            #Keep track of whether we found what we were looking for when adding assigning a category to a task
            found = False
            
            try:
                category.attrib["categorizables"]
            except KeyError:
                #print "nothing in this category yet"
                if state == 'CHECKED':
                    category.attrib["categorizables"] = self.__task.attrib["id"]
                #Need to add the id of this task to categorizables
            else:
                #Get the ids of tasks in this category
                list = category.attrib["categorizables"].split()
                if state == 'CHECKED':
                    #now find out if the id is already in the list (already assigned), but only for an existing task, new tasks or subtasks won't be assigned any
                    if self.__action == "modify":
                        for id in list:
                            if self.__task.attrib["id"] == id:
                                #exit this loop, we found the ID already present
                                found = True
                                break
                    #if it was not already in the list we need to add it
                    if not found == True:
                        category.attrib["categorizables"] = category.attrib["categorizables"] + " " + self.__task.attrib["id"]
                        #print category.attrib["categorizables"]
                elif state == 'UNCHECKED':
                    #now find out if the id is already in the list (already assigned), but only for an existing task, new tasks or subtasks won't be assigned any
                    if self.__action == "modify":
                        for id in list:
                            if self.__task.attrib["id"] == id:
                                list.remove(self.__task.attrib["id"])
                                category.attrib["categorizables"] = " ".join(list)
                                break
                                #Do we want to exit loop & assume only 1 occurance of each id is in each categorizable list? Might save a little time, so added break
                                
                    #Go through the ids looking for to see if this task in assigned this category
                    #print "IDs in this category"
                 
            #Clear any checks so next task won't show incorrect categories assigned
            self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Unchecked), Qt.CheckStateRole)
            
            #Go through all child categories of this parent
            if self.__categoryModel.itemFromIndex(itemIndex).hasChildren():
                self.saveChildCategories(self.__categoryModel.itemFromIndex(itemIndex))
        
        
    def checkParentCategories(self):
        #Go through top level categories check to see if the ID of the current task is in their categorizable list
        #print self.__task.attrib["id"]
        
        for i in range (0, self.__categoryModel.rowCount()):
            #If it is, that category should be checked
            itemIndex = self.__categoryModel.index(i, 0)
            category = self.__categoryModel.itemFromIndex(itemIndex).data().toPyObject()
            #print "Checking category " + str(i) + " " + category.attrib["subject"]
            try:
                category.attrib["categorizables"]
            except KeyError:
                #print "nothing in this category"
                pass
            else:
                #print "There are items here"
                #Get the ids of tasks in this category
                list = category.attrib["categorizables"].split()
                #Go through the ids looking for to see if this task in assigned this category
                #print "IDs in this category"
                if self.__action == "modify":
                    for id in list:
                        #print id
                        if self.__task.attrib["id"] == id:
                            #print "Assigned category: " + category.attrib["subject"]
                            self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Checked), Qt.CheckStateRole)
                else:
                    #Automatically adding categories if there is a filter applied and this is a newtask or newsubtask
                    for id in self.__parent.modelFilter.viewSelectedCategories:
                        #print id + " is the id from modelFilter.viewSelectedCategories"
                        #print category.attrib["id"] + " is the id category.attrib"
                        if category.attrib["id"] == id:
                            #print "Assigned category: " + category.attrib["subject"]
                            self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Checked), Qt.CheckStateRole)
            
            if self.__categoryModel.item(i, 0).hasChildren():
                self.checkChildCategories(self.__categoryModel.item(i, 0))
        
    def checkChildCategories(self, parent):
        for j in range (0, self.__categoryModel.rowCount(self.__categoryModel.indexFromItem(parent))):
            itemIndex = self.__categoryModel.index(j, 0, self.__categoryModel.indexFromItem(parent))
            category = self.__categoryModel.itemFromIndex(itemIndex).data().toPyObject()
            #print "Checking category " + str(j) + " " + category.attrib["subject"]
            try:
                category.attrib["categorizables"]
            except KeyError:
                #print "nothing in this category"
                pass
            else:
                #print "There are items here"
                #Get the ids of tasks in this category
                list = category.attrib["categorizables"].split()
                #Go through the ids looking for to see if this task in assigned this category
                #print "IDs in this category"
                for id in list:
                    #print id
                    if self.__action == "modify":
                        if self.__task.attrib["id"] == id:
                            #print "Assigned category: " + category.attrib["subject"]
                            self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Checked), Qt.CheckStateRole)
                    else:
                        #Automatically adding categories if there is a filter applied and this is a newtask or newsubtask
                        for id in self.__parent.modelFilter.viewSelectedCategories:
                            #print id + " is the id from modelFilter.viewSelectedCategories"
                            #print category.attrib["id"] + " is the id category.attrib"
                            if category.attrib["id"] == id:
                                #print "Assigned category: " + category.attrib["subject"]
                                self.__categoryModel.itemFromIndex(itemIndex).setData(QVariant(Qt.Checked), Qt.CheckStateRole)
            
            if self.__categoryModel.itemFromIndex(itemIndex).hasChildren():
                self.checkChildCategories(self.__categoryModel.itemFromIndex(itemIndex))
        
        
    @pyqtSignature("int")
    def on_tabDateCompletionDateCheckBox_stateChanged(self, p0):
        """
        Slot documentation goes here.
        """
        if self.tabDateCompletionDateCheckBox.isChecked():
            self.tabDateCompletionTime.setEnabled(True)
            self.tabDateCompletionDate.setEnabled(True)
        else:
            self.tabDateCompletionTime.setEnabled(False)
            self.tabDateCompletionDate.setEnabled(False)
    
    @pyqtSignature("int")
    def on_tabDateStartDateCheckBox_stateChanged(self, p0):
        """
        Slot documentation goes here.
        """
        if self.tabDateStartDateCheckBox.isChecked():
            self.tabDateStartTime.setEnabled(True)
            self.tabDateStartDate.setEnabled(True)
        else:
            self.tabDateStartTime.setEnabled(False)
            self.tabDateStartDate.setEnabled(False)
            
    @pyqtSignature("int")
    def on_tabDateDueDateCheckBox_stateChanged(self, p0):
        """
        Slot documentation goes here.
        """
        if self.tabDateDueDateCheckBox.isChecked():
            self.tabDateDueTime.setEnabled(True)
            self.tabDateDueDate.setEnabled(True)
        else:
            self.tabDateDueTime.setEnabled(False)
            self.tabDateDueDate.setEnabled(False)
            
    @pyqtSignature("")
    def on_buttonOk_released(self):
        """
        Slot documentation goes here.
        """
        if self.__action == "newSubtask": #subtask, append it to the tree
            #print "Making a new subtask"
            self.__task = SubElement(self.__parentTask, "task")
            
            parent_node = self.__qSIRow[0]
            self.__qSIRow = [self.__temp0, self.__temp1, self.__temp2, self.__temp3, self.__temp4]
            parent_node.appendRow(self.__qSIRow)
            
            #set the current QSI task to the first task in that row
            self.__qSITask = self.__temp0
            
            #id(self) should return the python id of an object which is unique, and time.time() is added to further guarantee uniqueness
            #code from original sourse:  self.__id = kwargs.pop('id', None) or '%s:%s'%(id(self), time.time())
            
            #Generate the task id, this  is a new task
            self.__task.set("id", str(id(self)) + ":" + str(time.time()))
            
            self.readFormInfo()
            #print self.__task.attrib["id"]
            
            self.updateTaskModelLabels()
            
            #was re-reading the entire tree each time an item was added, but that is inefficient
            #self.__parent.update()
            index = self.__qSITask.index()
            self.__parent.taskTreeView.selectionModel().setCurrentIndex(self.__parent.model.proxy.mapFromSource(index), QItemSelectionModel.NoUpdate)
            self.__parent.modelFilter.refreshFilter()
            
            #append the list to task model
            #self.__taskModel.appendRow()
        elif self.__action == "newTask": #new root task
            #print "Making a new task"
            self.__task = SubElement(self.__etree.getroot(), "task")
            
            #The parent is the qStandardItem taskModel in this case, cause it is a new item
            parent_node = self.__taskModel
            
            #Generate a blank row
            self.__qSIRow = [self.__temp0, self.__temp1, self.__temp2, self.__temp3, self.__temp4]
            #append the qStandardItemModel row
            parent_node.appendRow(self.__qSIRow)
            #set the current QSI task to the first task in that row
            self.__qSITask = self.__temp0
            
            #Generate the task id, this  is a new task
            self.__task.set("id", str(id(self)) + ":" + str(time.time()))
            
            self.readFormInfo()
            
            #Append the task to the 
            #self.__taskModel.appendRow(self.__task)
            
            self.updateTaskModelLabels()
            #if it is the first task, need to update taskview so column headers get set correctly
            if self.__taskModel.rowCount() == 1:
                self.__parent.updateTaskView()
            
            #was re-reading the entire tree each time an item was added, but that is inefficient
            #self.__parent.update()
            index = self.__qSITask.index()
            self.__parent.taskTreeView.selectionModel().setCurrentIndex(self.__parent.model.proxy.mapFromSource(index), QItemSelectionModel.NoUpdate)
            self.__parent.modelFilter.refreshFilter()
        
            
        else:  #action is modify
            #Just read the form info and modify the existing task item
            self.readFormInfo()
            self.updateTaskModelLabels()
        
        self.__saveChanges = True
        if self.__saveChanges:
            pass
            #print "save those changes"
            #self.__parent.update()
            #self.__parent.setUpModel()
        self.__parent.modelFilter.filterTasks()
        self.__parent.autoSave()
        self.close()
    
    def updateTaskModelLabels(self):
        global maemo5
        completed = False
        overdue = False
        dueToday = False
        #print subelement.attrib
        self.__parent.model.setUpdatingModel(True)
        
        try:
            self.__task.attrib["subject"]
        except KeyError:
            #Just a closing tag, not a valid task
            pass
        else:
            try:
                self.__task.attrib["completiondate"]
            except KeyError:
                check = Qt.Unchecked
                completed = False
            else:
                #print self.__task.attrib["completiondate"]
                check = Qt.Checked
                completed = True
            self.__qSITask.setData(QVariant(check), Qt.CheckStateRole)
            
            #root_subject = QStandardItem()
            root_subject = self.__qSIRow[0]
            root_subject.setData(self.__task)
            root_subject.setText(self.__task.attrib["subject"])
            
            #ItemIsSelectable was needed on the first row, or did not highlight the whole row when it was selected
            root_subject.setFlags(Qt.ItemIsUserCheckable | Qt.ItemIsEnabled | Qt.ItemIsSelectable) 
            
            #root_priority = QStandardItem()
            root_priority = self.__qSIRow[3]
            root_priority.setData(self.__task)
            try:
                self.__task.attrib["priority"]
            except KeyError:
                root_priority.setText("")
            else:
                root_priority.setText(self.__task.attrib["priority"])
            
            root_id = self.__qSIRow[4]
            root_id.setData(self.__task)
            try:
                self.__task.attrib["id"]
            except KeyError:
                root_id.setText("")
            else:
                root_id.setText(self.__task.attrib["id"])
            
            #root_startdate = QStandardItem()
            root_startdate = self.__qSIRow[1]
            root_startdate.setData(self.__task)
            try:
                self.__task.attrib["startdate"]
            except KeyError:
                root_startdate.setText("")
            else:
                startdateTimeString = self.__task.attrib["startdate"].split(' ')
                startDateString = startdateTimeString[0]
                root_startdate.setText(startDateString)
                
            #root_duedate = QStandardItem()
            root_duedate = self.__qSIRow[2]
            root_duedate.setData(self.__task)
            try:
                self.__task.attrib["duedate"]
            except KeyError:
                root_duedate.setText("")
            else:
                duedateTimeString = self.__task.attrib["duedate"].split(' ')
                dueDateString = duedateTimeString[0]
                root_duedate.setText(dueDateString)
                duedateObject = QDate.fromString(dueDateString, "yyyy-MM-dd")
                
                if duedateObject == QDate.currentDate():
                    dueToday = True
                elif duedateObject < QDate.currentDate():
                    overdue = True
            
            if completed == True:
                self.__parent.changeRowColor(self.__qSITask, COLORCOMPLETED, ICONCOMPLETED)
                #root_subject.setForeground(QBrush(QColor(Qt.green)))
                #root_startdate.setForeground(QBrush(QColor(Qt.green)))
                #root_duedate.setForeground(QBrush(QColor(Qt.green)))
                #root_priority.setForeground(QBrush(QColor(Qt.green)))
            elif overdue == True:
                self.__parent.changeRowColor(self.__qSITask, COLOROVERDUE, ICONOVERDUE)
#                root_subject.setForeground(QBrush(QColor(Qt.red)))
#                root_startdate.setForeground(QBrush(QColor(Qt.red)))
#                root_duedate.setForeground(QBrush(QColor(Qt.red)))
#                root_priority.setForeground(QBrush(QColor(Qt.red)))
            elif dueToday == True:
                self.__parent.changeRowColor(self.__qSITask, COLORDUESOON, ICONDUESOON)
#                root_subject.setForeground(QBrush(QColor(255, 153, 0)))
#                root_startdate.setForeground(QBrush(QColor(255, 153, 0)))
#                root_duedate.setForeground(QBrush(QColor(255, 153, 0)))
#                root_priority.setForeground(QBrush(QColor(255, 153, 0)))
            else:
                if maemo5:
                    self.__parent.changeRowColor(self.__qSITask, COLORACTIVEMAEMO, ICONACTIVE)
                else:
                    self.__parent.changeRowColor(self.__qSITask, COLORACTIVE, ICONACTIVE)
        
            
            self.__qSIRow[0].setText(root_subject.text())
            self.__qSIRow[1].setText(root_startdate.text())
            self.__qSIRow[2].setText(root_duedate.text())
            self.__qSIRow[3].setText(root_priority.text())
            self.__qSIRow[4].setText(root_id.text())
            
            self.__parent.sortModel()

        self.__parent.model.setUpdatingModel(False)
    
            #self.__taskModel.appendRow(root_subject)
            #curPosition = self.__taskModel.indexFromItem(root_subject)
            #self.__taskModel.setItem(curPosition.row(),  curPosition.column()+1,  root_startdate)
            #self.__taskModel.setItem(curPosition.row(),  curPosition.column()+2,  root_duedate)
            #self.__taskModel.setItem(curPosition.row(),  curPosition.column()+3,  root_priority)

            #------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
        
    def readFormInfo(self):
        #Set the task subject to the subject from the form, cast as str or elementtree won't know how to deal with it
        #TODO: testing to see if need to save values (don't create empty values)
        complete = False
        self.__task.set("subject", str(self.inputSubject.text()))
        #self.__task.set("description", str(self.inputDescription.toPlainText()))
        if self.priorityInput.value() != 0:
            self.__task.set("priority", str(self.priorityInput.value()))
        else:
            #remove priority if it exists already for the task and the value is set to 0
            try:
                self.__task.attrib["priority"]
            except KeyError:
                #Attribute isn't here, no need to delete
                pass
            else:
                del self.__task.attrib["priority"]

        #Check if we are marking as complete, it changes how dates and progress are handled
        #If either percent or completion date are set to finished, need to set the other
        if self.percentSlider.value() == 100:
            #print "Marking complete: slider"
            self.tabDateCompletionDateCheckBox.setChecked(True)
            complete = True
        elif self.tabDateCompletionDateCheckBox.isChecked():
            #print "Marking complete: completion date"
            self.percentSlider.setValue(100)
            complete = True
            

        #Check for recurrence, it changes how dates are handled below
        if self.comboBoxRecurrence.currentText() == "No Recurrence":
            #print "No recurrence"
            recur = False
            #if recurrence is not enabled in form, remove it from task if presenting
            for recurElement in self.__task:
                if recurElement.tag == "recurrence":
                    self.__task.remove(recurElement)
        else: #it is set to some kind of recurrence, add if not present
            #print "Recurrence"
            recurInFile = False
            recur = True
            count = 0
            for recurElement in self.__task:
                if recurElement.tag == "recurrence":
                    recurInFile = True
            if not recurInFile:
                #Need to add recurrence sub element to task
                #print "No recurrence in file yet for this task, adding"
                recurElement = SubElement(self.__task, "recurrence")
            
            #sameWeekday
            try:
                recurElement.attrib["sameWeekday"]
            except KeyError:
                #not set
                if (self.checkBoxKeepSameWeekday.isChecked()):
                        recurElement.set("sameWeekday","True")
            else:
                if (self.checkBoxKeepSameWeekday.isChecked()):
                    recurElement.set("sameWeekday","True")
                else:
                    del recurElement.attrib["sameWeekday"]
                    
            try:
                recurElement.attrib["count"]
            except KeyError:
                #no count
                count = 0
                if complete:
                    if self.checkBoxMaxRecurrences.isChecked():
                        recurElement.set("count","1")
            else:
                count = int(recurElement.attrib["count"])
                if complete:
                    #print "Count was: " + str(count)
                    #increment count here if marking complete
                    #print "Count now is: " + str(int(count) + 1)
                    recurElement.set("count",str(int(count) + 1))
                    count = int(recurElement.attrib["count"])
            try:
                recurElement.attrib["max"]
            except KeyError:
                maxCount = 0
                #no max
                if self.checkBoxMaxRecurrences.isChecked():
                    recurElement.set("max", str(self.spinBoxMaxRecurrences.value()))
                    maxCount = self.spinBoxMaxRecurrences.value()
            else:
                #max = recurElement.attrib["max"]
                #print "Max is: " + str(self.spinBoxMaxRecurrences.value())
                if self.checkBoxMaxRecurrences.isChecked():
                    recurElement.set("max", str(self.spinBoxMaxRecurrences.value()))
                    maxCount = self.spinBoxMaxRecurrences.value()
                else:
                    del recurElement.attrib["max"]
                    
            try:
                recurElement.attrib["unit"]
            except KeyError:
                #no unit yet
                if (self.comboBoxRecurrence.currentText() != "No Recurrence"):
                    if self.comboBoxRecurrence.currentText() == "Recur Daily":
                        recurElement.set("unit", "daily")
                    elif self.comboBoxRecurrence.currentText() == "Recur Weekly":
                        recurElement.set("unit", "weekly")
                    elif self.comboBoxRecurrence.currentText() == "Recur Monthly":
                        recurElement.set("unit", "monthly")
                    else:
                        recurElement.set("unit", "yearly")
  
            else:
                #print "Unit is: " + str(self.comboBoxRecurrence.currentText())
                if (self.comboBoxRecurrence.currentText() != "No Recurrence"):
                    if self.comboBoxRecurrence.currentText() == "Recur Daily":
                        recurElement.set("unit", "daily")
                    elif self.comboBoxRecurrence.currentText() == "Recur Weekly":
                        recurElement.set("unit", "weekly")
                    elif self.comboBoxRecurrence.currentText() == "Recur Monthly":
                        recurElement.set("unit", "monthly")
                    else:
                        recurElement.set("unit", "yearly")
                else:
                    del recurElement.attrib["unit"]
            
            try:
                recurElement.attrib["amount"]
            except KeyError:
                #no amount in file
                if (self.spinBoxRecurrencePeriod.value() > 1):
                    recurElement.set("amount", str(self.spinBoxRecurrencePeriod.value()))
            else:
                if (self.spinBoxRecurrencePeriod.value() > 1):
                    recurElement.set("amount", str(self.spinBoxRecurrencePeriod.value()))
                else:
                    del recurElement.attrib["amount"]
      

        #Set duedate
        if self.tabDateDueDateCheckBox.isChecked():
            duedateDate = self.tabDateDueDate.date().toString("yyyy-MM-dd")
            #print duedateDate
            if self.tabDateDueTime.time().toString("zzzzzz") == "000000":
                duedateTime = self.tabDateDueTime.time().toString("hh:mm:ss")
            else:
                duedateTime = self.tabDateDueTime.time().toString("hh:mm:ss.zzzzzz")
            self.__task.set("duedate", str(duedateDate + " " + duedateTime))
        else:
            try:
                self.__task.attrib["duedate"]
            except KeyError:
                #Attribute isn't here, cannot delete
                pass
            else:
                del self.__task.attrib["duedate"]
        
        #Set startdate
        if self.tabDateStartDateCheckBox.isChecked():
            startdateDate = self.tabDateStartDate.date().toString("yyyy-MM-dd")
            if self.tabDateStartTime.time().toString("zzzzzz") == "000000":
                startdateTime = self.tabDateStartTime.time().toString("hh:mm:ss")
            else:
                startdateTime = self.tabDateStartTime.time().toString("hh:mm:ss.zzzzzz")
            self.__task.set("startdate", str(startdateDate + " " + startdateTime))
        else:
            #delete start date if there was one, now we don't want it
            try:
                self.__task.attrib["startdate"]
            except KeyError:
                #Attribute isn't here, cannot delete
                pass
            else:
                del self.__task.attrib["startdate"]
            

        #Set completiondate
        if self.tabDateCompletionDateCheckBox.isChecked():
            completiondateDate = self.tabDateCompletionDate.date().toString("yyyy-MM-dd")
            if self.tabDateCompletionTime.time().toString("zzzzzz") == "000000":
                completiondateTime = self.tabDateCompletionTime.time().toString("hh:mm:ss")
            else:
                completiondateTime = self.tabDateCompletionTime.time().toString("hh:mm:ss.zzzzzz")
            self.__task.set("completiondate", str(completiondateDate + " " + completiondateTime))
        else:
            #delete completion date if there was one, now we don't want it
            try:
                self.__task.attrib["completiondate"]
            except KeyError:
                #Attribute isn't here, cannot delete
                pass
            else:
                del self.__task.attrib["completiondate"]

        #Set progress
        if self.percentSlider.value() > 0:
            #print self.percentSlider.value()
            self.__task.attrib["percentageComplete"] = str(self.percentSlider.value())
            #TODO: need to set to completed if this is set to 100% - Yes at least TC 1.2.6 does
        else:
            #need to remove any progress the task has since it is set to 0
            try:
                self.__task.attrib["percentageComplete"]
            except KeyError:
                #Attribute isn't here, cannot delete
                pass
            else:
                del self.__task.attrib["percentageComplete"]
            #print "There is no progress"


        
        #Recurrance
        #if progress is set to 100 or completion date is set, handle recurrance
        if complete and recur:
            #print "This recurring task is not done yet"
            if count < maxCount:
                #change start date and duedate to next recurance time
                #self.__task.set("startdate", str(startdateDate + " " + startdateTime))
                #self.__task.set("duedate", str(duedateDate + " " + duedateTime))
                #clear completion date
                try:
                    self.__task.attrib["completiondate"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    del self.__task.attrib["completiondate"]
                #clear progress
                try:
                    self.__task.attrib["progress"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    del self.__task.attrib["progress"]
            #if count == max remove recurrance subelement and just make due 1 more time at next reoccurance time (start date and due date), clear progress
            if count == maxCount:
                #clear completion date
                try:
                    self.__task.attrib["completiondate"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    del self.__task.attrib["completiondate"]
                #clear progress
                try:
                    self.__task.attrib["progress"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    del self.__task.attrib["progress"]
            #print dir(recurElement)
            
            if (count >= maxCount) and (maxCount <= 0):
                try:
                    self.__task.attrib["completiondate"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    del self.__task.attrib["completiondate"]
                #clear progress
                try:
                    self.__task.attrib["progress"]
                except KeyError:
                    #Attribute isn't here, cannot delete
                    pass
                else:
                    del self.__task.attrib["progress"]
                    
            if (count >= maxCount) and (maxCount > 0):
                #remove recurrence, it is finished
                self.__task.remove(recurElement)
            
            #print "Calculate next occurance"
            #get recurrence period
            recurPeriod = self.spinBoxRecurrencePeriod.value()
            #get recurrance unit (days,weeks,months,years)
            if self.comboBoxRecurrence.currentText() == "Recur Daily":
                recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(days=+recurPeriod)
                recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(days=+recurPeriod)
            elif self.comboBoxRecurrence.currentText() == "Recur Weekly":
                recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(weeks=+recurPeriod)
                recurDue = parser.parse(str(startdateDate)) + relativedelta.relativedelta(weeks=+recurPeriod)
            elif self.comboBoxRecurrence.currentText() == "Recur Monthly":
                if self.checkBoxKeepSameWeekday.isChecked():
                    #print "Same weekday"
                    #print date.weekday(parser.parse(str(startdateDate)))
                    wkday = date.weekday(parser.parse(str(startdateDate)))
                    recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(months=+recurPeriod, weekday=wkday)
                    recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(months=+recurPeriod, weekday=wkday)
                else:
                    recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(months=+recurPeriod)
                    recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(months=+recurPeriod)
            else: #Yearly
                if self.checkBoxKeepSameWeekday.isChecked():
                    #print "Same weekday"
                    wkday = date.weekday(parser.parse(str(startdateDate)))
                    recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(years=+recurPeriod, weekday=wkday)
                    recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(years=+recurPeriod, weekday=wkday)
                else:
                    recurStart = parser.parse(str(startdateDate)) + relativedelta.relativedelta(years=+recurPeriod)
                    recurDue = parser.parse(str(duedateDate)) + relativedelta.relativedelta(years=+recurPeriod)
            #print str(recurStart) + " " + startdateTime
            self.__task.set("startdate", str(recurStart) + " " + startdateTime)
            #print str(recurStart) + " " + duedateTime
            self.__task.set("duedate", str(recurDue) + " " + duedateTime)
            
            
            #if not keep same weekday
                #add number of units to existing start date
            #print startdateDate + relativedelta.relativedelta(recurType=+recurPeriod)
                #existing start date + datetime.timedelta(unit=number)
                #add number of units to existing due date
                #existing due date + datetime.timedelta(unit=number)
        #else keep same weekday
            #sameWeekday calc and add number of units to existing start date
            #sdExistingDay = get existing duedate weekday
            #existing start date + datetime.relativedelta(unit=number,weekday=sdExistingDay) 
            #sameWeekday calc and add number of units to existing due date
            #ddExistingDay = get existing duedate weekday
            #existing duedate + datetime.relativedelta(unit=number,weekday=ddExistingDay)

	



        #description
        #print self.inputDescription.toPlainText()
        if self.inputDescription.toPlainText() == "":
            pass
            #print "there is no description"
            #for children in self.__task.getchildren():
               # if children.tag == "description":
                  #  self.__task.remove(children)
        else:
            descriptionSet = False
            #print self.inputDescription.toPlainText()
            for children in self.__task.getchildren():
                if children.tag == "description":
                    descriptionSet = True
                    children.text = str(self.inputDescription.toPlainText())
                    break
            if not descriptionSet == True:
                description = SubElement(self.__task,"description")
                description.text = str(self.inputDescription.toPlainText())
        
        
        #Save any categories this task is labeled with and remove any it is not (but may have had in the past)
        self.saveParentCategories()
        
    @pyqtSignature("")
    def on_centralWidget_destroyed(self):
        """
        Slot documentation goes here.
        """
        # not implemented yet
    
    @pyqtSignature("QString")
    def on_comboBoxRecurrence_currentIndexChanged(self, p0):
        """
        Slot documentation goes here.
        """
        if p0 == "No Recurrence":
            self.spinBoxRecurrencePeriod.setEnabled(False)
            self.checkBoxMaxRecurrences.setEnabled(False)
            #self.spinBoxMaxRecurrences.setEnabled(False)
            self.checkBoxKeepSameWeekday.setEnabled(False)
            self.labelRecurrencePeriod.setText("period")
        else:
            self.spinBoxRecurrencePeriod.setEnabled(True)
            self.checkBoxMaxRecurrences.setEnabled(True)
            #self.spinBoxMaxRecurrences.setEnabled(True)
            if p0 == "Recur Daily":
                self.labelRecurrencePeriod.setText("day(s)")
                self.checkBoxKeepSameWeekday.setEnabled(False)
            elif p0 == "Recur Weekly":
                self.labelRecurrencePeriod.setText("week(s)")
                self.checkBoxKeepSameWeekday.setEnabled(False)
            elif p0 == "Recur Monthly":
                self.labelRecurrencePeriod.setText("month(s)")
                self.checkBoxKeepSameWeekday.setEnabled(True)
            if p0 == "Recur Yearly":
                self.labelRecurrencePeriod.setText("year(s)")
                self.checkBoxKeepSameWeekday.setEnabled(True)
    
    @pyqtSignature("int")
    def on_checkBoxMaxRecurrences_stateChanged(self, p0):
        """
        Slot documentation goes here.
        """
        if self.checkBoxMaxRecurrences.isChecked():
            self.spinBoxMaxRecurrences.setEnabled(True)
        else:
            self.spinBoxMaxRecurrences.setEnabled(False)
    
    @pyqtSignature("")
    def on_btnTabPrevious_released(self):
        """
        Slot documentation goes here.
        """
        if self.stackedWidget.currentIndex() > 0:
            prevTab = self.stackedWidget.currentIndex()-1
            self.stackedWidget.setCurrentIndex(prevTab)
            self.comboBoxSwitchPage.setCurrentIndex(prevTab)
            #self.btnTabPrevious.setText("< " +self.comboBoxSwitchPage.itemText(prevTab-1))
        else:
            self.stackedWidget.setCurrentIndex(self.stackedWidget.count()-1)
            self.comboBoxSwitchPage.setCurrentIndex(self.stackedWidget.count()-1)
            #self.btnTabPrevious.setText("< " +self.comboBoxSwitchPage.itemText(self.stackedWidget.count()-1))
    
    @pyqtSignature("")
    def on_btnTabNext_released(self):
        """
        Slot documentation goes here.
        """
        if self.stackedWidget.currentIndex() < self.stackedWidget.count()-1:
            nextTab = self.stackedWidget.currentIndex()+1
            self.stackedWidget.setCurrentIndex(nextTab)
            self.comboBoxSwitchPage.setCurrentIndex(nextTab)
            #self.btnTabNext.setText(self.comboBoxSwitchPage.itemText(nextTab+1) + " >")
        else:
            self.stackedWidget.setCurrentIndex(0)
            self.comboBoxSwitchPage.setCurrentIndex(0)
            #self.btnTabNext.setText(self.comboBoxSwitchPage.itemText(0) + " >")
            
        #print self.stackedWidget.count()
        #print self.stackedWidget.currentIndex()
        #print self.stackedWidget.currentWidget()

    @pyqtSignature("")
    def on_desktop_resized(self):
        screenGeometry = QApplication.desktop().screenGeometry()
        #print screenGeometry
        
        if (screenGeometry.height() > screenGeometry.width()):
            #print "Do portrait layout"
            #print self.centralWidget.width()
            
            #set formLayout on Description Page to wrap rows
            self.formLayout.setRowWrapPolicy(QFormLayout.WrapAllRows)
            #set formLayout on Progress Page to wrap rows
            self.formLayout_2.setRowWrapPolicy(QFormLayout.WrapAllRows)
            #self.centralWidget.resize(480, 770)
            
            self.gridLayout.removeWidget(self.tabDateStartDateCheckBox)
            self.gridLayout.addWidget(self.tabDateStartDateCheckBox, 0, 0, 1, 1)
            self.gridLayout.removeWidget(self.tabDateStartDate)
            self.gridLayout.addWidget(self.tabDateStartDate, 1, 0, 1, 2)
            self.gridLayout.removeWidget(self.tabDateStartTime)
            self.gridLayout.addWidget(self.tabDateStartTime, 0, 1, 1, 1)
            #self.gridLayout.addWidget(self.tabDateStartTime, 0, 2, Qt.AlignHCenter)
            self.gridLayout.removeWidget(self.tabDateDueDateCheckBox)
            self.gridLayout.addWidget(self.tabDateDueDateCheckBox, 2, 0, 1, 1)
            self.gridLayout.removeWidget(self.tabDateDueDate)
            self.gridLayout.addWidget(self.tabDateDueDate, 3, 0, 1, 2)
            self.gridLayout.removeWidget(self.tabDateDueTime)
            self.gridLayout.addWidget(self.tabDateDueTime, 2, 1, 1, 1)
            self.gridLayout.removeWidget(self.tabDateCompletionDateCheckBox)
            self.gridLayout.addWidget(self.tabDateCompletionDateCheckBox, 4, 0, 1, 1)
            self.gridLayout.removeWidget(self.tabDateCompletionDate)
            self.gridLayout.addWidget(self.tabDateCompletionDate, 5, 0, 1, 2)
            self.gridLayout.removeWidget(self.tabDateCompletionTime)
            self.gridLayout.addWidget(self.tabDateCompletionTime, 4, 1, 1, 1)
            self.gridLayout.removeWidget(self.comboBoxRecurrence)
            self.gridLayout.addWidget(self.comboBoxRecurrence, 9, 0, 1, 1)
            self.gridLayout.removeWidget(self.spinBoxRecurrencePeriod)
            self.gridLayout.addWidget(self.spinBoxRecurrencePeriod, 10, 0, 1, 1)
            self.gridLayout.removeWidget(self.labelRecurrencePeriod)
            self.gridLayout.addWidget(self.labelRecurrencePeriod, 10, 1, 1, 1)
            self.gridLayout.removeWidget(self.checkBoxMaxRecurrences)
            self.gridLayout.addWidget(self.checkBoxMaxRecurrences, 11, 0, 1, 1)
            self.gridLayout.removeWidget(self.spinBoxMaxRecurrences)
            self.gridLayout.addWidget(self.spinBoxMaxRecurrences, 11, 1, 1, 1)
            self.gridLayout.removeWidget(self.checkBoxKeepSameWeekday)
            self.gridLayout.addWidget(self.checkBoxKeepSameWeekday, 12, 0, 1, 1)

            
        else:
            #set formLayout on Description Page to not wrap rows
            self.formLayout.setRowWrapPolicy(QFormLayout.DontWrapRows)
            #set formLayout on Progress Page to not wrap rows
            self.formLayout_2.setRowWrapPolicy(QFormLayout.DontWrapRows)
            #print "Do landscape layout" 
            
            #self.centralWidget.resize(800, 430)
            
            self.gridLayout.removeWidget(self.tabDateStartDateCheckBox)
            self.gridLayout.addWidget(self.tabDateStartDateCheckBox, 0, 0, 1, 1)
            self.gridLayout.removeWidget(self.tabDateStartDate)
            self.gridLayout.addWidget(self.tabDateStartDate, 0, 1, 1, 1)
            self.gridLayout.removeWidget(self.tabDateStartTime)
            self.gridLayout.addWidget(self.tabDateStartTime, 0, 2, 1, 1)
            #self.gridLayout.addWidget(self.tabDateStartTime, 0, 2, Qt.AlignHCenter)
            self.gridLayout.removeWidget(self.tabDateDueDateCheckBox)
            self.gridLayout.addWidget(self.tabDateDueDateCheckBox, 3, 0, 1, 1)
            self.gridLayout.removeWidget(self.tabDateDueDate)
            self.gridLayout.addWidget(self.tabDateDueDate, 3, 1, 1, 1)
            self.gridLayout.removeWidget(self.tabDateDueTime)
            self.gridLayout.addWidget(self.tabDateDueTime, 3, 2, 1, 1)
            self.gridLayout.removeWidget(self.tabDateCompletionDateCheckBox)
            self.gridLayout.addWidget(self.tabDateCompletionDateCheckBox, 6, 0, 1, 1)
            self.gridLayout.removeWidget(self.tabDateCompletionDate)
            self.gridLayout.addWidget(self.tabDateCompletionDate, 6, 1, 1, 1)
            self.gridLayout.removeWidget(self.tabDateCompletionTime)
            self.gridLayout.addWidget(self.tabDateCompletionTime, 6, 2, 1, 1)
            self.gridLayout.removeWidget(self.comboBoxRecurrence)
            self.gridLayout.addWidget(self.comboBoxRecurrence, 7, 0, 1, 1)
            self.gridLayout.removeWidget(self.spinBoxRecurrencePeriod)
            self.gridLayout.addWidget(self.spinBoxRecurrencePeriod, 7, 1, 1, 1)
            self.gridLayout.removeWidget(self.labelRecurrencePeriod)
            self.gridLayout.addWidget(self.labelRecurrencePeriod, 7, 2, 1, 1)
            self.gridLayout.removeWidget(self.checkBoxMaxRecurrences)
            self.gridLayout.addWidget(self.checkBoxMaxRecurrences, 8, 0, 1, 1)
            self.gridLayout.removeWidget(self.spinBoxMaxRecurrences)
            self.gridLayout.addWidget(self.spinBoxMaxRecurrences, 8, 1, 1, 1)
            self.gridLayout.removeWidget(self.checkBoxKeepSameWeekday)
            self.gridLayout.addWidget(self.checkBoxKeepSameWeekday, 8, 2, 1, 1)
